/* tcpswc.c - ATMTCP switch control */

/* Written 1998 by Werner Almesberger, EPFL ICA */


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>

#include <atm.h>
#include <atmd.h>

#include "tcpswc.h"


static void dialog(int s,TCPSWC_MSG *msg)
{
    int size;

    size = write(s,msg,sizeof(*msg));
    if (size < 0) {
	perror("write");
	exit(1);
    }
    if (size != sizeof(*msg)) {
	fprintf(stderr,"bad write: %d != %d\n",size,sizeof(*msg));
	exit(1);
    }
    size = read(s,msg,sizeof(*msg));
    if (size < 0) {
	perror("read");
	exit(1);
    }
    if (size != sizeof(*msg)) {
	fprintf(stderr,"bad read: %d != %d\n",size,sizeof(*msg));
	exit(1);
    }
}


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s <socket> <command>\n",name);
    fprintf(stderr,"  commands: show\n");
    fprintf(stderr,"            add <in_pvc> <out_pvc>\n");
    fprintf(stderr,"            del <in_pvc> <out_pvc>\n");
    exit(1);
}


int main(int argc,const char **argv)
{
    char buffer[MAX_ATM_ADDR_LEN+1];
    TCPSWC_MSG msg;
    int s;

    if (argc < 3) usage(*argv);
    s = un_attach(argv[1]);
    if (s < 0) {
	perror(argv[1]);
	return 1;
    }
    memset(&msg,0,sizeof(msg));
    if (!strcmp(argv[2],"show")) {
	if (argc != 3) usage(*argv);
	msg.type = tmt_get;
	msg.n = 0;
	while (1) {
	    dialog(s,&msg);
	    if (msg.type != tmt_get) {
		fprintf(stderr,"unexpeced message type %d != %d\n",msg.type,
		  tmt_get);
	    }
	    if (msg.n < 0) return 0;
	    if (msg.in.sap_addr.vci != ATM_VCI_UNSPEC) printf("VC ");
	    else {
		printf("VP ");
		msg.out.sap_addr.vci = ATM_VCI_UNSPEC;
	    }
	    if (atm2text(buffer,sizeof(buffer),(struct sockaddr *) &msg.in,
	      A2T_PRETTY) < 0) strcpy(buffer,"<invalid>");
	    printf("%s -> ",buffer);
	    if (atm2text(buffer,sizeof(buffer),(struct sockaddr *) &msg.out,
	      A2T_PRETTY) < 0) strcpy(buffer,"<invalid>");
	    printf("%s\n",buffer);
	    msg.n++;
	}
    }
    if (!strcmp(argv[2],"add")) msg.type = tmt_add;
    else if (!strcmp(argv[2],"del")) msg.type = tmt_del;
        else usage(*argv);
    if (argc != 5) usage(*argv);
    if (text2atm(argv[3],(struct sockaddr *) &msg.in,sizeof(msg.in),
      T2A_PVC | T2A_UNSPEC | T2A_NAME) < 0) {
	fprintf(stderr,"invalid PVC address: %s\n",argv[3]);
	return 1;
    }
    if (text2atm(argv[4],(struct sockaddr *) &msg.out,sizeof(msg.out),
      T2A_PVC | T2A_UNSPEC | T2A_NAME) < 0) {
	fprintf(stderr,"invalid PVC address: %s\n",argv[4]);
	return 1;
    }
    dialog(s,&msg);
    if (msg.n < 0) {
	fprintf(stderr,"%s\n",strerror(-msg.n));
	return 1;
    }
    return 0;
}
