/*************************************************************************
  (c) Copyright.  Digital Equipment Corporation, 1995.  All Rights
  Reserved.

  Permission is hereby granted to use, copy, modify, or enhance this 
  software freely, as long as the foregoing copyright of Digital Equipment
  Corporation and this notice are retained on the software.  This 
  software may not be distributed or sublicensed for a fee.  Digital      
  makes this software available "AS IS" and without warranties of any
  kind.  
 *************************************************************************/
/*
 * Marko Kiiskila carnil@cs.tut.fi 
 * 
 * Tampere University of Technology - Telecommunications Laboratory
 *
 * Permission to use, copy, modify and distribute this
 * software and its documentation is hereby granted,
 * provided that both the copyright notice and this
 * permission notice appear in all copies of the software,
 * derivative works or modified versions, and any portions
 * thereof, that both notices appear in supporting
 * documentation, and that the use of this software is
 * acknowledged in any publications resulting from using
 * the software.
 * 
 * TUT ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION AND DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS
 * SOFTWARE.
 * 
 */

/*
* Module Name:
*   svc_info.h
*   
* Abstract:
*  This header file describes the information elements needed to support the
*  svc to connection manager interface.
*
* Authors:
*  JAD - John A. DeNisco
*
* Modification History:
*
* Description:
*
*/
#ifndef SVC_INFO_H
#define SVC_INFO_H

#include <atm.h>

/* Cause Values */

#define CAUSE_NORMAL                     31

/*++
 * CONN_INFO
 *
 * This structure contains all of the information needed to setup a a virtual
 * connection.
 *
 --*/
typedef struct {
  struct sockaddr_atmsvc addr;
  struct atm_blli blli;
  struct atm_qos conqos;
} CONN_INFO;

/*++
 * =====================
 * = svcinit_conn_info =
 * =====================
 *
 * Overview:
 *  This function initilizes the connection information structure.
 *  Initilization simply involves setting all the present flags to 
 *  "not present".
 *
 * Arguments:
 *
 *  p_svc_conn_info - Pointer to the connection information.
 *
 * Returns:
 *
 * None
 *
 --*/
void svcinit_conn_info (CONN_INFO *p_svc_conn_info);


#endif /* SVC_INFO_H */






