%{
/* ql.y - Q.2931 data structures description language */

/* Written 1995 by Werner Almesberger, EPFL-LRC */


#include <stdlib.h>

#include "common.h"
#include "qgen.h"
#include "file.h"


typedef struct _macro {
    const char *id;
    ITEM *block;
    struct _macro *next;
} MACRO;


ITEM *def = NULL;
static MACRO *macros = NULL;

%}

%union {
    const char *str;
    int num;
    ITEM *item;
    VALUE *value;
    TAG *tag;
};

%token		TOK_CASE TOK_DEF TOK_DEFAULT TOK_LENGTH TOK_MULTI
%token <str>	TOK_ID TOK_INCLUDE

%type <item>	block items item item_cont
%type <num>	opt_pos decimal opt_more
%type <value>	opt_val value
%type <tag>	tags
%type <str>	opt_id

%%

all:
    includes macros block
	{
	    MACRO *walk;

	    def = $3;
	    for (walk = macros; walk; walk = walk->next)
		fprintf(stderr,"unused macro: %s\n",walk->id);
	}
    ;

includes:
    | TOK_INCLUDE includes
	{
	    to_c("#%s\n",$1);
	}
    ;

macros:
    | macros macro
    ;

macro:
    TOK_DEF TOK_ID '=' block
	{
	    MACRO *n;

	    n = alloc_t(MACRO);
	    n->id = $2;
	    n->block = $4;
	    n->next = macros;
	    macros = n;
	}
    ;

block:
    TOK_ID ';'
	{
	    MACRO **walk,*next;

	    for (walk = &macros; *walk; walk = &(*walk)->next)
		if ((*walk)->id == $1) break;
	    if (!*walk) yyerror("no such macro");
	    $$ = (*walk)->block;
	    next = (*walk)->next;
	    free(*walk);
	    *walk = next;
	}
    | '{' items '}'
	{
	    $$ = $2;
	}
    ;

items:
	{
	    $$ = NULL;
	}
    | item items
	{
	    $$ = $1;
	    $1->next = $2;
	}
    ;

item:
    TOK_ID '<' item_cont
	{
	    $$ = $3;
	    $$->id = $1;
	    if ($$->var_len == -2) {
		if (*$$->id == '_') yyerror("val-len field must be named");
	    }
	    else if (*$$->id == '_' && !$$->value)
		    yyerror("unnamed fields must have value");
	}
    ;


item_cont:
     '-' decimal '>' ';'
	{
	    $$ = alloc_t(ITEM);
	    $$->size = $2;
	    $$->var_len = -2; /* hack */
	    if ($2 & 7) yyerror("var-len field must have integral size");
	    $$->pos = 0;
	    $$->flush = 1;
	    $$->value = NULL;
	    $$->next = NULL;
	}
     | decimal opt_pos opt_more '>' opt_val
	{
	    $$ = alloc_t(ITEM);
	    $$->size = $1;
	    $$->var_len = -1;
	    $$->pos = $2;
	    $$->flush = !$3;
	    if ($$->pos == -1)
		if ($$->size & 7)
		    yyerror("position required for small fields");
		else $$->pos = 0;
	    $$->value = $5;
	    $$->next = NULL;
	}
    ;

opt_pos:
	{
	    $$ = -1;
	}
    | '@' decimal
	{
	    $$ = $2-1;
	    if ($$ < 0 || $$ > 7) yyerror("invalid position");
	}
    ;

decimal:
    TOK_ID
	{
	    char *end;

	    $$ = strtoul($1,&end,10);
	    if (*end) yyerror("no a decimal number");
	}
    ;

opt_more:
	{
	    $$ = 0;
	}
    | ',' TOK_ID
	{
	    if (strcmp($2,"more")) yyerror("\"more\" expected");
	    $$ = 1;
	}
    ;

opt_val:
    ';'
	{
	    $$ = NULL;
	}
    | '=' value
	{
	    $$ = $2;
	}
    ;

value:
    TOK_ID ';'
	{
	    $$ = alloc_t(VALUE);
	    $$->type = vt_id;
	    $$->id = $1;
	}
    | TOK_CASE '{' tags '}'
	{
	    $$ = alloc_t(VALUE);
	    $$->type = vt_case;
	    $$->id = NULL;
	    $$->tags = $3;
	}
    | TOK_MULTI '{' tags '}'
	{
	    $$ = alloc_t(VALUE);
	    $$->type = vt_multi;
	    $$->tags = $3;
	}
    | TOK_LENGTH block
	{
	    $$ = alloc_t(VALUE);
	    $$->type = vt_length;
	    $$->block = $2;
	}
    ;

tags:
	{
	    $$ = NULL;
	}
    | TOK_DEFAULT TOK_ID opt_id block
	{
	    $$ = alloc_t(TAG);
	    $$->deflt = 1;
	    if ($3) {
		$$->id = $2;
		$$->value = $3;
	    }
	    else {
		$$->id = NULL;
		$$->value = $2;
	    }
	    $$->block = $4;
	    $$->next = NULL;
	}
    | TOK_ID opt_id block tags
	{
	    $$ = alloc_t(TAG);
	    $$->deflt = 0;
	    if ($2) {
		$$->id = $1;
		$$->value = $2;
	    }
	    else {
		$$->id = NULL;
		$$->value = $1;
	    }
	    $$->block = $3;
	    $$->next = $4;
	}
    ;

opt_id:
	{
	    $$ = NULL;
	}
    | ':' TOK_ID
	{
	    $$ = $2;
	}
    ;
