/* sap.h - SAP manipulations */

/* Written 1996 by Werner Almesberger, EPFL-LRC */


#ifndef SAP_H
#define SAP_H

#include <linux/atmsvc.h>

#include "atmsap.h"


int sap_check_packing(const struct sockaddr_atmsvc *packed_sap,int len);
struct sockaddr_atmsvc *sap_copy(const struct sockaddr_atmsvc *sap);
int sap_compat(const struct sockaddr_atmsvc *old_sap,
  const struct sockaddr_atmsvc *new_sap,struct sockaddr_atmsvc **out_sap,
  const struct atm_qos *old_qos,const struct atm_qos *new_qos,
  struct atm_qos *out_qos);
int sap_encode(Q_DSC *dsc,const struct sockaddr_atmsvc *sap,
  const struct atm_qos *qos);
struct sockaddr_atmsvc *sap_decode(Q_DSC *dsc,struct atm_qos *qos);

#endif
