/* table.h - ATMARP table */
 
/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */
 

#ifndef TABLE_H
#define TABLE_H

#include <linux/atm.h>

#include "atmd.h"


#define DUMP_DIR	"/var/run"
#define DUMP_FILE	"atmarpd.table"
#define TMP_DUMP_FILE	"~atmarpd.table"


typedef struct _vcc {
    int connecting;
    int active; /* indicate direction - for user entertainment only */
    int fd;
    struct _entry *entry;
    struct _vcc *prev,*next;
} VCC;

typedef enum {
    as_none,		/* invalid */
    as_resolv,		/* waiting for resolver response */
    as_invalid,		/* invalid, waiting for all VCs to be closed */
    as_valid,		/* valid */
} ADDR_STATE;

typedef struct _entry {
    ADDR_STATE state;
    int svc;
    unsigned long ip;
    struct sockaddr_atmsvc *addr; /* NULL if none */
    struct atm_qos qos;
    int flags;
    TIMER *timer; /* currently active timer or NULL */
    int timeout; /* current interval - only necessary if using retries */
    int retries;
    struct _vcc *vccs;
    struct _itf *itf;
    struct _entry *prev,*next; /* undefined if itf == NULL */
} ENTRY;

typedef struct _itf {
    unsigned long local_ip; /* @@@ */
    unsigned long netmask;
    int number;
    int mtu;
    struct atm_qos qos; /* default QOS */
    ENTRY *table;
    ENTRY *arp_srv; /* NULL is none */
    struct _itf *prev,*next;
} ITF;


/*
 * May want to consider using one big unified table instead of lots of small
 * tables (one per interface).
 */


extern const char *entry_state_name[];
extern const char *vcc_state_name[];

extern ITF *itfs;
extern ENTRY *unknown_incoming;

extern int pretty;


ENTRY *alloc_entry(int svc);

ENTRY *lookup_ip(const ITF *itf,unsigned long ip);
ENTRY *lookup_addr(const ITF *itf,const struct sockaddr_atmsvc *addr);

void dump_all(void);

#endif
