# Default is UNI 3.0, for good reasons, see below.
#
STANDARDS=-DUNI30
#
# Note: some UNI 3.0 switches will show really strange behaviour if confronted
#	with using 3.1 signaling, so be sure to test your network *very*
#	carefully before permanently configuring machines to use UNI 3.1.
#
# STANDARDS=-DUNI31 -DALLOW_UNI30

CC=cc
CFLAGS_NOWARN=-g -DVERSION=\"`cat ../VERSION`\" $(INCLUDES) -I../lib
CFLAGS_NOOPT=$(CFLAGS_NOWARN) -Wall -Wshadow -Wpointer-arith -Wcast-align \
  -Wwrite-strings -Wstrict-prototypes -Wmissing-prototypes \
  #-Wmissing-declarations (gcc 2.6.x only) #-Wconversion (breaks inline)
CFLAGS_OPT=#-O
CFLAGS=$(CFLAGS_NOOPT) $(CFLAGS_OPT) $(CFLAGS_PRIVATE)
CFLAGS_LEX=$(CFLAGS_NOWARN) $(CFLAGS_OPT)
CFLAGS_YACC=$(CFLAGS_NOWARN) $(CFLAGS_OPT) -DYY_USE_CONST
LDFLAGS=
LDLIBS=-L../lib -latm -larequipa
YACC=bison -y -d #-v
INSTROOT=
INSTPREFIX=$(INSTROOT)/usr/local
INSTBOOTBIN=$(INSTPREFIX)/sbin
INSTUSRBIN=$(INSTPREFIX)/bin
INSTSYSBIN=$(INSTPREFIX)/sbin
INSTLIB=$(INSTROOT)/usr/lib
INSTHDR=$(INSTROOT)/usr/include
INSTMAN=$(INSTPREFIX)/man/man8

LINK.c = $(CC) $(LDFLAGS)

all:
		[ ! -r .checker ] || $(MAKE) clean
		$(MAKE) do_all

do_all:		$(BOOTPGMS) $(SYSPGMS) $(USRPGMS) $(PGMS)

checker:
		[ -r .checker ] || $(MAKE) clean
		$(MAKE) do_checker

do_checker:
		CC=checkergcc $(MAKE) -e do_all
		touch .checker

install:
		@for n in $(BOOTPGMS); do \
		  echo install -c -m 0755 $$n $(INSTBOOTBIN); \
		  install -c -m 0755 $$n $(INSTBOOTBIN) || exit; done
		@for n in $(SYSPGMS); do \
		  echo install -c -m 0755 $$n $(INSTSYSBIN); \
		  install -c -m 0755 $$n $(INSTSYSBIN) || exit; done
		@for n in $(USRPGMS); do \
		  echo install -c -m 0755 $$n $(INSTUSRBIN); \
		  install -c -m 0755 $$n $(INSTUSRBIN) || exit; done
		@for n in $(GENLIBS); do \
		  echo install -c -m 0644 $$n $(INSTLIB); \
		  install -c -m 0644 $$n $(INSTLIB) || exit; done
		@for n in $(SYSHDR); do \
		  echo install -c -m 0644 $$n $(INSTHDR); \
		  install -c -m 0644 $$n $(INSTHDR) || exit; done
		@for n in $(MANS); do \
		  echo install -c -m 0644 $$n $(INSTMAN); \
		  install -c -m 0644 $$n $(INSTMAN) || exit; done

depend:
		$(CPP) -M *.c $(INCLUDES) -I../lib >.tmpdepend
		mv .tmpdepend .depend

clean:
		rm -f *.o core .checker y.tab.h y.tab.c lex.yy.c $(TRASH)

spotless:	clean
		rm -f $(PGMS) *.a .depend

lex.yy.o:	lex.yy.c y.tab.h
		$(CC) -c $(CFLAGS_LEX) lex.yy.c

y.tab.o:	y.tab.c
		$(CC) -c $(CFLAGS_YACC) y.tab.c

$(PGMS) dummy:	../lib/libatm.a

ifeq (.depend,$(wildcard .depend))
include .depend
endif
