/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2020 MediaTek Inc.
 * Author: Argus Lin <argus.lin@mediatek.com>
 */

#ifndef _MT6359_H_
#define _MT6359_H_

/*************Register Bit Define*************/
#define MT6359_TOP0_ID                       0x0
#define MT6359_SMT_CON1                      0x32
#define MT6359_DRV_CON2                      0x3c
#define MT6359_DRV_CON3                      0x3e
#define MT6359_DRV_CON4                      0x40
#define MT6359_TOP_CKPDN_CON0                0x10c
#define MT6359_TOP_CKPDN_CON0_SET            0x10e
#define MT6359_TOP_CKPDN_CON0_CLR            0x110
#define MT6359_AUXADC_RQST0                  0x1108
#define MT6359_AUXADC_CON10                  0x11a0
#define MT6359_AUXADC_ACCDET                 0x11ba
#define MT6359_LDO_VUSB_OP_EN                0x1d0c
#define MT6359_LDO_VUSB_OP_EN_SET            0x1d0e
#define MT6359_LDO_VUSB_OP_EN_CLR            0x1d10
#define MT6359_AUD_TOP_CKPDN_CON0            0x230c
#define MT6359_AUD_TOP_CKPDN_CON0_SET        0x230e
#define MT6359_AUD_TOP_CKPDN_CON0_CLR        0x2310
#define MT6359_AUD_TOP_RST_CON0              0x2320
#define MT6359_AUD_TOP_RST_CON0_SET          0x2322
#define MT6359_AUD_TOP_RST_CON0_CLR          0x2324
#define MT6359_AUD_TOP_INT_CON0              0x2328
#define MT6359_AUD_TOP_INT_CON0_SET          0x232a
#define MT6359_AUD_TOP_INT_CON0_CLR          0x232c
#define MT6359_AUD_TOP_INT_MASK_CON0         0x232e
#define MT6359_AUD_TOP_INT_MASK_CON0_SET     0x2330
#define MT6359_AUD_TOP_INT_MASK_CON0_CLR     0x2332
#define MT6359_AUD_TOP_INT_STATUS0           0x2334
#define MT6359_AFE_NCP_CFG2                  0x24e2
#define MT6359_AUDENC_DSN_ID                 0x2500
#define MT6359_AUDENC_DSN_REV0               0x2502
#define MT6359_AUDENC_DSN_DBI                0x2504
#define MT6359_AUDENC_DSN_FPI                0x2506
#define MT6359_AUDENC_ANA_CON0               0x2508
#define MT6359_AUDENC_ANA_CON1               0x250a
#define MT6359_AUDENC_ANA_CON2               0x250c
#define MT6359_AUDENC_ANA_CON3               0x250e
#define MT6359_AUDENC_ANA_CON4               0x2510
#define MT6359_AUDENC_ANA_CON5               0x2512
#define MT6359_AUDENC_ANA_CON6               0x2514
#define MT6359_AUDENC_ANA_CON7               0x2516
#define MT6359_AUDENC_ANA_CON8               0x2518
#define MT6359_AUDENC_ANA_CON9               0x251a
#define MT6359_AUDENC_ANA_CON10              0x251c
#define MT6359_AUDENC_ANA_CON11              0x251e
#define MT6359_AUDENC_ANA_CON12              0x2520
#define MT6359_AUDENC_ANA_CON13              0x2522
#define MT6359_AUDENC_ANA_CON14              0x2524
#define MT6359_AUDENC_ANA_CON15              0x2526
#define MT6359_AUDENC_ANA_CON16              0x2528
#define MT6359_AUDENC_ANA_CON17              0x252a
#define MT6359_AUDENC_ANA_CON18              0x252c
#define MT6359_AUDENC_ANA_CON19              0x252e
#define MT6359_AUDENC_ANA_CON20              0x2530
#define MT6359_AUDENC_ANA_CON21              0x2532
#define MT6359_AUDENC_ANA_CON22              0x2534
#define MT6359_AUDENC_ANA_CON23              0x2536
#define MT6359_AUDDEC_DSN_ID                 0x2580
#define MT6359_AUDDEC_DSN_REV0               0x2582
#define MT6359_AUDDEC_DSN_DBI                0x2584
#define MT6359_AUDDEC_DSN_FPI                0x2586
#define MT6359_AUDDEC_ANA_CON0               0x2588
#define MT6359_AUDDEC_ANA_CON1               0x258a
#define MT6359_AUDDEC_ANA_CON2               0x258c
#define MT6359_AUDDEC_ANA_CON3               0x258e
#define MT6359_AUDDEC_ANA_CON4               0x2590
#define MT6359_AUDDEC_ANA_CON5               0x2592
#define MT6359_AUDDEC_ANA_CON6               0x2594
#define MT6359_AUDDEC_ANA_CON7               0x2596
#define MT6359_AUDDEC_ANA_CON8               0x2598
#define MT6359_AUDDEC_ANA_CON9               0x259a
#define MT6359_AUDDEC_ANA_CON10              0x259c
#define MT6359_AUDDEC_ANA_CON11              0x259e
#define MT6359_AUDDEC_ANA_CON12              0x25a0
#define MT6359_AUDDEC_ANA_CON13              0x25a2
#define MT6359_AUDDEC_ANA_CON14              0x25a4
#define MT6359_ACCDET_DSN_DIG_ID             0x2680
#define MT6359_ACCDET_DSN_DIG_REV0           0x2682
#define MT6359_ACCDET_DSN_DBI                0x2684
#define MT6359_ACCDET_DSN_FPI                0x2686
#define MT6359_ACCDET_CON0                   0x2688
#define MT6359_ACCDET_CON1                   0x268a
#define MT6359_ACCDET_CON2                   0x268c
#define MT6359_ACCDET_CON3                   0x268e
#define MT6359_ACCDET_CON4                   0x2690
#define MT6359_ACCDET_CON5                   0x2692
#define MT6359_ACCDET_CON6                   0x2694
#define MT6359_ACCDET_CON7                   0x2696
#define MT6359_ACCDET_CON8                   0x2698
#define MT6359_ACCDET_CON9                   0x269a
#define MT6359_ACCDET_CON10                  0x269c
#define MT6359_ACCDET_CON11                  0x269e
#define MT6359_ACCDET_CON12                  0x26a0
#define MT6359_ACCDET_CON13                  0x26a2
#define MT6359_ACCDET_CON14                  0x26a4
#define MT6359_ACCDET_CON15                  0x26a6
#define MT6359_ACCDET_CON16                  0x26a8
#define MT6359_ACCDET_CON17                  0x26aa
#define MT6359_ACCDET_CON18                  0x26ac
#define MT6359_ACCDET_CON19                  0x26ae
#define MT6359_ACCDET_CON20                  0x26b0
#define MT6359_ACCDET_CON21                  0x26b2
#define MT6359_ACCDET_CON22                  0x26b4
#define MT6359_ACCDET_CON23                  0x26b6
#define MT6359_ACCDET_CON24                  0x26b8
#define MT6359_ACCDET_CON25                  0x26ba
#define MT6359_ACCDET_CON26                  0x26bc
#define MT6359_ACCDET_CON27                  0x26be
#define MT6359_ACCDET_CON28                  0x26c0
#define MT6359_ACCDET_CON29                  0x26c2
#define MT6359_ACCDET_CON30                  0x26c4
#define MT6359_ACCDET_CON31                  0x26c6
#define MT6359_ACCDET_CON32                  0x26c8
#define MT6359_ACCDET_CON33                  0x26ca
#define MT6359_ACCDET_CON34                  0x26cc
#define MT6359_ACCDET_CON35                  0x26ce
#define MT6359_ACCDET_CON36                  0x26d0
#define MT6359_ACCDET_CON37                  0x26d2
#define MT6359_ACCDET_CON38                  0x26d4
#define MT6359_ACCDET_CON39                  0x26d6
#define MT6359_ACCDET_CON40                  0x26d8

#define TOP0_ANA_ID_ADDR                               \
	MT6359_TOP0_ID
#define TOP0_ANA_ID_SFT                                0
#define TOP0_ANA_ID_MASK                               0xFF
#define TOP0_ANA_ID_MASK_SFT                           (0xFF << 0)
#define AUXADC_RQST_CH0_ADDR                           \
	MT6359_AUXADC_RQST0
#define AUXADC_RQST_CH0_SFT                            0
#define AUXADC_RQST_CH0_MASK                           0x1
#define AUXADC_RQST_CH0_MASK_SFT                       (0x1 << 0)
#define AUXADC_ACCDET_ANASWCTRL_EN_ADDR                \
	MT6359_AUXADC_CON15
#define AUXADC_ACCDET_ANASWCTRL_EN_SFT                 6
#define AUXADC_ACCDET_ANASWCTRL_EN_MASK                0x1
#define AUXADC_ACCDET_ANASWCTRL_EN_MASK_SFT            (0x1 << 6)

#define AUXADC_ACCDET_AUTO_SPL_ADDR                    \
	MT6359_AUXADC_ACCDET
#define AUXADC_ACCDET_AUTO_SPL_SFT                     0
#define AUXADC_ACCDET_AUTO_SPL_MASK                    0x1
#define AUXADC_ACCDET_AUTO_SPL_MASK_SFT                (0x1 << 0)
#define AUXADC_ACCDET_AUTO_RQST_CLR_ADDR               \
	MT6359_AUXADC_ACCDET
#define AUXADC_ACCDET_AUTO_RQST_CLR_SFT                1
#define AUXADC_ACCDET_AUTO_RQST_CLR_MASK               0x1
#define AUXADC_ACCDET_AUTO_RQST_CLR_MASK_SFT           (0x1 << 1)
#define AUXADC_ACCDET_DIG1_RSV0_ADDR                   \
	MT6359_AUXADC_ACCDET
#define AUXADC_ACCDET_DIG1_RSV0_SFT                    2
#define AUXADC_ACCDET_DIG1_RSV0_MASK                   0x3F
#define AUXADC_ACCDET_DIG1_RSV0_MASK_SFT               (0x3F << 2)
#define AUXADC_ACCDET_DIG0_RSV0_ADDR                   \
	MT6359_AUXADC_ACCDET
#define AUXADC_ACCDET_DIG0_RSV0_SFT                    8
#define AUXADC_ACCDET_DIG0_RSV0_MASK                   0xFF
#define AUXADC_ACCDET_DIG0_RSV0_MASK_SFT               (0xFF << 8)

#define RG_ACCDET_CK_PDN_ADDR                          \
	MT6359_AUD_TOP_CKPDN_CON0
#define RG_ACCDET_CK_PDN_SFT                           0
#define RG_ACCDET_CK_PDN_MASK                          0x1
#define RG_ACCDET_CK_PDN_MASK_SFT                      (0x1 << 0)

#define RG_ACCDET_RST_ADDR                             \
	MT6359_AUD_TOP_RST_CON0
#define RG_ACCDET_RST_SFT                              1
#define RG_ACCDET_RST_MASK                             0x1
#define RG_ACCDET_RST_MASK_SFT                         (0x1 << 1)
#define BANK_ACCDET_SWRST_ADDR                         \
	MT6359_AUD_TOP_RST_BANK_CON0
#define BANK_ACCDET_SWRST_SFT                          0
#define BANK_ACCDET_SWRST_MASK                         0x1
#define BANK_ACCDET_SWRST_MASK_SFT                     (0x1 << 0)

#define RG_INT_EN_ACCDET_ADDR                          \
	MT6359_AUD_TOP_INT_CON0
#define RG_INT_EN_ACCDET_SFT                           5
#define RG_INT_EN_ACCDET_MASK                          0x1
#define RG_INT_EN_ACCDET_MASK_SFT                      (0x1 << 5)
#define RG_INT_EN_ACCDET_EINT0_ADDR                    \
	MT6359_AUD_TOP_INT_CON0
#define RG_INT_EN_ACCDET_EINT0_SFT                     6
#define RG_INT_EN_ACCDET_EINT0_MASK                    0x1
#define RG_INT_EN_ACCDET_EINT0_MASK_SFT                (0x1 << 6)
#define RG_INT_EN_ACCDET_EINT1_ADDR                    \
	MT6359_AUD_TOP_INT_CON0
#define RG_INT_EN_ACCDET_EINT1_SFT                     7
#define RG_INT_EN_ACCDET_EINT1_MASK                    0x1
#define RG_INT_EN_ACCDET_EINT1_MASK_SFT                (0x1 << 7)

#define RG_INT_MASK_ACCDET_ADDR                        \
	MT6359_AUD_TOP_INT_MASK_CON0
#define RG_INT_MASK_ACCDET_SFT                         5
#define RG_INT_MASK_ACCDET_MASK                        0x1
#define RG_INT_MASK_ACCDET_MASK_SFT                    (0x1 << 5)
#define RG_INT_MASK_ACCDET_EINT0_ADDR                  \
	MT6359_AUD_TOP_INT_MASK_CON0
#define RG_INT_MASK_ACCDET_EINT0_SFT                   6
#define RG_INT_MASK_ACCDET_EINT0_MASK                  0x1
#define RG_INT_MASK_ACCDET_EINT0_MASK_SFT              (0x1 << 6)
#define RG_INT_MASK_ACCDET_EINT1_ADDR                  \
	MT6359_AUD_TOP_INT_MASK_CON0
#define RG_INT_MASK_ACCDET_EINT1_SFT                   7
#define RG_INT_MASK_ACCDET_EINT1_MASK                  0x1
#define RG_INT_MASK_ACCDET_EINT1_MASK_SFT              (0x1 << 7)

#define RG_INT_STATUS_ACCDET_ADDR                      \
	MT6359_AUD_TOP_INT_STATUS0
#define RG_INT_STATUS_ACCDET_SFT                       5
#define RG_INT_STATUS_ACCDET_MASK                      0x1
#define RG_INT_STATUS_ACCDET_MASK_SFT                  (0x1 << 5)
#define RG_INT_STATUS_ACCDET_EINT0_ADDR                \
	MT6359_AUD_TOP_INT_STATUS0
#define RG_INT_STATUS_ACCDET_EINT0_SFT                 6
#define RG_INT_STATUS_ACCDET_EINT0_MASK                0x1
#define RG_INT_STATUS_ACCDET_EINT0_MASK_SFT            (0x1 << 6)
#define RG_INT_STATUS_ACCDET_EINT1_ADDR                \
	MT6359_AUD_TOP_INT_STATUS0
#define RG_INT_STATUS_ACCDET_EINT1_SFT                 7
#define RG_INT_STATUS_ACCDET_EINT1_MASK                0x1
#define RG_INT_STATUS_ACCDET_EINT1_MASK_SFT            (0x1 << 7)

#define RG_INT_RAW_STATUS_ACCDET_ADDR                  \
	MT6359_AUD_TOP_INT_RAW_STATUS0
#define RG_INT_RAW_STATUS_ACCDET_SFT                   5
#define RG_INT_RAW_STATUS_ACCDET_MASK                  0x1
#define RG_INT_RAW_STATUS_ACCDET_MASK_SFT              (0x1 << 5)
#define RG_INT_RAW_STATUS_ACCDET_EINT0_ADDR            \
	MT6359_AUD_TOP_INT_RAW_STATUS0
#define RG_INT_RAW_STATUS_ACCDET_EINT0_SFT             6
#define RG_INT_RAW_STATUS_ACCDET_EINT0_MASK            0x1
#define RG_INT_RAW_STATUS_ACCDET_EINT0_MASK_SFT        (0x1 << 6)
#define RG_INT_RAW_STATUS_ACCDET_EINT1_ADDR            \
	MT6359_AUD_TOP_INT_RAW_STATUS0
#define RG_INT_RAW_STATUS_ACCDET_EINT1_SFT             7
#define RG_INT_RAW_STATUS_ACCDET_EINT1_MASK            0x1
#define RG_INT_RAW_STATUS_ACCDET_EINT1_MASK_SFT        (0x1 << 7)

#define RG_AUDACCDETMICBIAS0PULLLOW_ADDR               \
	MT6359_AUDENC_ANA_CON18
#define RG_AUDACCDETMICBIAS0PULLLOW_SFT                0
#define RG_AUDACCDETMICBIAS0PULLLOW_MASK               0x1
#define RG_AUDACCDETMICBIAS0PULLLOW_MASK_SFT           (0x1 << 0)
#define RG_AUDACCDETMICBIAS1PULLLOW_ADDR               \
	MT6359_AUDENC_ANA_CON18
#define RG_AUDACCDETMICBIAS1PULLLOW_SFT                1
#define RG_AUDACCDETMICBIAS1PULLLOW_MASK               0x1
#define RG_AUDACCDETMICBIAS1PULLLOW_MASK_SFT           (0x1 << 1)
#define RG_AUDACCDETMICBIAS2PULLLOW_ADDR               \
	MT6359_AUDENC_ANA_CON18
#define RG_AUDACCDETMICBIAS2PULLLOW_SFT                2
#define RG_AUDACCDETMICBIAS2PULLLOW_MASK               0x1
#define RG_AUDACCDETMICBIAS2PULLLOW_MASK_SFT           (0x1 << 2)
#define RG_AUDACCDETVIN1PULLLOW_ADDR                   \
	MT6359_AUDENC_ANA_CON18
#define RG_AUDACCDETVIN1PULLLOW_SFT                    3
#define RG_AUDACCDETVIN1PULLLOW_MASK                   0x1
#define RG_AUDACCDETVIN1PULLLOW_MASK_SFT               (0x1 << 3)
#define RG_AUDACCDETVTHACAL_ADDR                       \
	MT6359_AUDENC_ANA_CON18
#define RG_AUDACCDETVTHACAL_SFT                        4
#define RG_AUDACCDETVTHACAL_MASK                       0x1
#define RG_AUDACCDETVTHACAL_MASK_SFT                   (0x1 << 4)
#define RG_AUDACCDETVTHBCAL_ADDR                       \
	MT6359_AUDENC_ANA_CON18
#define RG_AUDACCDETVTHBCAL_SFT                        5
#define RG_AUDACCDETVTHBCAL_MASK                       0x1
#define RG_AUDACCDETVTHBCAL_MASK_SFT                   (0x1 << 5)
#define RG_AUDACCDETTVDET_ADDR                         \
	MT6359_AUDENC_ANA_CON18
#define RG_AUDACCDETTVDET_SFT                          6
#define RG_AUDACCDETTVDET_MASK                         0x1
#define RG_AUDACCDETTVDET_MASK_SFT                     (0x1 << 6)
#define RG_ACCDETSEL_ADDR                              \
	MT6359_AUDENC_ANA_CON18
#define RG_ACCDETSEL_SFT                               7
#define RG_ACCDETSEL_MASK                              0x1
#define RG_ACCDETSEL_MASK_SFT                          (0x1 << 7)

#define RG_AUDPWDBMICBIAS1_ADDR                        \
	MT6359_AUDENC_ANA_CON16
#define RG_AUDPWDBMICBIAS1_SFT                         0
#define RG_AUDPWDBMICBIAS1_MASK                        0x1
#define RG_AUDPWDBMICBIAS1_MASK_SFT                    (0x1 << 0)
#define RG_AUDMICBIAS1BYPASSEN_ADDR                    \
	MT6359_AUDENC_ANA_CON16
#define RG_AUDMICBIAS1BYPASSEN_SFT                     1
#define RG_AUDMICBIAS1BYPASSEN_MASK                    0x1
#define RG_AUDMICBIAS1BYPASSEN_MASK_SFT                (0x1 << 1)
#define RG_AUDMICBIAS1LOWPEN_ADDR                      \
	MT6359_AUDENC_ANA_CON16
#define RG_AUDMICBIAS1LOWPEN_SFT                       2
#define RG_AUDMICBIAS1LOWPEN_MASK                      0x1
#define RG_AUDMICBIAS1LOWPEN_MASK_SFT                  (0x1 << 2)
#define RG_AUDMICBIAS1VREF_ADDR                        \
	MT6359_AUDENC_ANA_CON16
#define RG_AUDMICBIAS1VREF_SFT                         4
#define RG_AUDMICBIAS1VREF_MASK                        0x7
#define RG_AUDMICBIAS1VREF_MASK_SFT                    (0x7 << 4)
#define RG_AUDMICBIAS1DCSW1PEN_ADDR                    \
	MT6359_AUDENC_ANA_CON16
#define RG_AUDMICBIAS1DCSW1PEN_SFT                     8
#define RG_AUDMICBIAS1DCSW1PEN_MASK                    0x1
#define RG_AUDMICBIAS1DCSW1PEN_MASK_SFT                (0x1 << 8)
#define RG_AUDMICBIAS1DCSW1NEN_ADDR                    \
	MT6359_AUDENC_ANA_CON16
#define RG_AUDMICBIAS1DCSW1NEN_SFT                     9
#define RG_AUDMICBIAS1DCSW1NEN_MASK                    0x1
#define RG_AUDMICBIAS1DCSW1NEN_MASK_SFT                (0x1 << 9)
#define RG_BANDGAPGEN_ADDR                             \
	MT6359_AUDENC_ANA_CON16
#define RG_BANDGAPGEN_SFT                              10
#define RG_BANDGAPGEN_MASK                             0x1
#define RG_BANDGAPGEN_MASK_SFT                         (0x1 << 10)
#define RG_AUDMICBIAS1HVEN_ADDR                        \
	MT6359_AUDENC_ANA_CON16
#define RG_AUDMICBIAS1HVEN_SFT                         12
#define RG_AUDMICBIAS1HVEN_MASK                        0x1
#define RG_AUDMICBIAS1HVEN_MASK_SFT                    (0x1 << 12)
#define RG_AUDMICBIAS1HVVREF_ADDR                      \
	MT6359_AUDENC_ANA_CON16
#define RG_AUDMICBIAS1HVVREF_SFT                       13
#define RG_AUDMICBIAS1HVVREF_MASK                      0x1
#define RG_AUDMICBIAS1HVVREF_MASK_SFT                  (0x1 << 13)

#define RG_EINT0NOHYS_ADDR                             \
	MT6359_AUDENC_ANA_CON18
#define RG_EINT0NOHYS_SFT                              10
#define RG_EINT0NOHYS_MASK                             0x1
#define RG_EINT0NOHYS_MASK_SFT                         (0x1 << 10)
#define RG_EINT0CONFIGACCDET_ADDR                      \
	MT6359_AUDENC_ANA_CON18
#define RG_EINT0CONFIGACCDET_SFT                       11
#define RG_EINT0CONFIGACCDET_MASK                      0x1
#define RG_EINT0CONFIGACCDET_MASK_SFT                  (0x1 << 11)
#define RG_EINT0HIRENB_ADDR                            \
	MT6359_AUDENC_ANA_CON18
#define RG_EINT0HIRENB_SFT                             12
#define RG_EINT0HIRENB_MASK                            0x1
#define RG_EINT0HIRENB_MASK_SFT                        (0x1 << 12)
#define RG_ACCDET2AUXRESBYPASS_ADDR                    \
	MT6359_AUDENC_ANA_CON18
#define RG_ACCDET2AUXRESBYPASS_SFT                     13
#define RG_ACCDET2AUXRESBYPASS_MASK                    0x1
#define RG_ACCDET2AUXRESBYPASS_MASK_SFT                (0x1 << 13)
#define RG_ACCDET2AUXSWEN_ADDR                         \
	MT6359_AUDENC_ANA_CON18
#define RG_ACCDET2AUXSWEN_SFT                          14
#define RG_ACCDET2AUXSWEN_MASK                         0x1
#define RG_ACCDET2AUXSWEN_MASK_SFT                     (0x1 << 14)
#define RG_AUDACCDETMICBIAS3PULLLOW_ADDR               \
	MT6359_AUDENC_ANA_CON18
#define RG_AUDACCDETMICBIAS3PULLLOW_SFT                15
#define RG_AUDACCDETMICBIAS3PULLLOW_MASK               0x1
#define RG_AUDACCDETMICBIAS3PULLLOW_MASK_SFT           (0x1 << 15)
#define RG_EINT1CONFIGACCDET_ADDR                      \
	MT6359_AUDENC_ANA_CON19
#define RG_EINT1CONFIGACCDET_SFT                       0
#define RG_EINT1CONFIGACCDET_MASK                      0x1
#define RG_EINT1CONFIGACCDET_MASK_SFT                  (0x1 << 0)
#define RG_EINT1HIRENB_ADDR                            \
	MT6359_AUDENC_ANA_CON19
#define RG_EINT1HIRENB_SFT                             1
#define RG_EINT1HIRENB_MASK                            0x1
#define RG_EINT1HIRENB_MASK_SFT                        (0x1 << 1)
#define RG_EINT1NOHYS_ADDR                             \
	MT6359_AUDENC_ANA_CON19
#define RG_EINT1NOHYS_SFT                              2
#define RG_EINT1NOHYS_MASK                             0x1
#define RG_EINT1NOHYS_MASK_SFT                         (0x1 << 2)
#define RG_EINTCOMPVTH_ADDR                            \
	MT6359_AUDENC_ANA_CON19
#define RG_MTEST_EN_ADDR                               \
	MT6359_AUDENC_ANA_CON19
#define RG_MTEST_EN_SFT                                8
#define RG_MTEST_EN_MASK                               0x1
#define RG_MTEST_EN_MASK_SFT                           (0x1 << 8)
#define RG_MTEST_SEL_ADDR                              \
	MT6359_AUDENC_ANA_CON19
#define RG_MTEST_SEL_SFT                               9
#define RG_MTEST_SEL_MASK                              0x1
#define RG_MTEST_SEL_MASK_SFT                          (0x1 << 9)
#define RG_MTEST_CURRENT_ADDR                          \
	MT6359_AUDENC_ANA_CON19
#define RG_MTEST_CURRENT_SFT                           10
#define RG_MTEST_CURRENT_MASK                 