/*
 * Copyright 2007-2008 Analog Devices Inc.
 *
 * Licensed under the GPL-2 or later.
 */

#ifndef _CDEF_BF548_H
#define _CDEF_BF548_H

/* include all Core registers and bit definitions */
#include "defBF548.h"

/* include core sbfin_read_()ecific register pointer definitions */
#include <asm/cdef_LPBlackfin.h>

/* SYSTEM & MMR ADDRESS DEFINITIONS FOR ADSP-BF548 */

/* include cdefBF54x_base.h for the set of #defines that are common to all ADSP-BF54x bfin_read_()rocessors */
#include "cdefBF54x_base.h"

/* The BF548 is like the BF547, but has additional CANs */
#include "cdefBF547.h"

/* CAN Controller 1 Config 1 Registers */

#define bfin_read_CAN1_MC1()		bfin_read16(CAN1_MC1)
#define bfin_write_CAN1_MC1(val)	bfin_write16(CAN1_MC1, val)
#define bfin_read_CAN1_MD1()		bfin_read16(CAN1_MD1)
#define bfin_write_CAN1_MD1(val)	bfin_write16(CAN1_MD1, val)
#define bfin_read_CAN1_TRS1()		bfin_read16(CAN1_TRS1)
#define bfin_write_CAN1_TRS1(val)	bfin_write16(CAN1_TRS1, val)
#define bfin_read_CAN1_TRR1()		bfin_read16(CAN1_TRR1)
#define bfin_write_CAN1_TRR1(val)	bfin_write16(CAN1_TRR1, val)
#define bfin_read_CAN1_TA1()		bfin_read16(CAN1_TA1)
#define bfin_write_CAN1_TA1(val)	bfin_write16(CAN1_TA1, val)
#define bfin_read_CAN1_AA1()		bfin_read16(CAN1_AA1)
#define bfin_write_CAN1_AA1(val)	bfin_write16(CAN1_AA1, val)
#define bfin_read_CAN1_RMP1()		bfin_read16(CAN1_RMP1)
#define bfin_write_CAN1_RMP1(val)	bfin_write16(CAN1_RMP1, val)
#define bfin_read_CAN1_RML1()		bfin_read16(CAN1_RML1)
#define bfin_write_CAN1_RML1(val)	bfin_write16(CAN1_RML1, val)
#define bfin_read_CAN1_MBTIF1()		bfin_read16(CAN1_MBTIF1)
#define bfin_write_CAN1_MBTIF1(val)	bfin_write16(CAN1_MBTIF1, val)
#define bfin_read_CAN1_MBRIF1()		bfin_read16(CAN1_MBRIF1)
#define bfin_write_CAN1_MBRIF1(val)	bfin_write16(CAN1_MBRIF1, val)
#define bfin_read_CAN1_MBIM1()		bfin_read16(CAN1_MBIM1)
#define bfin_write_CAN1_MBIM1(val)	bfin_write16(CAN1_MBIM1, val)
#define bfin_read_CAN1_RFH1()		bfin_read16(CAN1_RFH1)
#define bfin_write_CAN1_RFH1(val)	bfin_write16(CAN1_RFH1, val)
#define bfin_read_CAN1_OPSS1()		bfin_read16(CAN1_OPSS1)
#define bfin_write_CAN1_OPSS1(val)	bfin_write16(CAN1_OPSS1, val)

/* CAN Controller 1 Config 2 Registers */

#define bfin_read_CAN1_MC2()		bfin_read16(CAN1_MC2)
#define bfin_write_CAN1_MC2(val)	bfin_write16(CAN1_MC2, val)
#define bfin_read_CAN1_MD2()		bfin_read16(CAN1_MD2)
#define bfin_write_CAN1_MD2(val)	bfin_write16(CAN1_MD2, val)
#define bfin_read_CAN1_TRS2()		bfin_read16(CAN1_TRS2)
#define bfin_write_CAN1_TRS2(val)	bfin_write16(CAN1_TRS2, val)
#define bfin_read_CAN1_TRR2()		bfin_read16(CAN1_TRR2)
#define bfin_write_CAN1_TRR2(val)	bfin_write16(CAN1_TRR2, val)
#define bfin_read_CAN1_TA2()		bfin_read16(CAN1_TA2)
#define bfin_write_CAN1_TA2(val)	bfin_write16(CAN1_TA2, val)
#define bfin_read_CAN1_AA2()		bfin_read16(CAN1_AA2)
#define bfin_write_CAN1_AA2(val)	bfin_write16(CAN1_AA2, val)
#define bfin_read_CAN1_RMP2()		bfin_read16(CAN1_RMP2)
#define bfin_write_CAN1_RMP2(val)	bfin_write16(CAN1_RMP2, val)
#define bfin_read_CAN1_RML2()		bfin_read16(CAN1_RML2)
#define bfin_write_CAN1_RML2(val)	bfin_write16(CAN1_RML2, val)
#define bfin_read_CAN1_MBTIF2()		bfin_read16(CAN1_MBTIF2)
#define bfin_write_CAN1_MBTIF2(val)	bfin_write16(CAN1_MBTIF2, val)
#define bfin_read_CAN1_MBRIF2()		bfin_read16(CAN1_MBRIF2)
#define bfin_write_CAN1_MBRIF2(val)	bfin_write16(CAN1_MBRIF2, val)
#define bfin_read_CAN1_MBIM2()		bfin_read16(CAN1_MBIM2)
#define bfin_write_CAN1_MBIM2(val)	bfin_write16(CAN1_MBIM2, val)
#define bfin_read_CAN1_RFH2()		bfin_read16(CAN1_RFH2)
#define bfin_write_CAN1_RFH2(val)	bfin_write16(CAN1_RFH2, val)
#define bfin_read_CAN1_OPSS2()		bfin_read16(CAN1_OPSS2)
#define bfin_write_CAN1_OPSS2(val)	bfin_write16(CAN1_OPSS2, val)

/* CAN Controller 1 Clock/Interrubfin_read_()t/Counter Registers */

#define bfin_read_CAN1_CLOCK()		bfin_read16(CAN1_CLOCK)
#define bfin_write_CAN1_CLOCK(val)	bfin_write16(CAN1_CLOCK, val)
#define bfin_read_CAN1_TIMING()		bfin_read16(CAN1_TIMING)
#define bfin_write_CAN1_TIMING(val)	bfin_write16(CAN1_TIMING, val)
#define bfin_read_CAN1_DEBUG()		bfin_read16(CAN1_DEBUG)
#define bfin_write_CAN1_DEBUG(val)	bfin_write16(CAN1_DEBUG, val)
#define bfin_read_CAN1_STATUS()		bfin_read16(CAN1_STATUS)
#define bfin_write_CAN1_STATUS(val)	bfin_write16(CAN1_STATUS, val)
#define bfin_read_CAN1_CEC()		bfin_read16(CAN1_CEC)
#define bfin_write_CAN1_CEC(val)	bfin_write16(CAN1_CEC, val)
#define bfin_read_CAN1_GIS()		bfin_read16(CAN1_GIS)
#define bfin_write_CAN1_GIS(val)	bfin_write16(CAN1_GIS, val)
#define bfin_read_CAN1_GIM()		bfin_read16(CAN1_GIM)
#define bfin_write_CAN1_GIM(val)	bfin_write16(CAN1_GIM, val)
#define bfin_read_CAN1_GIF()		bfin_read16(CAN1_GIF)
#define bfin_write_CAN1_GIF(val)	bfin_write16(CAN1_GIF, val)
#define bfin_read_CAN1_CONTROL()	bfin_read16(CAN1_CONTROL)
#define bfin_write_CAN1_CONTROL(val)	bfin_write16(CAN1_CONTROL, val)
#define bfin_read_CAN1_INTR()		bfin_read16(CAN1_INTR)
#define bfin_write_CAN1_INTR(val)	bfin_write16(CAN1_INTR, val)
#define bfin_read_CAN1_MBTD()		bfin_read16(CAN1_MBTD)
#define bfin_write_CAN1_MBTD(val)	bfin_write16(CAN1_MBTD, val)
#define bfin_read_CAN1_EWR()		bfin_read16(CAN1_EWR)
#define bfin_write_CAN1_EWR(val)	bfin_write16(CAN1_EWR, val)
#define bfin_read_CAN1_ESR()		bfin_read16(CAN1_ESR)
#define bfin_write_CAN1_ESR(val)	bfin_write16(CAN1_ESR, val)
#define bfin_read_CAN1_UCCNT()		bfin_read16(CAN1_UCCNT)
#define bfin_write_CAN1_UCCNT(val)	bfin_write16(CAN1_UCCNT, val)
#define bfin_read_CAN1_UCRC()		bfin_read16(CAN1_UCRC)
#define bfin_write_CAN1_UCRC(val)	bfin_write16(CAN1_UCRC, val)
#define bfin_read_CAN1_UCCNF()		bfin_read16(CAN1_UCCNF)
#define bfin_write_CAN1_UCCNF(val)	bfin_write16(CAN1_UCCNF, val)

/* CAN Controller 1 Mailbox Accebfin_read_()tance Registers */

#define bfin_read_CAN1_AM00L()		bfin_read16(CAN1_AM00L)
#define bfin_write_CAN1_AM00L(val)	bfin_write16(CAN1_AM00L, val)
#define bfin_read_CAN1_AM00H()		bfin_read16(CAN1_AM00H)
#define bfin_write_CAN1_AM00H(val)	bfin_write16(CAN1_AM00H, val)
#define bfin_read_CAN1_AM01L()		bfin_read16(CAN1_AM01L)
#define bfin_write_CAN1_AM01L(val)	bfin_write16(CAN1_AM01L, val)
#define bfin_read_CAN1_AM01H()		bfin_read16(CAN1_AM01H)
#define bfin_write_CAN1_AM01H(val)	bfin_write16(CAN1_AM01H, val)
#define bfin_read_CAN1_AM02L()		bfin_read16(CAN1_AM02L)
#define bfin_write_CAN1_AM02L(val)	bfin_write16(CAN1_AM02L, val)
#define bfin_read_CAN1_AM02H()		bfin_read16(CAN1_AM02H)
#define bfin_write_CAN1_AM02H(val)	bfin_write16(CAN1_AM02H, val)
#define bfin_read_CAN1_AM03L()		bfin_read16(CAN1_AM03L)
#define bfin_write_CAN1_AM03L(val)	bfin_write16(CAN1_AM03L, val)
#define bfin_read_CAN1_AM03H()		bfin_read16(CAN1_AM03H)
#define bfin_write_CAN1_AM03H(val)	bfin_write16(CAN1_AM03H, val)
#define bfin_read_CAN1_AM04L()		bfin_read16(CAN1_AM04L)
#define bfin_write_CAN1_AM04L(val)	bfin_write16(CAN1_AM04L, val)
#define bfin_read_CAN1_AM04H()		bfin_read16(CAN1_AM04H)
#define bfin_write_CAN1_AM04H(val)	bfin_write16(CAN1_AM04H, val)
#define bfin_read_CAN1_AM05L()		bfin_read16(CAN1_AM05L)
#define bfin_write_CAN1_AM05L(val)	bfin_write16(CAN1_AM05L, val)
#define bfin_read_CAN1_AM05H()		bfin_read16(CAN1_AM05H)
#define bfin_write_CAN1_AM05H(val)	bfin_write16(CAN1_AM05H, val)
#define bfin_read_CAN1_AM06L()		bfin_read16(CAN1_AM06L)
#define bfin_write_CAN1_AM06L(val)	bfin_write16(CAN1_AM06L, val)
#define bfin_read_CAN1_AM06H()		bfin_read16(CAN1_AM06H)
#define bfin_write_CAN1_AM06H(val)	bfin_write16(CAN1_AM06H, val)
#define bfin_read_CAN1_AM07L()		bfin_read16(CAN1_AM07L)
#define bfin_write_CAN1_AM07L(val)	bfin_write16(CAN1_AM07L, val)
#define bfin_read_CAN1_AM07H()		bfin_read16(CAN1_AM07H)
#define bfin_write_CAN1_AM07H(val)	bfin_write16(CAN1_AM07H, val)
#define bfin_read_CAN1_AM08L()		bfin_read16(CAN1_AM08L)
#define bfin_write_CAN1_AM08L(val)	bfin_write16(CAN1_AM08L, val)
#define bfin_read_CAN1_AM08H()		bfin_read16(CAN1_AM08H)
#define bfin_write_CAN1_AM08H(val)	bfin_write16(CAN1_AM08H, val)
#define bfin_read_CAN1_AM09L()		bfin_read16(CAN1_AM09L)
#define bfin_write_CAN1_AM09L(val)	bfin_write16(CAN1_AM09L, val)
#define bfin_read_CAN1_AM09H()		bfin_read16(CAN1_AM09H)
#define bfin_write_CAN1_AM09H(val)	bfin_write16(CAN1_AM09H, val)
#define bfin_read_CAN1_AM10L()		bfin_read16(CAN1_AM10L)
#define bfin_write_CAN1_AM10L(val)	bfin_write16(CAN1_AM10L, val)
#define bfin_read_CAN1_AM10H()		bfin_read16(CAN1_AM10H)
#define bfin_write_CAN1_AM10H(val)	bfin_write16(CAN1_AM10H, val)
#define bfin_read_CAN1_AM11L()		bfin_read16(CAN1_AM11L)
#define bfin_write_CAN1_AM11L(val)	bfin_write16(CAN1_AM11L, val)
#define bfin_read_CAN1_AM11H()		bfin_read16(CAN1_AM11H)
#define bfin_write_CAN1_AM11H(val)	bfin_write16(CAN1_AM11H, val)
#define bfin_read_CAN1_AM12L()		bfin_read16(CAN1_AM12L)
#define bfin_write_CAN1_AM12L(val)	bfin_write16(CAN1_AM12L, val)
#define bfin_read_CAN1_AM12H()		bfin_read16(CAN1_AM12H)
#define bfin_write_CAN1_AM12H(val)	bfin_write16(CAN1_AM12H, val)
#define bfin_read_CAN1_AM13L()		bfin_read16(CAN1_AM13L)
#define bfin_write_CAN1_AM13L(val)	bfin_write16(CAN1_AM13L, val)
#define bfin_read_CAN1_AM13H()		bfin_read16(CAN1_AM13H)
#define bfin_write_CAN1_AM13H(val)	bfin_write16(CAN1_AM13H, val)
#define bfin_read_CAN1_AM14L()		bfin_read16(CAN1_AM14L)
#define bfin_write_CAN1_AM14L(val)	bfin_write16(CAN1_AM14L, val)
#define bfin_read_CAN1_AM14H()		bfin_read16(CAN1_AM14H)
#define bfin_write_CAN1_AM14H(val)	bfin_write16(CAN1_AM14H, val)
#define bfin_read_CAN1_AM15L()		bfin_read16(CAN1_AM15L)
#define bfin_write_CAN1_AM15L(val)	bfin_write16(CAN1_AM15L, val)
#define bfin_read_CAN1_AM15H()		bfin_read16(CAN1_AM15H)
#define bfin_write_CAN1_AM15H(val)	bfin_write16(CAN1_AM15H, val)

/* CAN Controller 1 Mailbox Accebfin_read_()tance Registers */

#define bfin_read_CAN1_AM16L()		bfin_read16(CAN1_AM16L)
#define bfin_write_CAN1_AM16L(val)	bfin_write16(CAN1_AM16L, val)
#define bfin_read_CAN1_AM16H()		bfin_read16(CAN1_AM16H)
#define bfin_write_CAN1_AM16H(val)	bfin_write16(CAN1_AM16H, val)
#define bfin_read_CAN1_AM17L()		bfin_read16(CAN1_AM17L)
#define bfin_write_CAN1_AM17L(val)	bfin_write16(CAN1_AM17L, val)
#define bfin_read_CAN1_AM17H()		bfin_read16(CAN1_AM17H)
#define bfin_write_CAN1_AM17H(val)	bfin_write16(CAN1_AM17H, val)
#define bfin_read_CAN1_AM18L()		bfin_read16(CAN1_AM18L)
#define bfin_write_CAN1_AM18L(val)	bfin_write16(CAN1_AM18L, val)
#define bfin_read_CAN1_AM18H()		bfin_read16(CAN1_AM18H)
#define bfin_write_CAN1_AM18H(val)	bfin_write16(CAN1_AM18H, val)
#define bfin_read_CAN1_AM19L()		bfin_read16(CAN1_AM19L)
#define bfin_write_CAN1_AM19L(val)	bfin_write16(CAN1_AM19L, val)
#define bfin_read_CAN1_AM19H()		bfin_read16(CAN1_AM19H)
#define bfin_write_CAN1_AM19H(val)	bfin_write16(CAN1_AM19H, val)
#define bfin_read_CAN1_AM20L()		bfin_read16(CAN1_AM20L)
#define bfin_write_CAN1_AM20L(val)	bfin_write16(CAN1_AM20L, val)
#define bfin_read_CAN1_AM20H()		bfin_read16(CAN1_AM20H)
#define bfin_write_CAN1_AM20H(val)	bfin_write16(CAN1_AM20H, val)
#define bfin_read_CAN1_AM21L()		bfin_read16(CAN1_AM21L)
#define bfin_write_CAN1_AM21L(val)	bfin_write16(CAN1_AM21L, val)
#define bfin_read_CAN1_AM21H()		bfin_read16(CAN1_AM21H)
#define bfin_write_CAN1_AM21H(val)	bfin_write16(CAN1_AM21H, val)
#define bfin_read_CAN1_AM22L()		bfin_read16(CAN1_AM22L)
#define bfin_write_CAN1_AM22L(val)	bfin_write16(CAN1_AM22L, val)
#define bfin_read_CAN1_AM22H()		bfin_read16(CAN1_AM22H)
#define bfin_write_CAN1_AM22H(val)	bfin_write16(CAN1_AM22H, val)
#define bfin_read_CAN1_AM23L()		bfin_read16(CAN1_AM23L)
#define bfin_write_CAN1_AM23L(val)	bfin_write16(CAN1_AM23L, val)
#define bfin_read_CAN1_AM23H()		bfin_read16(CAN1_AM23H)
#define bfin_write_CAN1_AM23H(val)	bfin_write16(CAN1_AM23H, val)
#define bfin_read_CAN1_AM24L()		bfin_read16(CAN1_AM24L)
#define bfin_write_CAN1_AM24L(val)	bfin_write16(CAN1_AM24L, val)
#define bfin_read_CAN1_AM24H()		bfin_read16(CAN1_AM24H)
#define bfin_write_CAN1_AM24H(val)	bfin_write16(CAN1_AM24H, val)
#define bfin_read_CAN1_AM25L()		bfin_read16(CAN1_AM25L)
#define bfin_write_CAN1_AM25L(val)	bfin_write16(CAN1_AM25L, val)
#define bfin_read_CAN1_AM25H()		bfin_read16(CAN1_AM25H)
#define bfin_write_CAN1_AM25H(val)	bfin_write16(CAN1_AM25H, val)
#define bfin_read_CAN1_AM26L()		bfin_read16(CAN1_AM26L)
#define bfin_write_CAN1_AM26L(val)	bfin_write16(CAN1_AM26L, val)
#define bfin_read_CAN1_AM26H()		bfin_read16(CAN1_AM26H)
#define bfin_write_CAN1_AM26H(val)	bfin_write16(CAN1_AM26H, val)
#define bfin_read_CAN1_AM27L()		bfin_read16(CAN1_AM27L)
#define bfin_write_CAN1_AM27L(val)	bfin_write16(CAN1_AM27L, val)
#define bfin_read_CAN1_AM27H()		bfin_read16(CAN1_AM27H)
#define bfin_write_CAN1_AM27H(val)	bfin_write16(CAN1_AM27H, val)
#define bfin_read_CAN1_AM28L()		bfin_read16(CAN1_AM28L)
#define bfin_write_CAN1_AM28L(val)	bfin_write16(CAN1_AM28L, val)
#define bfin_read_CAN1_AM28H()		bfin_read16(CAN1_AM28H)
#define bfin_write_CAN1_AM28H(val)	bfin_write16(CAN1_AM28H, val)
#define bfin_read_CAN1_AM29L()		bfin_read16(CAN1_AM29L)
#define bfin_write_CAN1_AM29L(val)	bfin_write16(CAN1_AM29L, val)
#define bfin_read_CAN1_AM29H()		bfin_read16(CAN1_AM29H)
#define bfin_write_CAN1_AM29H(val)	bfin_write16(CAN1_AM29H, val)
#define bfin_read_CAN1_AM30L()		bfin_read16(CAN1_AM30L)
#define bfin_write_CAN1_AM30L(val)	bfin_write16(CAN1_AM30L, val)
#define bfin_read_CAN1_AM30H()		bfin_read16(CAN1_AM30H)
#define bfin_write_CAN1_AM30H(val)	bfin_write16(CAN1_AM30H, val)
#define bfin_read_CAN1_AM31L()		bfin_read16(CAN1_AM31L)
#define bfin_write_CAN1_AM31L(val)	bfin_write16(CAN1_AM31L, val)
#define bfin_read_CAN1_AM31H()		bfin_read16(CAN1_AM31H)
#define bfin_write_CAN1_AM31H(val)	bfin_write16(CAN1_AM31H, val)

/* CAN Controller 1 Mailbox Data Registers */

#define bfin_read_CAN1_MB00_DATA0()		bfin_read16(CAN1_MB00_DATA0)
#define bfin_write_CAN1_MB00_DATA0(val)		bfin_write16(CAN1_MB00_DATA0, val)
#define bfin_read_CAN1_MB00_DATA1()		bfin_read16(CAN1_MB00_DATA1)
#define bfin_write_CAN1_MB00_DATA1(val)		bfin_write16(CAN1_MB00_DATA1, val)
#define bfin_read_CAN1_MB00_DATA2()		bfin_read16(CAN1_MB00_DATA2)
#define bfin_write_CAN1_MB00_DATA2(val)		bfin_write16(CAN1_MB00_DATA2, val)
#define bfin_read_CAN1_MB00_DATA3()		bfin_read16(CAN1_MB00_DATA3)
#define bfin_write_CAN1_MB00_DATA3(val)		bfin_write16(CAN1_MB00_DATA3, val)
#define bfin_read_CAN1_MB00_LENGTH()		bfin_read16(CAN1_MB00_LENGTH)
#define bfin_write_CAN1_MB00_LENGTH(val)	bfin_write16(CAN1_MB00_LENGTH, val)
#define bfin_read_CAN1_MB00_TIMESTAMP()		bfin_read16(CAN1_MB00_TIMESTAMP)
#define bfin_write_CAN1_MB00_TIMESTAMP(val)	bfin_write16(CAN1_MB00_TIMESTAMP, val)
#define bfin_read_CAN1_MB00_ID0()		bfin_read16(CAN1_MB00_ID0)
#define bfin_write_CAN1_MB00_ID0(val)		bfin_write16(CAN1_MB00_ID0, val)
#define bfin_read_CAN1_MB00_ID1()		bfin_read16(CAN1_MB00_ID1)
#define bfin_write_CAN1_MB00_ID1(val)		bfin_write16(CAN1_MB00_ID1, val)
#define bfin_read_CAN1_MB01_DATA0()		bfin_read16(CAN1_MB01_DATA0)
#define bfin_write_CAN1_MB01_DATA0(val)		bfin_write16(CAN1_MB01_DATA0, val)
#define bfin_read_CAN1_MB01_DATA1()		bfin_read16(CAN1_MB01_DATA1)
#define bfin_write_CAN1_MB01_DATA1(val)		bfin_write16(CAN1_MB01_DATA1, val)
#define bfin_read_CAN1_MB01_DATA2()		bfin_read16(CAN1_MB01_DATA2)
#define bfin_write_CAN1_MB01_DATA2(val)		bfin_write16(CAN1_MB01_DATA2, val)
#define bfin_read_CAN1_MB01_DATA3()		bfin_read16(CAN1_MB01_DATA3)
#define bfin_write_CAN1_MB01_DATA3(val)		bfin_write16(CAN1_MB01_DATA3, val)
#define bfin_read_CAN1_MB01_LENGTH()		bfin_read16(CAN1_MB01_LENGTH)
#define bfin_write_CAN1_MB01_LENGTH(val)	bfin_write16(CAN1_MB01_LENGTH, val)
#define bfin_read_CAN1_MB01_TIMESTAMP()		bfin_read16(CAN1_MB01_TIMESTAMP)
#define bfin_write_CAN1_MB01_TIMESTAMP(val)	bfin_write16(CAN1_MB01_TIMESTAMP, val)
#define bfin_read_CAN1_MB01_ID0()		bfin_read16(CAN1_MB01_ID0)
#define bfin_write_CAN1_MB01_ID0(val)		bfin_write16(CAN1_MB01_ID0, val)
#define bfin_read_CAN1_MB01_ID1()		bfin_read16(CAN1_MB01_ID1)
#define bfin_write_CAN1_MB01_ID1(val)		bfin_write16(CAN1_MB01_ID1, val)
#define bfin_read_CAN1_MB02_DATA0()		bfin_read16(CAN1_MB02_DATA0)
#define bfin_write_CAN1_MB02_DATA0(val)		bfin_write16(CAN1_MB02_DATA0, val)
#define bfin_read_CAN1_MB02_DATA1()		bfin_read16(CAN1_MB02_DATA1)
#define bfin_write_CAN1_MB02_DATA1(val)		bfin_write16(CAN1_MB02_DATA1, val)
#define bfin_read_CAN1_MB02_DATA2()		bfin_read16(CAN1_MB02_DATA2)
#define bfin_write_CAN1_MB02_DATA2(val)		bfin_write16(CAN1_MB02_DATA2, val)
#define bfin_read_CAN1_MB02_DATA3()		bfin_read16(CAN1_MB02_DATA3)
#define bfin_write_CAN1_MB02_DATA3(val)		bfin_write16(CAN1_MB02_DATA3, val)
#define bfin_read_CAN1_MB02_LENGTH()		bfin_read16(CAN1_MB02_LENGTH)
#define bfin_write_CAN1_MB02_LENGTH(val)	bfin_write16(CAN1_MB02_LENGTH, val)
#define bfin_read_CAN1_MB02_TIMESTAMP()		bfin_read16(CAN1_MB02_TIMESTAMP)
#define bfin_write_CAN1_MB02_TIMESTAMP(val)	bfin_write16(CAN1_MB02_TIMESTAMP, val)
#define bfin_read_CAN1_MB02_ID0()		bfin_read16(CAN1_MB02_ID0)
#define bfin_write_CAN1_MB02_ID0(val)		bfin_write16(CAN1_MB02_ID0, val)
#define bfin_read_CAN1_MB02_ID1()		bfin_read16(CAN1_MB02_ID1)
#define bfin_write_CAN1_MB02_ID1(val)		bfin_write16(CAN1_MB02_ID1, val)
#define bfin_read_CAN1_MB03_DATA0()		bfin_read16(CAN1_MB03_DATA0)
#define bfin_write_CAN1_MB03_DATA0(val)		bfin_write16(CAN1_MB03_DATA0, val)
#define bfin_read_CAN1_MB03_DATA1()		bfin_read16(CAN1_MB03_DATA1)
#define bfin_write_CAN1_MB03_DATA1(val)		bfin_write16(CAN1_MB03_DATA1, val)
#define bfin_read_CAN1_MB03_DATA2()		bfin_read16(CAN1_MB03_DATA2)
#define bfin_write_CAN1_MB03_DATA2(val)		bfin_write16(CAN1_MB03_DATA2, val)
#define bfin_read_CAN1_MB03_DATA3()		bfin_read16(CAN1_MB03_DATA3)
#define bfin_write_CAN1_MB03_DATA3(val)		bfin_write16(CAN1_MB03_DATA3, val)
#define bfin_read_CAN1_MB03_LENGTH()		bfin_read16(CAN1_MB03_LENGTH)
#define bfin_write_CAN1_MB03_LENGTH(val)	bfin_write16(CAN1_MB03_LENGTH, val)
#define bfin_read_CAN1_MB03_TIMESTAMP()		bfin_read16(CAN1_MB03_TIMESTAMP)
#define bfin_write_CAN1_MB03_TIMESTAMP(val)	bfin_write16(CAN1_MB03_TIMESTAMP, val)
#define bfin_read_CAN1_MB03_ID0()		bfin_read16(CAN1_MB03_ID0)
#define bfin_write_CAN1_MB03_ID0(val)		bfin_write16(CAN1_MB03_ID0, val)
#define bfin_read_CAN1_MB03_ID1()		bfin_read16(CAN1_MB03_ID1)
#define bfin_write_CAN1_MB03_ID1(val)		bfin_write16(CAN1_MB03_ID1, val)
#define bfin_read_CAN1_MB04_DATA0()		bfin_read16(CAN1_MB04_DATA0)
#define bfin_write_CAN1_MB04_DATA0(val)		bfin_write16(CAN1_MB04_DATA0, val)
#define bfin_read_CAN1_MB04_DATA1()		bfin_read16(CAN1_MB04_DATA1)
#define bfin_write_CAN1_MB04_DATA1(val)		bfin_write16(CAN1_MB04_DATA1, val)
#define bfin_read_CAN1_MB04_DATA2()		bfin_read16(CAN1_MB04_DATA2)
#define bfin_write_CAN1_MB04_DATA2(val)		bfin_write16(CAN1_MB04_DATA2, val)
#define bfin_read_CAN1_MB04_DATA3()		bfin_read16(CAN1_MB04_DATA3)
#define bfin_write_CAN1_MB04_DATA3(val)		bfin_write16(CAN1_MB04_DATA3, val)
#define bfin_read_CAN1_MB04_LENGTH()		bfin_read16(CAN1_MB04_LENGTH)
#define bfin_write_CAN1_MB04_LENGTH(val)	bfin_write16(CAN1_MB04_LENGTH, val)
#define bfin_read_CAN1_MB04_TIMESTAMP()		bfin_read16(CAN1_MB04_TIMESTAMP)
#define bfin_write_CAN1_MB04_TIMESTAMP(val)	bfin_write16(CAN1_MB04_TIMESTAMP, val)
#define bfin_read_CAN1_MB04_ID0()		bfin_read16(CAN1_MB04_ID0)
#define bfin_write_CAN1_MB04_ID0(val)		bfin_write16(CAN1_MB04_ID0, val)
#define bfin_read_CAN1_MB04_ID1()		bfin_read16(CAN1_MB04_ID1)
#define bfin_write_CAN1_MB04_ID1(val)		bfin_write16(CAN1_MB04_ID1, val)
#define bfin_read_CAN1_MB05_DATA0()		bfin_read16(CAN1_MB05_DATA0)
#define bfin_write_CAN1_MB05_DATA0(val)		bfin_write16(CAN1_MB05_DATA0, val)
#define bfin_read_CAN1_MB05_DATA1()		bfin_read16(CAN1_MB05_DATA1)
#define bfin_write_CAN1_MB05_DATA1(val)		bfin_write16(CAN1_MB05_DATA1, val)
#define bfin_read_CAN1_MB05_DATA2()		bfin_read16(CAN1_MB05_DATA2)
#define bfin_write_CAN1_MB05_DATA2(val)		bfin_write16(CAN1_MB05_DATA2, val)
#define bfin_read_CAN1_MB05_DATA3()		bfin_read16(CAN1_MB05_DATA3)
#define bfin_write_CAN1_MB05_DATA3(val)		bfin_write16(CAN1_MB05_DATA3, val)
#define bfin_read_CAN1_MB05_LENGTH()		bfin_read16(CAN1_MB05_LENGTH)
#define bfin_write_CAN1_MB05_LENGTH(val)	bfin_write16(CAN1_MB05_LENGTH, val)
#define bfin_read_CAN1_MB05_TIMESTAMP()		bfin_read16(CAN1_MB05_TIMESTAMP)
#define bfin_write_CAN1_MB05_TIMESTAMP(val)	bfin_write16(CAN1_MB05_TIMESTAMP, val)
#define bfin_read_CAN1_MB05_ID0()		bfin_read16(CAN1_MB05_ID0)
#define bfin_write_CAN1_MB05_ID0(val)		bfin_write16(CAN1_MB05_ID0, val)
#define bfin_read_CAN1_MB05_ID1()		bfin_read16(CAN1_MB05_ID1)
#define bfin_write_CAN1_MB05_ID1(val)		bfin_write16(CAN1_MB05_ID1, val)
#define bfin_read_CAN1_MB06_DATA0()		bfin_read16(CAN1_MB06_DATA0)
#define bfin_write_CAN1_MB06_DATA0(val)		bfin_write16(CAN1_MB06_DATA0, val)
#define bfin_read_CAN1_MB06_DATA1()		bfin_read16(CAN1_MB06_DATA1)
#define bfin_write_CAN1_MB06_DATA1(val)		bfin_write16(CAN1_MB06_DATA1, val)
#define bfin_read_CAN1_MB06_DATA2()		bfin_read16(CAN1_MB06_DATA2)
#define bfin_write_CAN1_MB06_DATA2(val)		bfin_write16(CAN1_MB06_DATA2, val)
#define bfin_read_CAN1_MB06_DATA3()		bfin_read16(CAN1_MB06_DATA3)
#define bfin_write_CAN1_MB06_DATA3(val)		bfin_write16(CAN1_MB06_DATA3, val)
#define bfin_read_CAN1_MB06_LENGTH()		bfin_read16(CAN1_MB06_LENGTH)
#define bfin_write_CAN1_MB06_LENGTH(val)	bfin_write16(CAN1_MB06_LENGTH, val)
#define bfin_read_CAN1_MB06_TIMESTAMP()		bfin_read16(CAN1_MB06_TIMESTAMP)
#define bfin_write_CAN1_MB06_TIMESTAMP(val)	bfin_write16(CAN1_MB06_TIMESTAMP, val)
#define bfin_read_CAN1_MB06_ID0()		bfin_read16(CAN1_MB06_ID0)
#define bfin_write_CAN1_MB06_ID0(val)		bfin_write16(CAN1_MB06_ID0, val)
#define bfin_read_CAN1_MB06_ID1()		bfin_read16(CAN1_MB06_ID1)
#define bfin_write_CAN1_MB06_ID1(val)		bfin_write16(CAN1_MB06_ID1, val)
#define bfin_read_CAN1_MB07_DATA0()		bfin_read16(CAN1_MB07_DATA0)
#define bfin_write_CAN1_MB07_DATA0(val)		bfin_write16(CAN1_MB07_DATA0, val)
#define bfin_read_CAN1_MB07_DATA1()		bfin_read16(CAN1_MB07_DATA1)
#define bfin_write_CAN1_MB07_DATA1(val)		bfin_write16(CAN1_MB07_DATA1, val)
#define bfin_read_CAN1_MB07_DATA2()		bfin_read16(CAN1_MB07_DATA2)
#define bfin_write_CAN1_MB07_DATA2(val)		bfin_write16(CAN1_MB07_DATA2, val)
#define bfin_read_CAN1_MB07_DATA3()		bfin_read16(CAN1_MB07_DATA3)
#define bfin_write_CAN1_MB07_DATA3(val)		bfin_write16(CAN1_MB07_DATA3, val)
#define bfin_read_CAN1_MB07_LENGTH()		bfin_read16(CAN1_MB07_LENGTH)
#define bfin_write_CAN1_MB07_LENGTH(val)	bfin_write16(CAN1_MB07_LENGTH, val)
#define bfin_read_CAN1_MB07_TIMESTAMP()		bfin_read16(CAN1_MB07_TIMESTAMP)
#define bfin_write_CAN1_MB07_TIMESTAMP(val)	bfin_write16(CAN1_MB07_TIMESTAMP, val)
#define bfin_read_CAN1_MB07_ID0()		bfin_read16(CAN1_MB07_ID0)
#define bfin_write_CAN1_MB07_ID0(val)		bfin_write16(CAN1_MB07_ID0, val)
#define bfin_read_CAN1_MB07_ID1()		bfin_read16(CAN1_MB07_ID1)
#define bfin_write_CAN1_MB07_ID1(val)		bfin_write16(CAN1_MB07_ID1, val)
#define bfin_read_CAN1_MB08_DATA0()		bfin_read16(CAN1_MB08_DATA0)
#define bfin_write_CAN1_MB08_DATA0(val)		bfin_write16(CAN1_MB08_DATA0, val)
#define bfin_read_CAN1_MB08_DATA1()		bfin_read16(CAN1_MB08_DATA1)
#define bfin_write_CAN1_MB08_DATA1(val)		bfin_write16(CAN1_MB08_DATA1, val)
#define bfin_read_CAN1_MB08_DATA2()		bfin_read16(CAN1_MB08_DATA2)
#define bfin_write_CAN1_MB08_DATA2(val)		bfin_write16(CAN1_MB08_DATA2, val)
#define bfin_read_CAN1_MB08_DATA3()		bfin_read16(CAN1_MB08_DATA3)
#define bfin_write_CAN1_MB08_DATA3(val)		bfin_write16(CAN1_MB08_DATA3, val)
#define bfin_read_CAN1_MB08_LENGTH()		bfin_read16(CAN1_MB08_LENGTH)
#define bfin_write_CAN1_MB08_LENGTH(val)	bfin_write16(CAN1_MB08_LENGTH, val)
#define bfin_read_CAN1_MB08_TIMESTAMP()		bfin_read16(CAN1_MB08_TIMESTAMP)
#define bfin_write_CAN1_MB08_TIMESTAMP(val)	bfin_write16(CAN1_MB08_TIMESTAMP, val)
#define bfin_read_CAN1_MB08_ID0()		bfin_read16(CAN1_MB08_ID0)
#define bfin_write_CAN1_MB08_ID0(val)		bfin_write16(CAN1_MB08_ID0, val)
#define bfin_read_CAN1_MB08_ID1()		bfin_read16(CAN1_MB08_ID1)
#define bfin_write_CAN1_MB08_ID1(val)		bfin_write16(CAN1_MB08_ID1, val)
#define bfin_read_CAN1_MB09_DATA0()		bfin_read16(CAN1_MB09_DATA0)
#define bfin_write_CAN1_MB09_DATA0(val)		bfin_write16(CAN1_MB09_DATA0, val)
#define bfin_read_CAN1_MB09_DATA1()		bfin_read16(CAN1_MB09_DATA1)
#define bfin_write_CAN1_MB09_DATA1(val)		bfin_write16(CAN1_MB09_DATA1, val)
#define bfin_read_CAN1_MB09_DATA2()		bfin_read16(CAN1_MB09_DATA2)
#define bfin_write_CAN1_MB09_DATA2(val)		bfin_write16(CAN1_MB09_DATA2, val)
#define bfin_read_CAN1_MB09_DATA3()		bfin_read16(CAN1_MB09_DATA3)
#define bfin_write_CAN1_MB09_DATA3(val)		bfin_write16(CAN1_MB09_DATA3, val)
#define bfin_read_CAN1_MB09_LENGTH()		bfin_read16(CAN1_MB09_LENGTH)
#define bfin_write_CAN1_MB09_LENGTH(val)	bfin_write16(CAN1_MB09_LENGTH, val)
#define bfin_read_CAN1_MB09_TIMESTAMP()		bfin_read16(CAN1_MB09_TIMESTAMP)
#define bfin_write_CAN1_MB09_TIMESTAMP(val)	bfin_write16(CAN1_MB09_TIMESTAMP, val)
#define bfin_read_CAN1_MB09_ID0()		bfin_read16(CAN1_MB09_ID0)
#define bfin_write_CAN1_MB09_ID0(val)		bfin_write16(CAN1_MB09_ID0, val)
#define bfin_read_CAN1_MB09_ID1()		bfin_read16(CAN1_MB09_ID1)
#define bfin_write_CAN1_MB09_ID1(val)		bfin_write16(CAN1_MB09_ID1, val)
#define bfin_read_CAN1_MB10_DATA0()		bfin_read16(CAN1_MB10_DATA0)
#define bfin_write_CAN1_MB10_DATA0(val)		bfin_write16(CAN1_MB10_DATA0, val)
#define bfin_read_CAN1_MB10_DATA1()		bfin_read16(CAN1_MB10_DATA1)
#define bfin_write_CAN1_MB10_DATA1(val)		bfin_write16(CAN1_MB10_DATA1, val)
#define bfin_read_CAN1_MB10_DATA2()		bfin_read16(CAN1_MB10_DATA2)
#define bfin_write_CAN1_MB10_DATA2(val)		bfin_write16(CAN1_MB10_DATA2, val)
#define bfin_read_CAN1_MB10_DATA3()		bfin_read16(CAN1_MB10_DATA3)
#define bfin_write_CAN1_MB10_DATA3(val)		bfin_write16(CAN1_MB10_DATA3, val)
#define bfin_read_CAN1_MB10_LENGTH()		bfin_read16(CAN1_MB10_LENGTH)
#define bfin_write_CAN1_MB10_LENGTH(val)	bfin_write16(CAN1_MB10_LENGTH, val)
#define bfin_read_CAN1_MB10_TIMESTAMP()		bfin_read16(CAN1_MB10_TIMESTAMP)
#define bfin_write_CAN1_MB10_TIMESTAMP(val)	bfin_write16(CAN1_MB10_TIMESTAMP, val)
#define bfin_read_CAN1_MB10_ID0()		bfin_read16(CAN1_MB10_ID0)
#define bfin_write_CAN1_MB10_ID0(val)		bfin_write16(CAN1_MB10_ID0, val)
#define bfin_read_CAN1_MB10_ID1()		bfin_read16(CAN1_MB10_ID1)
#define bfin_write_CAN1_MB10_ID1(val)		bfin_write16(CAN1_MB10_ID1, val)
#define bfin_read_CAN1_MB11_DATA0()		bfin_read16(CAN1_MB11_DATA0)
#define bfin_write_CAN1_MB11_DATA0(val)		bfin_write16(CAN1_MB11_DATA0, val)
#define bfin_read_CAN1_MB11_DATA1()		bfin_read16(CAN1_MB11_DATA1)
#define bfin_write_CAN1_MB11_DATA1(val)		bfin_write16(CAN1_MB11_DATA1, val)
#define bfin_read_CAN1_MB11_DATA2()		bfin_read16(CAN1_MB11_DATA2)
#define bfin_write_CAN1_MB11_DATA2(val)		bfin_write16(CAN1_MB11_DATA2, val)
#define bfin_read_CAN1_MB11_DATA3()		bfin_read16(CAN1_MB11_DATA3)
#define bfin_write_CAN1_MB11_DATA3(val)		bfin_write16(CAN1_MB11_DATA3, val)
#define bfin_read_CAN1_MB11_LENGTH()		bfin_read16(CAN1_MB11_LENGTH)
#define bfin_write_CAN1_MB11_LENGTH(val)	bfin_write16(CAN1_MB11_LENGTH, val)
#define bfin_read_CAN1_MB11_TIMESTAMP()		bfin_read16(CAN1_MB11_TIMESTAMP)
#define bfin_write_CAN1_MB11_TIMESTAMP(val)	bfin_write16(CAN1_MB11_TIMESTAMP, val)
#define bfin_read_CAN1_MB11_ID0()		bfin_read16(CAN1_MB11_ID0)
#define bfin_write_CAN1_MB11_ID0(val)		bfin_write16(CAN1_MB11_ID0, val)
#define bfin_read_CAN1_MB11_ID1()		bfin_read16(CAN1_MB11_ID1)
#define bfin_write_CAN1_MB11_ID1(val)		bfin_write16(CAN1_MB11_ID1, val)
#define bfin_read_CAN1_MB12_DATA0()		bfin_read16(CAN1_MB12_DATA0)
#define bfin_write_CAN1_MB12_DATA0(val)		bfin_write16(CAN1_MB12_DATA0, val)
#define bfin_read_CAN1_MB12_DATA1()		bfin_read16(CAN1_MB12_DATA1)
#define bfin_write_CAN1_MB12_DATA1(val)		bfin_write16(CAN1_MB12_DATA1, val)
#define bfin_read_CAN1_MB12_DATA2()		bfin_read16(CAN1_MB12_DATA2)
#define bfin_write_CAN1_MB12_DATA2(val)		bfin_write16(CAN1_MB12_DATA2, val)
#define bfin_read_CAN1_MB12_DATA3()		bfin_read16(CAN1_MB12_DATA3)
#define bfin_write_CAN1_MB12_DATA3(val)		bfin_write16(CAN1_MB12_DATA3, val)
#define bfin_read_CAN1_MB12_LENGTH()		bfin_read16(CAN1_MB12_LENGTH)
#define bfin_write_CAN1_MB12_LENGTH(val)	bfin_write16(CAN1_MB12_LENGTH, val)
#define bfin_read_CAN1_MB12_TIMESTAMP()		bfin_read16(CAN1_MB12_TIMESTAMP)
#define bfin_write_CAN1_MB12_TIMESTAMP(val)	bfin_write16(CAN1_MB12_TIMESTAMP, val)
#define bfin_read_CAN1_MB12_ID0()		bfin_read16(CAN1_MB12_ID0)
#define bfin_write_CAN1_MB12_ID0(val)		bfin_write16(CAN1_MB12_ID0, val)
#define bfin_read_CAN1_MB12_ID1()		bfin_read16(CAN1_MB12_ID1)
#define bfin_write_CAN1_MB12_ID1(val)		bfin_write16(CAN1_MB12_ID1, val)
#define bfin_read_CAN1_MB13_DATA0()		bfin_read16(CAN1_MB13_DATA0)
#define bfin_write_CAN1_MB13_DATA0(val)		bfin_write16(CAN1_MB13_DATA0, val)
#define bfin_read_CAN1_MB13_DATA1()		bfin_read16(CAN1_MB13_DATA1)
#define bfin_write_CAN1_MB13_DATA1(val)		bfin_write16(CAN1_MB13_DATA1, val)
#define bfin_read_CAN1_MB13_DATA2()		bfin_read16(CAN1_MB13_DATA2)
#define bfin_write_CAN1_MB13_DATA2(val)		bfin_write16(CAN1_MB13_DATA2, val)
#define bfin_read_CAN1_MB13_DATA3()		bfin_read16(CAN1_MB13_DATA3)
#define bfin_write_CAN1_MB13_DATA3(val)		bfin_write16(CAN1_MB13_DATA3, val)
#define bfin_read_CAN1_MB13_LENGTH()		bfin_read16(CAN1_MB13_LENGTH)
#define bfin_write_CAN1_MB13_LENGTH(val)	bfin_write16(CAN1_MB13_LENGTH, val)
#define bfin_read_CAN1_MB13_TIMESTAMP()		bfin_read16(CAN1_MB13_TIMESTAMP)
#define bfin_write_CAN1_MB13_TIMESTAMP(val)	bfin_write16(CAN1_MB13_TIMESTAMP, val)
#define bfin_read_CAN1_MB13_ID0()		bfin_read16(CAN1_MB13_ID0)
#define bfin_write_CAN1_MB13_ID0(val)		bfin_write16(CAN1_MB13_ID0, val)
#define bfin_read_CAN1_MB13_ID1()		bfin_read16(CAN1_MB13_ID1)
#define bfin_write_CAN1_MB13_ID1(val)		bfin_write16(CAN1_MB13_ID1, val)
#define bfin_read_CAN1_MB14_DATA0()		bfin_read16(CAN1_MB14_DATA0)
#define bfin_write_CAN1_MB14_DATA0(val)		bfin_write16(CAN1_MB14_DATA0, val)
#define bfin_read_CAN1_MB14_DATA1()		bfin_read16(CAN1_MB14_DATA1)
#define bfin_write_CAN1_MB14_DATA1(val)		bfin_write16(CAN1_MB14_DATA1, val)
#define bfin_read_CAN1_MB14_DATA2()		bfin_read16(CAN1_MB14_DATA2)
#define bfin_write_CAN1_MB14_DATA2(val)		bfin_write16(CAN1_MB14_DATA2, val)
#define bfin_read_CAN1_MB14_DATA3()		bfin_read16(CAN1_MB14_DATA3)
#define bfin_write_CAN1_MB14_DATA3(val)		bfin_write16(CAN1_MB14_DATA3, val)
#define bfin_read_CAN1_MB14_LENGTH()		bfin_read16(CAN1_MB14_LENGTH)
#define bfin_write_CAN1_MB14_LENGTH(val)	bfin_write16(CAN1_MB14_LENGTH, val)
#define bfin_read_CAN1_MB14_TIMESTAMP()		bfin_read16(CAN1_MB14_TIMESTAMP)
#define bfin_write_CAN1_MB14_TIMESTAMP(val)	bfin_write16(CAN1_MB14_TIMESTAMP, val)
#define bfin_read_CAN1_MB14_ID0()		bfin_read16(CAN1_MB14_ID0)
#define bfin_write_CAN1_MB14_ID0(val)		bfin_write16(CAN1_MB14_ID0, val)
#define bfin_read_CAN1_MB14_ID1()		bfin_read16(CAN1_MB14_ID1)
#define bfin_write_CAN1_MB14_ID1(val)		bfin_write16(CAN1_MB14_ID1, val)
#define bfin_read_CAN1_MB15_DATA0()		bfin_read16(CAN1_MB15_DATA0)
#define bfin_write_CAN1_MB15_DATA0(val)		bfin_write16(CAN1_MB15_DATA0, val)
#define bfin_read_CAN1_MB15_DATA1()		bfin_read16(CAN1_MB15_DATA1)
#define bfin_write_CAN1_MB15_DATA1(val)		bfin_write16(CAN1_MB15_DATA1, val)
#define bfin_read_CAN1_MB15_DATA2()		bfin_read16(CAN1_MB15_DATA2)
#define bfin_write_CAN1_MB15_DATA2(val)		bfin_write16(CAN1_MB15_DATA2, val)
#define bfin_read_CAN1_MB15_DATA3()		bfin_read16(CAN1_MB15_DATA3)
#define bfin_write_CAN1_MB15_DATA3(val)		bfin_write16(CAN1_MB15_DATA3, val)
#define bfin_read_CAN1_MB15_LENGTH()		bfin_read16(CAN1_MB15_LENGTH)
#define bfin_write_CAN1_MB15_LENGTH(val)	bfin_write16(CAN1_MB15_LENGTH, val)
#define bfin_read_CAN1_MB15_TIMESTAMP()		bfin_read16(CAN1_MB15_TIMESTAMP)
#define bfin_write_CAN1_MB15_TIMESTAMP(val)	bfin_write16(CAN1_MB15_TIMESTAMP, val)
#define bfin_read_CAN1_MB15_ID0()		bfin_read16(CAN1_MB15_ID0)
#define bfin_write_CAN1_MB15_ID0(val)		bfin_write16(CAN1_MB15_ID0, val)
#define bfin_read_CAN1_MB15_ID1()		bfin_read16(CAN1_MB15_ID1)
#define bfin_write_CAN1_MB15_ID1(val)		bfin_write16(CAN1_MB15_ID1, val)

/* CAN Controller 1 Mailbox Data Registers */

#define bfin_read_CAN1_MB16_DATA0()		bfin_read16(CAN1_MB16_DATA0)
#define bfin_write_CAN1_MB16_DATA0(val)		bfin_write16(CAN1_MB16_DATA0, val)
#define bfin_read_CAN1_MB16_DATA1()		bfin_read16(CAN1_MB16_DATA1)
#define bfin_write_CAN1_MB16_DATA1(val)		bfin_write16(CAN1_MB16_DATA1, val)
#define bfin_read_CAN1_MB16_DATA2()		bfin_read16(CAN1_MB16_DATA2)
#define bfin_write_CAN1_MB16_DATA2(val)		bfin_write16(CAN1_MB16_DATA2, val)
#define bfin_read_CAN1_MB16_DATA3()		bfin_read16(CAN1_MB16_DATA3)
#define bfin_write_CAN1_MB16_DATA3(val)		bfin_write16(CAN1_MB16_DATA3, val)
#define bfin_read_CAN1_MB16_LENGTH()		bfin_read16(CAN1_MB16_LENGTH)
#define bfin_write_CAN1_MB16_LENGTH(val)	bfin_write16(CAN1_MB16_LENGTH, val)
#define bfin_read_CAN1_MB16_TIMESTAMP()		bfin_read16(CAN1_MB16_TIMESTAMP)
#define bfin_write_CAN1_MB16_TIMESTAMP(val)	bfin_write16(CAN1_MB16_TIMESTAMP, val)
#define bfin_read_CAN1_MB16_ID0()		bfin_read16(CAN1_MB16_ID0)
#define bfin_write_CAN1_MB16_ID0(val)		bfin_write16(CAN1_MB16_ID0, val)
#define bfin_read_CAN1_MB16_ID1()		bfin_read16(CAN1_MB16_ID1)
#define bfin_write_CAN1_MB16_ID1(val)		bfin_write16(CAN1_MB16_ID1, val)
#define bfin_read_CAN1_MB17_DATA0()		bfin_read16(CAN1_MB17_DATA0)
#define bfin_write_CAN1_MB17_DATA0(val)		bfin_write16(CAN1_MB17_DATA0, val)
#define bfin_read_CAN1_MB17_DATA1()		bfin_read16(CAN1_MB17_DATA1)
#define bfin_write_CAN1_MB17_DATA1(val)		bfin_write16(CAN1_MB17_DATA1, val)
#define bfin_read_CAN1_MB17_DATA2()		bfin_read16(CAN1_MB17_DATA2)
#define bfin_write_CAN1_MB17_DATA2(val)		bfin_write16(CAN1_MB17_DATA2, val)
#define bfin_read_CAN1_MB17_DATA3()		bfin_read16(CAN1_MB17_DATA3)
#define bfin_write_CAN1_MB17_DATA3(val)		bfin_write16(CAN1_MB17_DATA3, val)
#define bfin_read_CAN1_MB17_LENGTH()		bfin_read16(CAN1_MB17_LENGTH)
#define bfin_write_CAN1_MB17_LENGTH(val)	bfin_write16(CAN1_MB17_LENGTH, val)
#define bfin_read_CAN1_MB17_TIMESTAMP()		bfin_read16(CAN1_MB17_TIMESTAMP)
#define bfin_write_CAN1_MB17_TIMESTAMP(val)	bfin_write16(CAN1_MB17_TIMESTAMP, val)
#define bfin_read_CAN1_MB17_ID0()		bfin_read16(CAN1_MB17_ID0)
#define bfin_write_CAN1_MB17_ID0(val)		bfin_write16(CAN1_MB17_ID0, val)
#define bfin_read_CAN1_MB17_ID1()		bfin_read16(CAN1_MB17_ID1)
#define bfin_write_CAN1_MB17_ID1(val)		bfin_write16(CAN1_MB17_ID1, val)
#define bfin_read_CAN1_MB18_DATA0()		bfin_read16(CAN1_MB18_DATA0)
#define bfin_write_CAN1_MB18_DATA0(val)		bfin_write16(CAN1_MB18_DATA0, val)
#define bfin_read_CAN1_MB18_DATA1()		bfin_read16(CAN1_MB18_DATA1)
#define bfin_write_CAN1_MB18_DATA1(val)		bfin_write16(CAN1_MB18_DATA1, val)
#define bfin_read_CAN1_MB18_DATA2()		bfin_read16(CAN1_MB18_DATA2)
#define bfin_write_CAN1_MB18_DATA2(val)		bfin_write16(CAN1_MB18_DATA2, val)
#define bfin_read_CAN1_MB18_DATA3()		bfin_read16(CAN1_MB18_DATA3)
#define bfin_write_CAN1_MB18_DATA3(val)		bfin_write16(CAN1_MB18_DATA3, val)
#define bfin_read_CAN1_MB18_LENGTH()		bfin_read16(CAN1_MB18_LENGTH)
#define bfin_write_CAN1_MB18_LENGTH(val)	bfin_write16(CAN1_MB18_LENGTH, val)
#define bfin_read_CAN1_MB18_TIMESTAMP()		bfin_read16(CAN1_MB18_TIMESTAMP)
#define bfin_write_CAN1_MB18_TIMESTAMP(val)	bfin_write16(CAN1_MB18_TIMESTAMP, val)
#define bfin_read_CAN1_MB18_ID0()		bfin_read16(CAN1_MB18_ID0)
#define bfin_write_CAN1_MB18_ID0(val)		bfin_write16(CAN1_MB18_ID0, val)
#define bfin_read_CAN1_MB18_ID1()		bfin_read16(CAN1_MB18_ID1)
#define bfin_write_CAN1_MB18_ID1(val)		bfin_write16(CAN1_MB18_ID1, val)
#define bfin_read_CAN1_MB19_DATA0()		bfin_read16(CAN1_MB19_DATA0)
#define bfin_write_CAN1_MB19_DATA0(val)		bfin_write16(CAN1_MB19_DATA0, val)
#define bfin_read_CAN1_MB19_DATA1()		bfin_read16(CAN1_MB19_DATA1)
#define bfin_write_CAN1_MB19_DATA1(val)		bfin_write16(CAN1_MB19_DATA1, val)
#define bfin_read_CAN1_MB19_DATA2()		bfin_read16(CAN1_MB19_DATA2)
#define bfin_write_CAN1_MB19_DATA2(val)		bfin_write16(CAN1_MB19_DATA2, val)
#define bfin_read_CAN1_MB19_DATA3()		bfin_read16(CAN1_MB19_DATA3)
#define bfin_write_CAN1_MB19_DATA3(val)		bfin_write16(CAN1_MB19_DATA3, val)
#define bfin_read_CAN1_MB19_LENGTH()		bfin_read16(CAN1_MB19_LENGTH)
#define bfin_write_CAN1_MB19_LENGTH(val)	bfin_write16(CAN1_MB19_LENGTH, val)
#define bfin_read_CAN1_MB19_TIMESTAMP()		bfin_read16(CAN1_MB19_TIMESTAMP)
#define bfin_write_CAN1_MB19_TIMESTAMP(val)	bfin_write16(CAN1_MB19_TIMESTAMP, val)
#define bfin_read_CAN1_MB19_ID0()		bfin_read16(CAN1_MB19_ID0)
#define bfin_write_CAN1_MB19_ID0(val)		bfin_write16(CAN1_MB19_ID0, val)
#define bfin_read_CAN1_MB19_ID1()		bfin_read16(CAN1_MB19_ID1)
#define bfin_write_CAN1_MB19_ID1(val)		bfin_write16(CAN1_MB19_ID1, val)
#define bfin_read_CAN1_MB20_DATA0()		bfin_read16(CAN1_MB20_DATA0)
#define bfin_write_CAN1_MB20_DATA0(val)		bfin_write16(CAN1_MB20_DATA0, val)
#define bfin_read_CAN1_MB20_DATA1()		bfin_read16(CAN1_MB20_DATA1)
#define bfin_write_CAN1_MB20_DATA1(val)		bfin_write16(CAN1_MB20_DATA1, val)
#define bfin_read_CAN1_MB20_DATA2()		bfin_read16(CAN1_MB20_DATA2)
#define bfin_write_CAN1_MB20_DATA2(val)		bfin_write16(CAN1_MB20_DATA2, val)
#define bfin_read_CAN1_MB20_DATA3()		bfin_read16(CAN1_MB20_DATA3)
#define bfin_write_CAN1_MB20_DATA3(val)		bfin_write16(CAN1_MB20_DATA3, val)
#define bfin_read_CAN1_MB20_LENGTH()		bfin_read16(CAN1_MB20_LENGTH)
#define bfin_write_CAN1_MB20_LENGTH(val)	bfin_write16(CAN1_MB20_LENGTH, val)
#define bfin_read_CAN1_MB20_TIMESTAMP()		bfin_read16(CAN1_MB20_TIMESTAMP)
#define bfin_write_CAN1_MB20_TIMESTAMP(val)	bfin_write16(CAN1_MB20_TIMESTAMP, val)
#define bfin_read_CAN1_MB20_ID0()		bfin_read16(CAN1_MB20_ID0)
#define bfin_write_CAN1_MB20_ID0(val)		bfin_write16(CAN1_MB20_ID0, val)
#define bfin_read_CAN1_MB20_ID1()		bfin_read16(CAN1_MB20_ID1)
#define bfin_write_CAN1_MB20_ID1(val)		bfin_write16(CAN1_MB20_ID1, val)
#define bfin_read_CAN1_MB21_DATA0()		bfin_read16(CAN1_MB21_DATA0)
#define bfin_write_CAN1_MB21_DATA0(val)		bfin_write16(CAN1_MB21_DATA0, val)
#define bfin_read_CAN1_MB21_DATA1()		bfin_read16(CAN1_MB21_DATA1)
#define bfin_write_CAN1_MB21_DATA1(val)		bfin_write16(CAN1_MB21_DATA1, val)
#define bfin_read_CAN1_MB21_DATA2()		bfin_read16(CAN1_MB21_DATA2)
#define bfin_write_CAN1_MB21_DATA2(val)		bfin_write16(CAN1_MB21_DATA2, val)
#define bfin_read_CAN1_MB21_DATA3()		bfin_read16(CAN1_MB21_DATA3)
#define bfin_write_CAN1_MB21_DATA3(val)		bfin_write16(CAN1_MB21_DATA3, val)
#define bfin_read_CAN1_MB21_LENGTH()		bfin_read16(CAN1_MB21_LENGTH)
#define bfin_write_CAN1_MB21_LENGTH(val)	bfin_write16(CAN1_MB21_LENGTH, val)
#define bfin_read_CAN1_MB21_TIMESTAMP()		bfin_read16(CAN1_MB21_TIMESTAMP)
#define bfin_write_CAN1_MB21_TIMESTAMP(val)	bfin_write16(CAN1_MB21_TIMESTAMP, val)
#define bfin_read_CAN1_MB21_ID0()		bfin_read16(CAN1_MB21_ID0)
#define bfin_write_CAN1_MB21_ID0(val)		bfin_write16(CAN1_MB21_ID0, val)
#define bfin_read_CAN1_MB21_ID1()		bfin_read16(CAN1_MB21_ID1)
#define bfin_write_CAN1_MB21_ID1(val)		bfin_write16(CAN1_MB21_ID1, val)
#define bfin_read_CAN1_MB22_DATA0()		bfin_read16(CAN1_MB22_DATA0)
#define bfin_write_CAN1_MB22_DATA0(val)		bfin_write16(CAN1_MB22_DATA0, val)
#define bfin_read_CAN1_MB22_DATA1()		bfin_read16(CAN1_MB22_DATA1)
#define bfin_write_CAN1_MB22_DATA1(val)		bfin_write16(CAN1_MB22_DATA1, val)
#define bfin_read_CAN1_MB22_DATA2()		bfin_read16(CAN1_MB22_DATA2)
#define bfin_write_CAN1_MB22_DATA2(val)		bfin_write16(CAN1_MB22_DATA2, val)
#define bfin_read_CAN1_MB22_DATA3()		bfin_read16(CAN1_MB22_DATA3)
#define bfin_write_CAN1_MB22_DATA3(val)		bfin_write16(CAN1_MB22_DATA3, val)
#define bfin_read_CAN1_MB22_LENGTH()		bfin_read16(CAN1_MB22_LENGTH)
#define bfin_write_CAN1_MB22_LENGTH(val)	bfin_write16(CAN1_MB22_LENGTH, val)
#define bfin_read_CAN1_MB22_TIMESTAMP()		bfin_read16(CAN1_MB22_TIMESTAMP)
#define bfin_write_CAN1_MB22_TIMESTAMP(val)	bfin_write16(CAN1_MB22_TIMESTAMP, val)
#define bfin_read_CAN1_MB22_ID0()		bfin_read16(CAN1_MB22_ID0)
#define bfin_write_CAN1_MB22_ID0(val)		bfin_write16(CAN1_MB22_ID0, val)
#define bfin_read_CAN1_MB22_ID1()		bfin_read16(CAN1_MB22_ID1)
#define bfin_write_CAN1_MB22_ID1(val)		bfin_write16(CAN1_MB22_ID1, val)
#define bfin_read_CAN1_MB23_DATA0()		bfin_read16(CAN1_MB23_DATA0)
#define bfin_write_CAN1_MB23_DATA0(val)		bfin_write16(CAN1_MB23_DATA0, val)
#define bfin_read_CAN1_MB23_DATA1()		bfin_read16(CAN1_MB23_DATA1)
#define bfin_write_CAN1_MB23_DATA1(val)		bfin_write16(CAN1_MB23_DATA1, val)
#define bfin_read_CAN1_MB23_DATA2()		bfin_read16(CAN1_MB23_DATA2)
#define bfin_write_CAN1_MB23_DATA2(val)		bfin_write16(CAN1_MB23_DATA2, val)
#define bfin_read_CAN1_MB23_DATA3()		bfin_read16(CAN1_MB23_DATA3)
#define bfin_write_CAN1_MB23_DATA3(val)		bfin_write16(CAN1_MB23_DATA3, val)
#define bfin_read_CAN1_MB23_LENGTH()		bfin_read16(CAN1_MB23_LENGTH)
#define bfin_write_CAN1_MB23_LENGTH(val)	bfin_write16(CAN1_MB23_LENGTH, val)
#define bfin_read_CAN1_MB23_TIMESTAMP()		bfin_read16(CAN1_MB23_TIMESTAMP)
#define bfin_write_CAN1_MB23_TIMESTAMP(val)	bfin_write16(CAN1_MB23_TIMESTAMP, val)
#define bfin_read_CAN1_MB23_ID0()		bfin_read16(CAN1_MB23_ID0)
#define bfin_write_CAN1_MB23_ID0(val)		bfin_write16(CAN1_MB23_ID0, val)
#define bfin_read_CAN1_MB23_ID1()		bfin_read16(CAN1_MB23_ID1)
#define bfin_write_CAN1_MB23_ID1(val)		bfin_write16(CAN1_MB23_ID1, val)
#define bfin_read_CAN1_MB24_DATA0()		bfin_read16(CAN1_MB24_DATA0)
#define bfin_write_CAN1_MB24_DATA0(val)		bfin_write16(CAN1_MB24_DATA0, val)
#define bfin_read_CAN1_MB24_DATA1()		bfin_read16(CAN1_MB24_DATA1)
#define bfin_write_CAN1_MB24_DATA1(val)		bfin_write16(CAN1_MB24_DATA1, val)
#define bfin_read_CAN1_MB24_DATA2()		bfin_read16(CAN1_MB24_DATA2)
#define bfin_write_CAN1_MB24_DATA2(val)		bfin_write16(CAN1_MB24_DATA2, val)
#define bfin_read_CAN1_MB24_DATA3()		bfin_read16(CAN1_MB24_DATA3)
#define bfin_write_CAN1_MB24_DATA3(val)		bfin_write16(CAN1_MB24_DATA3, val)
#define bfin_read_CAN1_MB24_LENGTH()		bfin_read16(CAN1_MB24_LENGTH)
#define bfin_write_CAN1_MB24_LENGTH(val)	bfin_write16(CAN1_MB24_LENGTH, val)
#define bfin_read_CAN1_MB24_TIMESTAMP()		bfin_read16(CAN1_MB24_TIMESTAMP)
#define bfin_write_CAN1_MB24_TIMESTAMP(val)	bfin_write16(CAN1_MB24_TIMESTAMP, val)
#define bfin_read_CAN1_MB24_ID0()		bfin_read16(CAN1_MB24_ID0)
#define bfin_write_CAN1_MB24_ID0(val)		bfin_write16(CAN1_MB24_ID0, val)
#define bfin_read_CAN1_MB24_ID1()		bfin_read16(CAN1_MB24_ID1)
#define bfin_write_CAN1_MB24_ID1(val)		bfin_write16(CAN1_MB24_ID1, val)
#define bfin_read_CAN1_MB25_DATA0()		bfin_read16(CAN1_MB25_DATA0)
#define bfin_write_CAN1_MB25_DATA0(val)		bfin_write16(CAN1_MB25_DATA0, val)
#define bfin_read_CAN1_MB25_DATA1()		bfin_read16(CAN1_MB25_DATA1)
#define bfin_write_CAN1_MB25_DATA1(val)		bfin_write16(CAN1_MB25_DATA1, val)
#define bfin_read_CAN1_MB25_DATA2()		bfin_read16(CAN1_MB25_DATA2)
#define bfin_write_CAN1_MB25_DATA2(val)		bfin_write16(CAN1_MB25_DATA2, val)
#define bfin_read_CAN1_MB25_DATA3()		bfin_read16(CAN1_MB25_DATA3)
#define bfin_write_CAN1_MB25_DATA3(val)		bfin_write16(CAN1_MB25_DATA3, val)
#define bfin_read_CAN1_MB25_LENGTH()		bfin_read16(CAN1_MB25_LENGTH)
#define bfin_write_CAN1_MB25_LENGTH(val)	bfin_write16(CAN1_MB25_LENGTH, val)
#define bfin_read_CAN1_MB25_TIMESTAMP()		bfin_read16(CAN1_MB25_TIMESTAMP)
#define bfin_write_CAN1_MB25_TIMESTAMP(val)	bfin_write16(CAN1_MB25_TIMESTAMP, val)
#define bfin_read_CAN1_MB25_ID0()		bfin_read16(CAN1_MB25_ID0)
#define bfin_write_CAN1_MB25_ID0(val)		bfin_write16(CAN1_MB25_ID0, val)
#define bfin_read_CAN1_MB25_ID1()		bfin_read16(CAN1_MB25_ID1)
#define bfin_write_CAN1_MB25_ID1(val)		bfin_write16(CAN1_MB25_ID1, val)
#define bfin_read_CAN1_MB26_DATA0()		bfin_read16(CAN1_MB26_DATA0)
#define bfin_write_CAN1_MB26_DATA0(val)		bfin_write16(CAN1_MB26_DATA0, val)
#define bfin_read_CAN1_MB26_DATA1()		bfin_read16(CAN1_MB26_DATA1)
#define bfin_write_CAN1_MB26_DATA1(val)		bfin_write16(CAN1_MB26_DATA1, val)
#define bfin_read_CAN1_MB26_DATA2()		bfin_read16(CAN1_MB26_DATA2)
#define bfin_write_CAN1_MB26_DATA2(val)		bfin_write16(CAN1_MB26_DATA2, val)
#define bfin_read_CAN1_MB26_DATA3()		bfin_read16(CAN1_MB26_DATA3)
#define bfin_write_CAN1_MB26_DATA3(val)		bfin_write16(CAN1_MB26_DATA3, val)
#define bfin_read_CAN1_MB26_LENGTH()		bfin_read16(CAN1_MB26_LENGTH)
#define bfin_write_CAN1_MB26_LENGTH(val)	bfin_write16(CAN1_MB26_LENGTH, val)
#define bfin_read_CAN1_MB26_TIMESTAMP()		bfin_read16(CAN1_MB26_TIMESTAMP)
#define bfin_write_CAN1_MB26_TIMESTAMP(val)	bfin_write16(CAN1_MB26_TIMESTAMP, val)
#define bfin_read_CAN1_MB26_ID0()		bfin_read16(CAN1_MB26_ID0)
#define bfin_write_CAN1_MB26_ID0(val)		bfin_write16(CAN1_MB26_ID0, val)
#define bfin_read_CAN1_MB26_ID1()		bfin_read16(CAN1_MB26_ID1)
#define bfin_write_CAN1_MB26_ID1(val)		bfin_write16(CAN1_MB26_ID1, val)
#define bfin_read_CAN1_MB27_DATA0()		bfin_read16(CAN1_MB27_DATA0)
#define bfin_write_CAN1_MB27_DATA0(val)		bfin_write16(CAN1_MB27_DATA0, val)
#define bfin_read_CAN1_MB27_DATA1()		bfin_read16(CAN1_MB27_DATA1)
#define bfin_write_CAN1_MB27_DATA1(val)		bfin_write16(CAN1_MB27_DATA1, val)
#define bfin_read_CAN1_MB27_DATA2()		bfin_read16(CAN1_MB27_DATA2)
#define bfin_write_CAN1_MB27_DATA2(val)		bfin_write16(CAN1_MB27_DATA2, val)
#define bfin_read_CAN1_MB27_DATA3()		bfin_read16(CAN1_MB27_DATA3)
#define bfin_write_CAN1_MB27_DATA3(val)		bfin_write16(CAN1_MB27_DATA3, val)
#define bfin_read_CAN1_MB27_LENGTH()		bfin_read16(CAN1_MB27_LENGTH)
#define bfin_write_CAN1_MB27_LENGTH(val)	bfin_write16(CAN1_MB27_LENGTH, val)
#define bfin_read_CAN1_MB27_TIMESTAMP()		bfin_read16(CAN1_MB27_TIMESTAMP)
#define bfin_write_CAN1_MB27_TIMESTAMP(val)	bfin_write16(CAN1_MB27_TIMESTAMP, val)
#define bfin_read_CAN1_MB27_ID0()		bfin_read16(CAN1_MB27_ID0)
#define bfin_write_CAN1_MB27_ID0(val)		bfin_write16(CAN1_MB27_ID0, val)
#define bfin_read_CAN1_MB27_ID1()		bfin_read16(CAN1_MB27_ID1)
#define bfin_write_CAN1_MB27_ID1(val)		bfin_write16(CAN1_MB27_ID1, val)
#define bfin_read_CAN1_MB28_DATA0()		bfin_read16(CAN1_MB28_DATA0)
#define bfin_write_CAN1_MB28_DATA0(val)		bfin_write16(CAN1_MB28_DATA0, val)
#define bfin_read_CAN1_MB28_DATA1()		bfin_read16(CAN1_MB28_DATA1)
#define bfin_write_CAN1_MB28_DATA1(val)		bfin_write16(CAN1_MB28_DATA1, val)
#define bfin_read_CAN1_MB28_DATA2()		bfin_read16(CAN1_MB28_DATA2)
#define bfin_write_CAN1_MB28_DATA2(val)		bfin_write16(CAN1_MB28_DATA2, val)
#define bfin_read_CAN1_MB28_DATA3()		bfin_read16(CAN1_MB28_DATA3)
#define bfin_write_CAN1_MB28_DATA3(val)		bfin_write16(CAN1_MB28_DATA3, val)
#define bfin_read_CAN1_MB28_LENGTH()		bfin_read16(CAN1_MB28_LENGTH)
#define bfin_write_CAN1_MB28_LENGTH(val)	bfin_write16(CAN1_MB28_LENGTH, val)
#define bfin_read_CAN1_MB28_TIMESTAMP()		bfin_read16(CAN1_MB28_TIMESTAMP)
#define bfin_write_CAN1_MB28_TIMESTAMP(val)	bfin_write16(CAN1_MB28_TIMESTAMP, val)
#define bfin_read_CAN1_MB28_ID0()		bfin_read16(CAN1_MB28_ID0)
#define bfin_write_CAN1_MB28_ID0(val)		bfin_write16(CAN1_MB28_ID0, val)
#define bfin_read_CAN1_MB28_ID1()		bfin_read16(CAN1_MB28_ID1)
#define bfin_write_CAN1_MB28_ID1(val)		bfin_write16(CAN1_MB28_ID1, val)
#define bfin_read_CAN1_MB29_DATA0()		bfin_read16(CAN1_MB29_DATA0)
#define bfin_write_CAN1_MB29_DATA0(val)		bfin_write16(CAN1_MB29_DATA0, val)
#define bfin_read_CAN1_MB29_DATA1()		bfin_read16(CAN1_MB29_DATA1)
#define bfin_write_CAN1_MB29_DATA1(val)		bfin_write16(CAN1_MB29_DATA1, val)
#define bfin_read_CAN1_MB29_DATA2()		bfin_read16(CAN1_MB29_DATA2)
#define bfin_write_CAN1_MB29_DATA2(val)		bfin_write16(CAN1_MB29_DATA2, val)
#define bfin_read_CAN1_MB29_DATA3()		bfin_read16(CAN1_MB29_DATA3)
#define bfin_write_CAN1_MB29_DATA3(val)		bfin_write16(CAN1_MB29_DATA3, val)
#define bfin_read_CAN1_MB29_LENGTH()		bfin_read16(CAN1_MB29_LENGTH)
#define bfin_write_CAN1_MB29_LENGTH(val)	bfin_write16(CAN1_MB29_LENGTH, val)
#define bfin_read_CAN1_MB29_TIMESTAMP()		bfin_read16(CAN1_MB29_TIMESTAMP)
#define bfin_write_CAN1_MB29_TIMESTAMP(val)	bfin_write16(CAN1_MB29_TIMESTAMP, val)
#define bfin_read_CAN1_MB29_ID0()		bfin_read16(CAN1_MB29_ID0)
#define bfin_write_CAN1_MB29_ID0(val)		bfin_write16(CAN1_MB29_ID0, val)
#define bfin_read_CAN1_MB29_ID1()		bfin_read16(CAN1_MB29_ID1)
#define bfin_write_CAN1_MB29_ID1(val)		bfin_write16(CAN1_MB29_ID1, val)
#define bfin_read_CAN1_MB30_DATA0()		bfin_read16(CAN1_MB30_DATA0)
#define bfin_write_CAN1_MB30_DATA0(val)		bfin_write16(CAN1_MB30_DATA0, val)
#define bfin_read_CAN1_MB30_DATA1()		bfin_read16(CAN1_MB30_DATA1)
#define bfin_write_CAN1_MB30_DATA1(val)		bfin_write16(CAN1_MB30_DATA1, val)
#define bfin_read_CAN1_MB30_DATA2()		bfin_read16(CAN1_MB30_DATA2)
#define bfin_write_CAN1_MB30_DATA2(val)		bfin_write16(CAN1_MB30_DATA2, val)
#define bfin_read_CAN1_MB30_DATA3()		bfin_read16(CAN1_MB30_DATA3)
#define bfin_write_CAN1_MB30_DATA3(val)		bfin_write16(CAN1_MB30_DATA3, val)
#define bfin_read_CAN1_MB30_LENGTH()		bfin_read16(CAN1_MB30_LENGTH)
#define bfin_write_CAN1_MB30_LENGTH(val)	bfin_write16(CAN1_MB30_LENGTH, val)
#define bfin_read_CAN1_MB30_TIMESTAMP()		bfin_read16(CAN1_MB30_TIMESTAMP)
#define bfin_write_CAN1_MB30_TIMESTAMP(val)	bfin_write16(CAN1_MB30_TIMESTAMP, val)
#define bfin_read_CAN1_MB30_ID0()		bfin_read16(CAN1_MB30_ID0)
#define bfin_write_CAN1_MB30_ID0(val)		bfin_write16(CAN1_MB30_ID0, val)
#define bfin_read_CAN1_MB30_ID1()		bfin_read16(CAN1_MB30_ID1)
#define bfin_write_CAN1_MB30_ID1(val)		bfin_write16(CAN1_MB30_ID1, val)
#define bfin_read_CAN1_MB31_DATA0()		bfin_read16(CAN1_MB31_DATA0)
#define bfin_write_CAN1_MB31_DATA0(val)		bfin_write16(CAN1_MB31_DATA0, val)
#define bfin_read_CAN1_MB31_DATA1()		bfin_read16(CAN1_MB31_DATA1)
#define bfin_write_CAN1_MB31_DATA1(val)		bfin_write16(CAN1_MB31_DATA1, val)
#define bfin_read_CAN1_MB31_DATA2()		bfin_read16(CAN1_MB31_DATA2)
#define bfin_write_CAN1_MB31_DATA2(val)		bfin_write16(CAN1_MB31_DATA2, val)
#define bfin_read_CAN1_MB31_DATA3()		bfin_read16(CAN1_MB31_DATA3)
#define bfin_write_CAN1_MB31_DATA3(val)		bfin_write16(CAN1_MB31_DATA3, val)
#define bfin_read_CAN1_MB31_LENGTH()		bfin_read16(CAN1_MB31_LENGTH)
#define bfin_write_CAN1_MB31_LENGTH(val)	bfin_write16(CAN1_MB31_LENGTH, val)
#define bfin_read_CAN1_MB31_TIMESTAMP()		bfin_read16(CAN1_MB31_TIMESTAMP)
#define bfin_write_CAN1_MB31_TIMESTAMP(val)	bfin_write16(CAN1_MB31_TIMESTAMP, val)
#define bfin_read_CAN1_MB31_ID0()		bfin_read16(CAN1_MB31_ID0)
#define bfin_write_CAN1_MB31_ID0(val)		bfin_write16(CAN1_MB31_ID0, val)
#define bfin_read_CAN1_MB31_ID1()		bfin_read16(CAN1_MB31_ID1)
#define bfin_write_CAN1_MB31_ID1(val)		bfin_write16(CAN1_MB31_ID1, val)

#endif /* _CDEF_BF548_H */
