/*
 * Internal Interrupt Vectors 
 *
 * This takes care of interrupts that are generated by the CPU
 * internally, such as the ITC and IPI interrupts.
 *
 * Copyright (C) 1999 VA Linux Systems
 * Copyright (C) 1999 Walt Drummond <drummond@valinux.com>
 * Copyright (C) 2000 Hewlett-Packard Co
 * Copyright (C) 2000 David Mosberger-Tang <davidm@hpl.hp.com>
 */

#include <linux/irq.h>

static unsigned int
internal_noop_startup (unsigned int irq)
{
	return 0;
}

static void
internal_noop (unsigned int irq)
{
	/* nuthing to do... */
}

struct hw_interrupt_type irq_type_ia64_internal = {
	typename:	"IA64-internal",
	startup:	internal_noop_startup,
	shutdown:	internal_noop,
	enable:		internal_noop,
	disable:	internal_noop,
	ack:		internal_noop,
	end:		internal_noop,
	set_affinity:	(void (*)(unsigned int, unsigned long)) internal_noop
};
