WHITE	[ \t]
ID1	[A-Z_a-z]
ID2	[0-9A-Z_a-z]

%{
#include "lexsyms.h"
extern int line_no;
/*
 * Copyright (C) 1994, Bjorn Ekwall <bj0rn@blox.se>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
%}

%%
^#" 1 "\".*\"/\n	{ return FILENAME; }
^#.*			{}

"struct"		{ return STRUCT; }
"union"			{ return UNION; }
"enum"			{ return ENUM; }
"typedef"		{ return TYPEDEF; }

"static"		{ return S_TYPE; }
"extern"		{ return S_TYPE; }
"inline"		{ return S_TYPE; }
"__inline__"		{ return S_TYPE; }
"const"			{ return S_TYPE; }
"volatile"		{ return S_TYPE; }
"__attribute__"		{ return S_TYPE; }

"void"			{ return TYPE; }
"char"			{ return TYPE; }
"short"			{ return TYPE; }
"int"			{ return TYPE; }
"long"			{ return TYPE; }
"signed"		{ return TYPE; }
"unsigned"		{ return TYPE; }
"float"			{ return TYPE; }
"double"		{ return TYPE; }

({ID1})({ID2})*		{ return IDENT; }

{WHITE}+		{}
"\n"			{ ++line_no; }

"\""			{ return STRING; }
"'"			{ return STRING; }

";"			{ return SEMI; }
"{"			{ return LBRACE; }
"}"			{ return RBRACE; }
"("			{ return LPAREN; }
")"			{ return RPAREN; }

.			{ return OTHER; }

%%
