/******************************* */
/* Rule Set Based Access Control */
/* Author and (c) 1999-2001:     */
/*   Amon Ott <ao@rsbac.org>     */
/* debug definitions             */
/* Last modified: 05/Jul/2002    */
/******************************* */

#ifndef __RSBAC_DEBUG_H
#define __RSBAC_DEBUG_H

#include <linux/init.h>
#include <rsbac/types.h>

#ifdef CONFIG_RSBAC_DEBUG
extern int rsbac_debug_ds;
extern int rsbac_debug_write;
extern int rsbac_debug_stack;
extern int rsbac_debug_lists;
extern int rsbac_debug_aef;
extern int rsbac_debug_no_write;
#endif

extern int rsbac_debug_adf_default;
extern rsbac_log_entry_t  rsbac_log_levels[R_NONE+1];

#define RSBAC_LOG_LEVELS_NAME "log_levels"
#define RSBAC_LOG_LEVEL_LIST_NAME "ll"
#define RSBAC_LOG_LEVEL_VERSION 1
#define RSBAC_LOG_LEVEL_KEY 13123231

extern int rsbac_no_defaults;

#ifdef CONFIG_RSBAC_INIT_DELAY
extern void rsbac_init_debug(void);
#else
extern void rsbac_init_debug(void) __init;
#endif

extern boolean rsbac_parse_koptions(char *);

#define RSBAC_WAKEUP_KEY 'w'
#define RSBAC_WAKEUP_UKEY 'W'

#ifdef CONFIG_RSBAC_SOFTMODE
#define RSBAC_SOFTMODE_KEY 'x'
#define RSBAC_SOFTMODE_UKEY 'X'
extern int rsbac_softmode;
extern int rsbac_in_softmode(void);
#ifdef CONFIG_RSBAC_SOFTMODE_IND
extern int  rsbac_ind_softmode[SW_NONE];
#endif
#endif

#if defined(CONFIG_RSBAC_CAP_PROC_HIDE)
extern int rsbac_cap_process_hiding;
#endif

#ifdef CONFIG_RSBAC_ALLOW_DAC_DISABLE_FULL
extern int rsbac_dac_disable;
extern int rsbac_dac_is_disabled(void);
#endif

#ifdef CONFIG_RSBAC_RMSG_NOSYSLOG
extern int rsbac_nosyslog;
#endif

#ifdef CONFIG_RSBAC_INIT_DELAY
extern int rsbac_delay_init;
extern kdev_t rsbac_delayed_root;
#endif

#if defined(CONFIG_RSBAC_RMSG)
#define RSBAC_LOG rsbac_printk
#define RSBAC_DEF_MESS_LOGLEVEL 4
extern int rsbac_printk(const char *, ...);
extern int rsbac_log(int, char *, int);
#else
#define RSBAC_LOG printk
#endif

#if defined(CONFIG_RSBAC_LOG_REMOTE)
extern rsbac_pid_t rsbaclogd_pid;
#endif

#ifdef CONFIG_RSBAC_NET
extern int rsbac_debug_ds_net;
extern int rsbac_debug_aef_net;
extern int rsbac_debug_adf_net;
#endif

extern void wakeup_rsbacd(u_long dummy);

/* switch log level for request */
void  rsbac_adf_log_switch(rsbac_adf_request_int_t request,
                           enum rsbac_target_t target,
                           rsbac_enum_t value);

int rsbac_get_adf_log(rsbac_adf_request_int_t request,
                      enum rsbac_target_t target,
                      u_int * value_p);

#ifdef CONFIG_RSBAC_DEBUG
#if defined(CONFIG_RSBAC_AUTO_WRITE) && (CONFIG_RSBAC_AUTO_WRITE > 0)
extern int rsbac_debug_auto;
#endif /* CONFIG_RSBAC_AUTO_WRITE > 0 */

#if defined(CONFIG_RSBAC_MAC)
extern int rsbac_debug_ds_mac;
extern int rsbac_debug_aef_mac;
extern int rsbac_debug_adf_mac;
#endif

#if defined(CONFIG_RSBAC_PM) || defined(CONFIG_RSBAC_PM_MAINT)
extern int rsbac_debug_ds_pm;
extern int rsbac_debug_aef_pm;
extern int rsbac_debug_adf_pm;
#endif

#if defined(CONFIG_RSBAC_MS) || defined(CONFIG_RSBAC_MS_MAINT)
extern int rsbac_debug_adf_ms;
#endif

#if defined(CONFIG_RSBAC_RC) || defined(CONFIG_RSBAC_RC_MAINT)
extern int rsbac_debug_ds_rc;
extern int rsbac_debug_aef_rc;
extern int rsbac_debug_adf_rc;
#endif

#if defined(CONFIG_RSBAC_AUTH) || defined(CONFIG_RSBAC_AUTH_MAINT)
extern int rsbac_debug_ds_auth;
extern int rsbac_debug_aef_auth;
extern int rsbac_debug_adf_auth;
#endif

#if defined(CONFIG_RSBAC_REG) || defined(CONFIG_RSBAC_REG_MAINT)
extern int rsbac_debug_reg;
#endif

#if defined(CONFIG_RSBAC_ACL) || defined(CONFIG_RSBAC_ACL_MAINT)
extern int rsbac_debug_ds_acl;
extern int rsbac_debug_aef_acl;
extern int rsbac_debug_adf_acl;
#endif

#if defined(CONFIG_RSBAC_JAIL)
extern int rsbac_debug_aef_jail;
extern int rsbac_debug_adf_jail;
#endif

#endif /* DEBUG */

#if defined(CONFIG_RSBAC_AUTH) || defined(CONFIG_RSBAC_AUTH_MAINT)
extern int rsbac_auth_enable_login;
#endif

#endif
