###
### PROTOPKG
###

# parse the command line options
CL=`getopt -o vcbp::h --long verbose,cleanup,batch,package::,help -- "$@"`

# no options, show the help screen and terminate
if [ ! $? = 0 ]
then
   protopkg_help
   exit
fi

# set the parsed options to be our new positional parameter list
eval set -- "$CL"

# evaluate the command line options
for OPT in $@
do
   case $OPT in
      "-v"|"--verbose")
         VERBOSE=y
         shift ;;
      "-c"|"--cleanup")
         CLEANUP=y
         shift ;;
      "-b"|"--batch")
         BATCH=y
         shift ;;
      "-p"|"--package")
         if [ "$2" = "" ]
         then
            SKIP_SUBPACKS=y
         else
            BUILD_SUBPACK=$2
         fi
         shift 2;;
      "-h"|"--help")
         protopkg_help
         exit ;;
      --)
         shift
         break ;;
   esac
done

# install the packages the user specifies
protopkg ; exit
