/* GKrellM
|  Copyright (C) 2025 Stefan Gehn
|
|  Author:  Stefan Gehn    stefan+gkrellm@srcbox.net
|  Latest versions might be found at:  https://gkrellm.srcbox.net
|
|
|  GKrellM is free software: you can redistribute it and/or modify it
|  under the terms of the GNU General Public License as published by
|  the Free Software Foundation, either version 3 of the License, or
|  (at your option) any later version.
|
|  GKrellM is distributed in the hope that it will be useful, but WITHOUT
|  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
|  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
|  License for more details.
|
|  You should have received a copy of the GNU General Public License
|  along with this program. If not, see http://www.gnu.org/licenses/
|
|
|  Additional permission under GNU GPL version 3 section 7
|
|  If you modify this program, or any covered work, by linking or
|  combining it with the OpenSSL project's OpenSSL library (or a
|  modified version of that library), containing parts covered by
|  the terms of the OpenSSL or SSLeay licenses, you are granted
|  additional permission to convey the resulting work.
|  Corresponding Source for a non-source form of such a combination
|  shall include the source code for the parts of OpenSSL used as well
|  as that of the covered work.
*/

#ifndef GKRELLM_VISIBILITY_H
#define GKRELLM_VISIBILITY_H

#if defined(_WIN32) || defined(__CYGWIN__)
#define GKRELLM_EXPORT __declspec(dllexport)
#define GKRELLM_IMPORT __declspec(dllimport) extern
#elif __GNUC__ >= 4
#define GKRELLM_EXPORT __attribute__((visibility("default")))
#define GKRELLM_IMPORT extern
#else
#define GKRELLM_EXPORT
#define GKRELLM_IMPORT extern
#endif

// Symbol visibility & win32 import/export macro for public gkrellm API
#if defined(GKRELLM_CLIENT) || defined(GKRELLM_SERVER)
#define GKRELLM_API GKRELLM_EXPORT
#else
#define GKRELLM_API GKRELLM_IMPORT
#endif

#endif
