##
##  GNU Pth - The GNU Portable Threads
##  Copyright (c) 1999-2006 Ralf S. Engelschall <rse@engelschall.com>
##
##  This file is part of GNU Pth, a non-preemptive thread scheduling
##  library which can be found at http://www.gnu.org/software/pth/.
##
##  This library is free software; you can redistribute it and/or
##  modify it under the terms of the GNU Lesser General Public
##  License as published by the Free Software Foundation; either
##  version 2.1 of the License, or (at your option) any later version.
##
##  This library is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
##  Lesser General Public License for more details.
##
##  You should have received a copy of the GNU Lesser General Public
##  License along with this library; if not, write to the Free Software
##  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
##  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
##
##  striptease.pl: Strip down the Pth source tree to its minimum
##
                              # ``Mobius strippers never
                              #   show you their back side.''
require 5.000;

$|++;

my $src = '.';
my $tmp = $ENV{'TMPDIR'} || '/tmp';
my $dst = "$tmp/pth-striptease";

sub kbof {
    my ($dir) = @_;
    my ($b);

    $b = 0;
    for $file (glob("$dir/*")) {
        my @S = stat($file);
        $b += $S[7];
    }
    return $b / 1024;
}

printf("Stripping down source tree from %d KB to its minimum... ", &kbof($src));

system("rm -rf $dst") if (-d $dst);
system("mkdir $dst")  if (not -d $dst);

open(FP, ">$dst/README.1st");
print FP <<"EOT";

   This is a heavily stripped down version of the GNU Pth
   (GNU Portable Threads) package. It was automatically
   generated by a call to ``make striptease'' from within
   a full-sized GNU Pth source tree. DO NOT EDIT ANYTHING
   HERE. CHANGES WILL BE LOST IF AN UPDATED STRIPPED DOWN
   VERSION IS IMPORTED NEXT TIME TO THIS AREA. For the
   complete source go to http://www.gnu.org/software/pth/.

EOT
close(FP);

@files = (qw(
    COPYING
    README
    config.guess config.sub
    pth.h.in
    pth_p.h.in
    pth_acdef.h.in pth_acmac.h.in
    pth_vers.c
    pthread.c
    pthread.h.in
));

@source = (qw(
    pth_compat.c pth_debug.c pth_syscall.c pth_errno.c pth_ring.c pth_mctx.c
    pth_uctx.c pth_clean.c pth_time.c pth_tcb.c pth_util.c pth_pqueue.c pth_event.c
    pth_sched.c pth_data.c pth_msg.c pth_cancel.c pth_sync.c pth_attr.c pth_lib.c
    pth_fork.c pth_high.c pth_ext.c pth_string.c
));

foreach $f (@files) {
    system("cp -p $src/$f $dst/$f");
}

$pth_c = <<'EOT';
/*
**  GNU Pth - The GNU Portable Threads
**  Copyright (c) 1999-2006 Ralf S. Engelschall <rse@engelschall.com>
**
**  This file is part of GNU Pth, a non-preemptive thread scheduling
**  library which can be found at http://www.gnu.org/software/pth/.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2 of the License, or (at your option) any later version.
**
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
**  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
**
**  pth.c: Pth all-in-one source (AUTO-GENERATED, DO NOT EDIT!)
*/

#include "pth_p.h"

EOT

foreach $s (@source) {
    open(FP, "<$src/$s");
    $st = '';
    $st .= $_ while (<FP>);
    close(FP);
    $st =~ s|^.+?#include "pth_p.h"\s*\n|/* ==== $s ==== */\n\n|si;
    $pth_c .= $st;
}
open(FP, ">$dst/pth.c");
print FP $pth_c;
close(FP);

open(FP, "<$src/configure");
$c = '';
$c .= $_ while (<FP>);
close(FP);
$c =~ s|chmod \+rx pth-config|: $&|s;
$c =~ s|chmod \+rx pthread-config|: $&|s;
$c =~ s|rm -f pthread-config|: $&|s;
$c =~ s|pth-config||sg;
$c =~ s|pthread-config||sg;
$c =~ s|TB=`.+?`|TB=''|s;
$c =~ s|TN=`.+?`|TN=''|s;
$c =~ s|echo \"\$ac_t\"\"\" 1>\&6|: $&|sg;
$c =~ s|echo \"\$ac_t\"\"\$\{TB\}.+?:\$\{TN\}" 1>&6|: $&|sg;
$c =~ s|enable_batch=no|enable_batch=yes|sg;
open(FP, ">$dst/configure");
print FP $c;
close(FP);
system("chmod a+rx $dst/configure");

system("shtoolize -q -o $dst/shtool version scpp");
system("cp $src/striptease.mk $dst/Makefile.in");

system("$src/shtool fixperm $dst");
system("rm -rf $src/* && cp -rp $dst/* $src/");
system("rm -rf $dst");

print "done.\n";

printf("Resulting source tree: %d KB\n", &kbof($src));
system("ls -l $src");

