/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.repository.config.DelegatingRepositoryImplConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.config.RepositoryImplConfig;
import org.openrdf.repository.config.RepositoryImplConfigBase;

public class DelegatingRepositoryImplConfigBase
extends RepositoryImplConfigBase
implements DelegatingRepositoryImplConfig {
    private RepositoryImplConfig delegate;

    public DelegatingRepositoryImplConfigBase() {
    }

    public DelegatingRepositoryImplConfigBase(String type) {
        super(type);
    }

    public DelegatingRepositoryImplConfigBase(String type, RepositoryImplConfig delegate) {
        this(type);
        this.setDelegate(delegate);
    }

    public RepositoryImplConfig getDelegate() {
        return this.delegate;
    }

    public void setDelegate(RepositoryImplConfig delegate) {
        this.delegate = delegate;
    }

    public void validate() throws RepositoryConfigException {
        super.validate();
        if (this.delegate == null) {
            throw new RepositoryConfigException("No delegate specified for " + this.getType() + " repository");
        }
        this.delegate.validate();
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (this.delegate != null) {
            Resource delegateNode = this.delegate.export(graph);
            graph.add(implNode, RepositoryConfigSchema.DELEGATE, delegateNode, new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws RepositoryConfigException {
        super.parse(graph, implNode);
        try {
            Resource delegateNode = GraphUtil.getOptionalObjectResource(graph, implNode, RepositoryConfigSchema.DELEGATE);
            if (delegateNode != null) {
                this.setDelegate(DelegatingRepositoryImplConfigBase.create(graph, delegateNode));
            }
        }
        catch (GraphUtilException e) {
            throw new RepositoryConfigException(e.getMessage(), e);
        }
    }
}

