/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.pilotlink;

import java.util.Date;
import org.gnu.pilotlink.Record;

public class ToDoRecord
extends Record {
    private Date dueDate;
    private byte priority;
    private String description;
    private boolean done;
    private String note;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
        this.setSize(this.getBuffer().length);
    }

    public boolean getDone() {
        return this.done;
    }

    public void setDone(boolean bl) {
        this.done = bl;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        if (n > 255) {
            throw new IllegalArgumentException("Invalid priority");
        }
        this.priority = (byte)n;
    }

    public void setNote(String string) {
        this.note = string;
        this.setSize(this.getBuffer().length);
    }

    public String getNote() {
        return this.note;
    }

    public void setDueDate(Date date) {
        this.dueDate = date;
        this.setSize(this.getBuffer().length);
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public ToDoRecord(Record record) {
        super(record);
    }

    public ToDoRecord() {
    }

    @Override
    public byte[] getBuffer() {
        int n = 3;
        n = this.note != null ? (n += this.note.length() + 1) : ++n;
        n = this.description != null ? (n += this.description.length() + 1) : ++n;
        byte[] byArray = new byte[n];
        System.out.println("Size: " + n);
        if (this.dueDate != null) {
            Record.setDateAt(byArray, this.dueDate, 0);
        } else {
            byArray[0] = -1;
            byArray[1] = -1;
        }
        byArray[2] = this.priority;
        if (this.done) {
            byArray[2] = (byte)(byArray[2] | 0x80);
        }
        int n2 = 3;
        if (this.description != null) {
            n2 = Record.setStringAt(byArray, this.description, n2);
        } else {
            byArray[n2++] = 0;
        }
        if (this.note != null) {
            Record.setStringAt(byArray, this.note, n2);
        } else {
            byArray[n2++] = 0;
        }
        return byArray;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        if (Record.getIntAt(byArray, 0) != 65535) {
            System.out.println("\n\nReading in due-date..." + (byArray[0] & 0xFF) + "  " + (byArray[1] & 0xFF) + " getInt " + Record.getIntAt(byArray, 0) + " " + Record.getDateAt(byArray, 0));
            this.dueDate = Record.getDateAt(byArray, 0);
        }
        this.priority = byArray[2];
        if ((this.priority & 0x80) > 0) {
            this.priority = (byte)(this.priority & 0x7F);
            this.done = true;
        } else {
            this.done = false;
        }
        if (byArray.length <= 3) {
            return;
        }
        int n = 3;
        this.description = Record.getStringAt(byArray, 3);
        if (byArray.length <= 3 + this.description.length()) {
            return;
        }
        this.note = Record.getStringAt(byArray, 3 + this.description.length());
        this.setSize(byArray.length);
    }

    public String toString() {
        return "P" + this.priority + ": " + this.description + " Done: " + this.done + " due to: " + this.dueDate + " note: " + this.note;
    }
}

