/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf.config;

import org.openrdf.model.Graph;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.util.GraphUtilException;
import org.openrdf.sail.config.SailConfigException;
import org.openrdf.sail.config.SailImplConfigBase;
import org.openrdf.sail.nativerdf.config.NativeStoreSchema;

public class NativeStoreConfig
extends SailImplConfigBase {
    private String tripleIndexes;
    private boolean forceSync = false;

    public NativeStoreConfig() {
        super("openrdf:NativeStore");
    }

    public NativeStoreConfig(String tripleIndexes) {
        this();
        this.setTripleIndexes(tripleIndexes);
    }

    public NativeStoreConfig(String tripleIndexes, boolean forceSync) {
        this(tripleIndexes);
        this.setForceSync(forceSync);
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setTripleIndexes(String tripleIndexes) {
        this.tripleIndexes = tripleIndexes;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public Resource export(Graph graph) {
        Resource implNode = super.export(graph);
        if (this.tripleIndexes != null) {
            graph.add(implNode, NativeStoreSchema.TRIPLE_INDEXES, graph.getValueFactory().createLiteral(this.tripleIndexes), new Resource[0]);
        }
        if (this.forceSync) {
            graph.add(implNode, NativeStoreSchema.FORCE_SYNC, graph.getValueFactory().createLiteral(this.forceSync), new Resource[0]);
        }
        return implNode;
    }

    public void parse(Graph graph, Resource implNode) throws SailConfigException {
        block5: {
            super.parse(graph, implNode);
            try {
                Literal forceSyncLit;
                Literal tripleIndexLit = GraphUtil.getOptionalObjectLiteral(graph, implNode, NativeStoreSchema.TRIPLE_INDEXES);
                if (tripleIndexLit != null) {
                    this.setTripleIndexes(tripleIndexLit.getLabel());
                }
                if ((forceSyncLit = GraphUtil.getOptionalObjectLiteral(graph, implNode, NativeStoreSchema.FORCE_SYNC)) == null) break block5;
                try {
                    this.setForceSync(forceSyncLit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + NativeStoreSchema.FORCE_SYNC + " property, found " + forceSyncLit);
                }
            }
            catch (GraphUtilException e) {
                throw new SailConfigException(e.getMessage(), e);
            }
        }
    }
}

