include( variables.pri )

CONFIG += ordered

TEMPLATE=subdirs
SUBDIRS = src examples uitools plugins tests

contains($$list($$[QT_VERSION]), 4.[2-9].*) { SUBDIRS += kdchartserializer }

SUBDIRS +=qtests


VERSION  = 2.2.1


unix:DEFAULT_INSTALL_PREFIX = /usr/local/KDAB/KDChart-$$VERSION
win32:DEFAULT_INSTALL_PREFIX = "C:\KDAB\KDChart"-$$VERSION

isEmpty( PREFIX ) {
    INSTALL_PREFIX=$$DEFAULT_INSTALL_PREFIX
    message( "No install prefix given, using default of" $$DEFAULT_INSTALL_PREFIX (use PREFIX=DIR to specify))
} else {
        INSTALL_PREFIX=$$PREFIX
}
message(Install prefix is $$INSTALL_PREFIX)
message(This is KD Chart version $$VERSION)

# make a newline in case .qmake.cache exists and does not end with one
# (an existing cache file is overriden, this is intended - a user can
# always place custom settings one directory level up)
unix:MESSAGE = '\\'$$LITERAL_HASH' KDAB qmake cache file autogenerated during qmake run'
!unix:MESSAGE = $$LITERAL_HASH' KDAB qmake cache file autogenerated during qmake run'
system('echo $${MESSAGE} > .qmake.cache')
# store PREFIX:
system('echo INSTALL_PREFIX=$$INSTALL_PREFIX >> .qmake.cache')
system('echo VERSION=$$VERSION >> .qmake.cache')


# install licenses:
licenses.files = Licenses
licenses.path = $$INSTALL_PREFIX
INSTALLS += licenses

# readme.files = README.KDReports
# readme.path = $$INSTALL_PREFIX
# INSTALLS += readme


# forward make test calls to qtests:
test.target=test
test.commands=(cd qtests && $(MAKE) test)
test.depends = all $(TARGET)
QMAKE_EXTRA_TARGETS += test
