/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.iteration;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openrdf.sail.SailException;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.exceptions.RdbmsException;
import org.openrdf.sail.rdbms.iteration.base.RdbmIterationBase;
import org.openrdf.sail.rdbms.model.RdbmsResource;
import org.openrdf.sail.rdbms.model.RdbmsStatement;
import org.openrdf.sail.rdbms.model.RdbmsURI;
import org.openrdf.sail.rdbms.model.RdbmsValue;
import org.openrdf.sail.rdbms.schema.IdSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdbmsStatementIteration
extends RdbmIterationBase<RdbmsStatement, SailException> {
    private RdbmsValueFactory vf;
    private IdSequence ids;

    public RdbmsStatementIteration(RdbmsValueFactory vf, PreparedStatement stmt, IdSequence ids) throws SQLException {
        super(stmt);
        this.vf = vf;
        this.ids = ids;
    }

    @Override
    protected RdbmsStatement convert(ResultSet rs) throws SQLException {
        RdbmsResource ctx = this.createResource(rs, 1);
        RdbmsResource subj = this.createResource(rs, 3);
        RdbmsURI pred = (RdbmsURI)this.createResource(rs, 5);
        RdbmsValue obj = this.createValue(rs, 7);
        return new RdbmsStatement(subj, pred, obj, ctx);
    }

    @Override
    protected RdbmsException convertSQLException(SQLException e) {
        return new RdbmsException(e);
    }

    private RdbmsResource createResource(ResultSet rs, int index) throws SQLException {
        Number id = this.ids.idOf(rs.getLong(index));
        if (id.longValue() == 0L) {
            return null;
        }
        String stringValue = rs.getString(index + 1);
        return this.vf.getRdbmsResource(id, stringValue);
    }

    private RdbmsValue createValue(ResultSet rs, int index) throws SQLException {
        Number id = this.ids.idOf(rs.getLong(index));
        if (this.ids.isLiteral(id)) {
            String label = rs.getString(index + 1);
            String datatype = rs.getString(index + 2);
            String language = rs.getString(index + 3);
            return this.vf.getRdbmsLiteral(id, label, language, datatype);
        }
        return this.createResource(rs, index);
    }
}

