/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;

public abstract class URLStreamHandler {
    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected void parseURL(URL url, String spec, int start, int end) {
        int hash;
        String host = url.getHost();
        int port = url.getPort();
        String file = url.getFile();
        String ref = url.getRef();
        if (spec.regionMatches(start, "//", 0, 2)) {
            int colon;
            int slash = spec.indexOf(47, start += 2);
            int hostEnd = slash >= 0 ? slash : end;
            if ((colon = (host = spec.substring(start, hostEnd)).indexOf(58)) >= 0) {
                try {
                    port = Integer.parseInt(host.substring(colon + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                host = host.substring(0, colon);
            }
            file = null;
            start = hostEnd;
        } else if (host == null) {
            host = "";
        }
        if (file == null || file.length() == 0 || start < end && spec.charAt(start) == '/') {
            file = spec.substring(start, end);
            ref = null;
        } else if (start < end) {
            char sepChar = '/';
            int lastSlash = file.lastIndexOf(sepChar);
            if (lastSlash < 0 && File.separatorChar != sepChar && url.getProtocol().equals("file")) {
                sepChar = File.separatorChar;
                lastSlash = file.lastIndexOf(sepChar);
            }
            file = file.substring(0, lastSlash) + sepChar + spec.substring(start, end);
            if (url.getProtocol().equals("file")) {
                try {
                    file = new File(file).getCanonicalPath();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            ref = null;
        }
        if (ref == null && (hash = file.indexOf(35)) != -1) {
            ref = file.substring(hash + 1, file.length());
            file = file.substring(0, hash);
        }
        this.setURL(url, url.getProtocol(), host, port, file, ref);
    }

    private static String canonicalizeFilename(String file) {
        int previous;
        int index;
        while ((index = file.indexOf("/./")) >= 0) {
            file = file.substring(0, index) + file.substring(index + 2);
        }
        while ((index = file.indexOf("/../")) >= 0 && (previous = file.lastIndexOf(47, index - 1)) >= 0) {
            file = file.substring(0, previous) + file.substring(index + 3);
        }
        return file;
    }

    protected boolean sameFile(URL url1, URL url2) {
        String s2;
        if (url1 == url2) {
            return true;
        }
        if (url1 == null || url2 == null || url1.getPort() != url2.getPort()) {
            return false;
        }
        String s1 = url1.getProtocol();
        if (!(s1 == (s2 = url2.getProtocol()) || s1 != null && s1.equals(s2))) {
            return false;
        }
        s1 = url1.getHost();
        if (!(s1 == (s2 = url2.getHost()) || s1 != null && s1.equals(s2))) {
            return false;
        }
        s1 = URLStreamHandler.canonicalizeFilename(url1.getFile());
        return s1 == (s2 = URLStreamHandler.canonicalizeFilename(url2.getFile())) || s1 != null && s1.equals(s2);
    }

    protected void setURL(URL u, String protocol, String host, int port, String file, String ref) {
        u.set(protocol, host, port, file, ref);
    }

    protected void setURL(URL u, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        u.set(protocol, host, port, authority, userInfo, path, query, ref);
    }

    protected boolean equals(URL url1, URL url2) {
        return url1.getPort() == url2.getPort() && (url1.getProtocol() == null && url2.getProtocol() == null || url1.getProtocol() != null && url1.getProtocol().equals(url2.getProtocol())) && (url1.getUserInfo() == null && url2.getUserInfo() == null || url1.getUserInfo() != null && url1.getUserInfo().equals(url2.getUserInfo())) && (url1.getAuthority() == null && url2.getAuthority() == null || url1.getAuthority() != null && url1.getAuthority().equals(url2.getAuthority())) && (url1.getHost() == null && url2.getHost() == null || url1.getHost() != null && url1.getHost().equals(url2.getHost())) && (url1.getPath() == null && url2.getPath() == null || url1.getPath() != null && url1.getPath().equals(url2.getPath())) && (url1.getQuery() == null && url2.getQuery() == null || url1.getQuery() != null && url1.getQuery().equals(url2.getQuery())) && (url1.getRef() == null && url2.getRef() == null || url1.getRef() != null && url1.getRef().equals(url2.getRef()));
    }

    protected boolean hostsEqual(URL url1, URL url2) throws UnknownHostException {
        InetAddress addr1 = InetAddress.getByName(url1.getHost());
        InetAddress addr2 = InetAddress.getByName(url2.getHost());
        return addr1.equals(addr2);
    }

    protected InetAddress getHostAddress(URL url) {
        String hostname = url.getHost();
        if (hostname == "") {
            return null;
        }
        try {
            return InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected int hashCode(URL url) {
        return url.getProtocol().hashCode() + (url.getHost() == null ? 0 : url.getHost().hashCode()) + url.getFile().hashCode() + url.getPort();
    }

    protected String toExternalForm(URL u) {
        boolean port_needed;
        String protocol = u.getProtocol();
        String host = u.getHost();
        if (host == null) {
            host = "";
        }
        int port = u.getPort();
        String file = u.getFile();
        String ref = u.getRef();
        int size = protocol.length() + host.length() + file.length() + 24;
        StringBuffer sb = new StringBuffer(size);
        sb.append(protocol);
        sb.append(':');
        if (host.length() != 0) {
            sb.append("//").append(host);
        }
        boolean bl = port_needed = port > 0 && port != this.getDefaultPort();
        if (port_needed) {
            sb.append(':').append(port);
        }
        sb.append(file);
        if (ref != null) {
            sb.append('#').append(ref);
        }
        return sb.toString();
    }
}

