/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;

public class DatagramSocket {
    static DatagramSocketImplFactory factory;
    DatagramSocketImpl impl;
    DatagramChannel ch;
    private InetAddress remoteAddress;
    private int remotePort;
    private boolean closed;

    private /* synthetic */ void finit$() {
        this.remotePort = -1;
        this.closed = false;
    }

    protected DatagramSocket(DatagramSocketImpl impl) {
        this.finit$();
        this.impl = impl;
        this.remoteAddress = null;
        this.remotePort = -1;
    }

    public DatagramSocket() throws SocketException {
        this(0, null);
    }

    public DatagramSocket(int port) throws SocketException {
        this(port, null);
    }

    public DatagramSocket(int port, InetAddress laddr) throws SocketException {
        String propVal;
        this.finit$();
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(port);
        }
        if ((propVal = System.getProperty("impl.prefix")) == null || propVal.equals("")) {
            this.impl = new PlainDatagramSocketImpl();
        } else {
            try {
                this.impl = (DatagramSocketImpl)Class.forName("java.net." + propVal + "DatagramSocketImpl").newInstance();
            }
            catch (Exception e) {
                System.err.println("Could not instantiate class: java.net." + propVal + "DatagramSocketImpl");
                this.impl = new PlainDatagramSocketImpl();
            }
        }
        this.impl.create();
        if (this instanceof MulticastSocket) {
            this.impl.setOption(4, new Boolean(true));
        }
        this.impl.bind(port, laddr == null ? InetAddress.ANY_IF : laddr);
        this.remoteAddress = null;
        this.remotePort = -1;
    }

    public DatagramSocket(SocketAddress address) throws SocketException {
        this(((InetSocketAddress)address).getPort(), ((InetSocketAddress)address).getAddress());
    }

    public void close() {
        if (!this.closed) {
            this.impl.close();
            this.remoteAddress = null;
            this.remotePort = -1;
            this.closed = true;
        }
    }

    public InetAddress getInetAddress() {
        return this.remoteAddress;
    }

    public int getPort() {
        return this.remotePort;
    }

    public InetAddress getLocalAddress() {
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException ex) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException ex2) {
                return null;
            }
        }
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.impl.getLocalPort();
    }

    public synchronized int getSoTimeout() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        Object timeout = this.impl.getOption(4102);
        if (timeout instanceof Integer) {
            return (Integer)timeout;
        }
        return 0;
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Invalid timeout: " + timeout);
        }
        this.impl.setOption(4102, new Integer(timeout));
    }

    public int getSendBufferSize() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        Object obj = this.impl.getOption(4097);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public void setSendBufferSize(int size) throws SocketException {
        if (size < 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.impl.setOption(4097, new Integer(size));
    }

    public int getReceiveBufferSize() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        Object obj = this.impl.getOption(4098);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Buffer size is less than 0");
        }
        this.impl.setOption(4098, new Integer(size));
    }

    public void connect(InetAddress address, int port) {
        if (address == null) {
            throw new IllegalArgumentException("Connect address may not be null");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port number is illegal: " + port);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(address.getHostName(), port);
        }
        try {
            this.impl.connect(address, port);
            this.remoteAddress = address;
            this.remotePort = port;
        }
        catch (SocketException e) {
            // empty catch block
        }
    }

    public void disconnect() {
        this.impl.disconnect();
        this.remoteAddress = null;
        this.remotePort = -1;
    }

    public synchronized void receive(DatagramPacket p) throws IOException {
        if (this.impl == null) {
            throw new IOException("Cannot initialize Socket implementation");
        }
        if (this.remoteAddress != null && this.remoteAddress.isMulticastAddress()) {
            throw new IOException("Socket connected to a multicast address my not receive");
        }
        if (this.ch != null && !this.ch.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        this.impl.receive(p);
        SecurityManager s = System.getSecurityManager();
        if (s != null && this.isConnected()) {
            s.checkAccept(p.getAddress().getHostName(), p.getPort());
        }
    }

    public void send(DatagramPacket p) throws IOException {
        SecurityManager s = System.getSecurityManager();
        if (s != null && !this.isConnected()) {
            InetAddress addr = p.getAddress();
            if (addr.isMulticastAddress()) {
                s.checkMulticast(addr);
            } else {
                s.checkConnect(addr.getHostAddress(), p.getPort());
            }
        }
        if (this.isConnected() && p.getAddress() != null && (this.remoteAddress != p.getAddress() || this.remotePort != p.getPort())) {
            throw new IllegalArgumentException("DatagramPacket address does not match remote address");
        }
        if (this.ch != null && !this.ch.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        this.impl.send(p);
    }

    public void bind(SocketAddress address) throws SocketException {
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException();
        }
        InetSocketAddress tmp = (InetSocketAddress)address;
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkListen(tmp.getPort());
        }
        this.impl.bind(tmp.getPort(), tmp.getAddress());
    }

    public boolean isClosed() {
        return this.closed;
    }

    public DatagramChannel getChannel() {
        return this.ch;
    }

    public void connect(SocketAddress address) throws SocketException {
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("SocketAddress is not InetSocketAddress");
        }
        InetSocketAddress tmp = (InetSocketAddress)address;
        this.connect(tmp.getAddress(), tmp.getPort());
    }

    public boolean isBound() {
        try {
            Object bindaddr = this.impl.getOption(15);
        }
        catch (SocketException e) {
            return false;
        }
        return true;
    }

    public boolean isConnected() {
        return this.remoteAddress != null;
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.remoteAddress, this.remotePort);
    }

    public SocketAddress getLocalSocketAddress() {
        InetAddress addr;
        try {
            addr = (InetAddress)this.impl.getOption(15);
        }
        catch (SocketException e) {
            return null;
        }
        return new InetSocketAddress(addr, this.impl.localPort);
    }

    public void setReuseAddress(boolean on) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        this.impl.setOption(4, new Boolean(on));
    }

    public boolean getReuseAddress() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        Object obj = this.impl.getOption(4);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public void setBroadcast(boolean on) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        this.impl.setOption(32, new Boolean(on));
    }

    public boolean getBroadcast() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        Object obj = this.impl.getOption(32);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public void setTrafficClass(int tc) throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        if (tc < 0 || tc > 255) {
            throw new IllegalArgumentException();
        }
        this.impl.setOption(3, new Integer(tc));
    }

    public int getTrafficClass() throws SocketException {
        if (this.impl == null) {
            throw new SocketException("Cannot initialize Socket implementation");
        }
        Object obj = this.impl.getOption(3);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new SocketException("Unexpected type");
    }

    public static void setDatagramSocketImplFactory(DatagramSocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("DatagramSocketImplFactory already defined");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSetFactory();
        }
        factory = fac;
    }
}

