/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public final class StringBuffer
implements Serializable,
CharSequence {
    int count;
    char[] value;
    boolean shared;
    static final long serialVersionUID = 3388685877147921107L;
    private static final int DEFAULT_CAPACITY = 16;

    public StringBuffer append(boolean bool) {
        return this.append(String.valueOf(bool));
    }

    public synchronized StringBuffer append(char ch) {
        this.ensureCapacity_unsynchronized(this.count + 1);
        this.value[this.count++] = ch;
        return this;
    }

    public native StringBuffer append(int var1);

    public StringBuffer append(long lnum) {
        return this.append(String.valueOf(lnum));
    }

    public StringBuffer append(float fnum) {
        return this.append(String.valueOf(fnum));
    }

    public StringBuffer append(double dnum) {
        return this.append(String.valueOf(dnum));
    }

    public StringBuffer append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public synchronized StringBuffer append(String str) {
        if (str == null) {
            str = "null";
        }
        int len = str.length();
        this.ensureCapacity_unsynchronized(this.count + len);
        str.getChars(0, len, this.value, this.count);
        this.count += len;
        return this;
    }

    public StringBuffer append(char[] data) {
        return this.append(data, 0, data.length);
    }

    public synchronized StringBuffer append(char[] data, int offset, int count) {
        this.ensureCapacity_unsynchronized(this.count + count);
        System.arraycopy(data, offset, this.value, this.count, count);
        this.count += count;
        return this;
    }

    public int capacity() {
        return this.value.length;
    }

    public synchronized char charAt(int index) {
        if (index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.value[index];
    }

    public synchronized StringBuffer delete(int start, int end) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (end > this.count) {
            end = this.count;
        }
        this.ensureCapacity_unsynchronized(this.count);
        if (this.count - end != 0) {
            System.arraycopy(this.value, end, this.value, start, this.count - end);
        }
        this.count -= end - start;
        return this;
    }

    public StringBuffer deleteCharAt(int index) {
        return this.delete(index, index + 1);
    }

    public synchronized void ensureCapacity(int minimumCapacity) {
        if (this.shared || minimumCapacity > this.value.length) {
            int max = minimumCapacity > this.value.length ? this.value.length * 2 + 2 : this.value.length;
            minimumCapacity = minimumCapacity < max ? max : minimumCapacity;
            char[] nb = new char[minimumCapacity];
            System.arraycopy(this.value, 0, nb, 0, this.count);
            this.value = nb;
            this.shared = false;
        }
    }

    private void ensureCapacity_unsynchronized(int minimumCapacity) {
        if (this.shared || minimumCapacity > this.value.length) {
            int max = minimumCapacity > this.value.length ? this.value.length * 2 + 2 : this.value.length;
            minimumCapacity = minimumCapacity < max ? max : minimumCapacity;
            char[] nb = new char[minimumCapacity];
            System.arraycopy(this.value, 0, nb, 0, this.count);
            this.value = nb;
            this.shared = false;
        }
    }

    public synchronized void getChars(int srcOffset, int srcEnd, char[] dst, int dstOffset) {
        int todo = srcEnd - srcOffset;
        if (srcOffset < 0 || srcEnd > this.count || todo < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, srcOffset, dst, dstOffset, todo);
    }

    public StringBuffer insert(int offset, boolean bool) {
        return this.insert(offset, bool ? "true" : "false");
    }

    public synchronized StringBuffer insert(int offset, char ch) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        this.ensureCapacity_unsynchronized(this.count + 1);
        System.arraycopy(this.value, offset, this.value, offset + 1, this.count - offset);
        this.value[offset] = ch;
        ++this.count;
        return this;
    }

    public StringBuffer insert(int offset, int inum) {
        return this.insert(offset, String.valueOf(inum));
    }

    public StringBuffer insert(int offset, long lnum) {
        return this.insert(offset, String.valueOf(lnum));
    }

    public StringBuffer insert(int offset, float fnum) {
        return this.insert(offset, String.valueOf(fnum));
    }

    public StringBuffer insert(int offset, double dnum) {
        return this.insert(offset, String.valueOf(dnum));
    }

    public StringBuffer insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public synchronized StringBuffer insert(int offset, String str) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (str == null) {
            str = "null";
        }
        int len = str.length();
        this.ensureCapacity_unsynchronized(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        str.getChars(0, len, this.value, offset);
        this.count += len;
        return this;
    }

    public StringBuffer insert(int offset, char[] data) {
        return this.insert(offset, data, 0, data == null ? 0 : data.length);
    }

    public synchronized StringBuffer insert(int offset, char[] str, int str_offset, int len) {
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        if (str_offset < 0 || str_offset + len > str.length) {
            throw new StringIndexOutOfBoundsException(str_offset);
        }
        this.ensureCapacity_unsynchronized(this.count + len);
        System.arraycopy(this.value, offset, this.value, offset + len, this.count - offset);
        System.arraycopy(str, str_offset, this.value, offset, len);
        this.count += len;
        return this;
    }

    public int length() {
        return this.count;
    }

    public synchronized StringBuffer replace(int start, int end, String str) {
        if (start < 0 || start > this.count || start > end) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int len = str.length();
        int delta = len - ((end > this.count ? this.count : end) - start);
        this.ensureCapacity_unsynchronized(this.count + delta);
        if (delta != 0 && end < this.count) {
            System.arraycopy(this.value, end, this.value, end + delta, this.count - end);
        }
        str.getChars(0, len, this.value, start);
        this.count += delta;
        return this;
    }

    public synchronized StringBuffer reverse() {
        this.ensureCapacity_unsynchronized(this.count);
        for (int i = 0; i < this.count / 2; ++i) {
            char c = this.value[i];
            this.value[i] = this.value[this.count - i - 1];
            this.value[this.count - i - 1] = c;
        }
        return this;
    }

    public synchronized void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.count) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.ensureCapacity_unsynchronized(this.count);
        this.value[index] = ch;
    }

    public synchronized void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.ensureCapacity_unsynchronized(newLength);
        for (int i = this.count; i < newLength; ++i) {
            this.value[i] = '\u0000';
        }
        this.count = newLength;
    }

    public StringBuffer() {
        this(16);
    }

    public StringBuffer(int capacity) {
        this.count = 0;
        this.value = new char[capacity];
        this.shared = false;
    }

    public StringBuffer(String str) {
        this.count = str.length();
        this.value = new char[this.count + 16];
        str.getChars(0, this.count, this.value, 0);
        this.shared = false;
    }

    public String substring(int beginIndex) {
        return this.substring(beginIndex, this.count);
    }

    public synchronized String substring(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.count || beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.value, beginIndex, endIndex - beginIndex);
    }

    public CharSequence subSequence(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex);
    }

    public String toString() {
        return new String(this);
    }
}

