/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.j2d;

import gnu.awt.j2d.AbstractGraphicsState;
import gnu.awt.j2d.DirectRasterGraphics;
import gnu.awt.j2d.MappedRaster;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.WritableRaster;

public class IntegerGraphicsState
extends AbstractGraphicsState {
    int tx;
    int ty;
    DirectRasterGraphics directGfx;
    Shape clip;

    public IntegerGraphicsState(DirectRasterGraphics directGfx) {
        this.directGfx = directGfx;
    }

    public Object clone() {
        IntegerGraphicsState clone = (IntegerGraphicsState)super.clone();
        clone.directGfx = (DirectRasterGraphics)this.directGfx.clone();
        return clone;
    }

    public void dispose() {
        DirectRasterGraphics lDeviceGfx = this.directGfx;
        this.directGfx = null;
        if (lDeviceGfx != null) {
            lDeviceGfx.dispose();
        }
        super.dispose();
    }

    public void setColor(Color color) {
        this.directGfx.setColor(color);
    }

    public void setPaintMode() {
        this.directGfx.setPaintMode();
    }

    public void setXORMode(Color altColor) {
        this.directGfx.setXORMode(altColor);
    }

    public void setFont(Font font) {
        this.directGfx.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.directGfx.getFontMetrics(font);
    }

    public void setClip(Shape clip) {
        if (clip instanceof Rectangle) {
            Rectangle clipRect = (Rectangle)((Rectangle)clip).clone();
            clipRect.x += this.tx;
            clipRect.y += this.ty;
            this.clip = clipRect;
            this.directGfx.setClip(clipRect);
            return;
        }
        String msg = "translating clip shape " + clip + " into device " + "coordinate space has not been implemented yet";
        throw new UnsupportedOperationException(msg);
    }

    /*
     * WARNING - void declaration
     */
    public Shape getClip() {
        if (this.clip instanceof Rectangle) {
            void msg;
            Rectangle clipRect = (Rectangle)this.clip;
            clipRect.x -= this.tx;
            clipRect.y -= this.ty;
            return msg;
        }
        String msg = "translating clip shape " + this.clip + " into user " + "coordinate space has not been implemented yet";
        throw new UnsupportedOperationException(msg);
    }

    public Rectangle getClipBounds() {
        Rectangle clipRect = this.clip.getBounds();
        clipRect.x -= this.tx;
        clipRect.y -= this.ty;
        return clipRect;
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.directGfx.copyArea(x + this.tx, y + this.ty, width, height, dx, dy);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.directGfx.drawLine(x1 + this.tx, y1 + this.ty, x2 + this.tx, y2 + this.ty);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.directGfx.fillRect(x + this.tx, y + this.ty, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.directGfx.setColor(this.frontend.getBackground());
        this.directGfx.fillRect(x + this.tx, y + this.ty, width, height);
        this.directGfx.setColor(this.frontend.getColor());
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawOval(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void fillOval(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.directGfx.drawArc(x + this.tx, y + this.ty, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.directGfx.fillArc(x + this.tx, y + this.ty, width, height, startAngle, arcAngle);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.tx == 0 && this.ty == 0) {
            this.directGfx.drawPolyline(xPoints, yPoints, nPoints);
            return;
        }
        throw new UnsupportedOperationException("translate not implemented");
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        if (this.tx == 0 && this.ty == 0) {
            this.directGfx.drawPolygon(xPoints, yPoints, nPoints);
            return;
        }
        throw new UnsupportedOperationException("translate not implemented");
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.directGfx.fillPolygon(xPoints, yPoints, nPoints, this.tx, this.ty);
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        x += this.tx;
        y += this.ty;
        if (image instanceof BufferedImage) {
            BufferedImage bImage = (BufferedImage)image;
            Object config = bImage.getProperty("java.awt.GraphicsConfiguration");
            if (config == this.frontend.config) {
                return this.directGfx.drawImage(image, x, y, observer);
            }
            int width = image.getWidth(null);
            int height = image.getHeight(null);
            Rectangle bounds = new Rectangle(x, y, width, height);
            MappedRaster mr = this.directGfx.mapRaster(bounds);
            ColorModel colorModel = mr.getColorModel();
            WritableRaster raster = mr.getRaster();
            int xEnd = x + width;
            int yEnd = y + height;
            Object rgbElem = null;
            for (int yy = 0; yy < height; ++yy) {
                for (int xx = 0; xx < width; ++xx) {
                    int srgb = bImage.getRGB(xx, yy);
                    int sa = (srgb >>> 24 & 0xFF) + 1;
                    int sr = (srgb >>> 16 & 0xFF) + 1;
                    int sg = (srgb >>> 8 & 0xFF) + 1;
                    int sb = (srgb & 0xFF) + 1;
                    rgbElem = raster.getDataElements(xx + x, yy + y, rgbElem);
                    int drgb = colorModel.getRGB(rgbElem);
                    int dr = (drgb >>> 16 & 0xFF) + 1;
                    int dg = (drgb >>> 8 & 0xFF) + 1;
                    int db = (drgb & 0xFF) + 1;
                    int da = 256 - sa;
                    dr = (sr * sa + dr * da >>> 8) - 1;
                    dg = (sg * sa + dg * da >>> 8) - 1;
                    db = (sb * sa + db * da >>> 8) - 1;
                    drgb = dr << 16 | dg << 8 | db;
                    rgbElem = colorModel.getDataElements(drgb, rgbElem);
                    raster.setDataElements(xx + x, yy + y, rgbElem);
                }
            }
            this.directGfx.unmapRaster(mr);
            return true;
        }
        throw new UnsupportedOperationException("drawing image " + image + "not implemented");
    }

    public void draw(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rect = (Rectangle)shape;
            this.directGfx.drawRect(rect.x + this.tx, rect.y + this.ty, rect.width, rect.height);
            return;
        }
        throw new UnsupportedOperationException("shape not implemented");
    }

    public void fill(Shape shape) {
        if (shape instanceof Rectangle) {
            Rectangle rect = (Rectangle)shape;
            this.directGfx.fillRect(rect.x + this.tx, rect.y + this.ty, rect.width, rect.height);
            return;
        }
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean hit(Rectangle rect, Shape text, boolean onStroke) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void drawString(String text, int x, int y) {
        this.directGfx.drawString(text, x + this.tx, y + this.ty);
    }

    public void drawString(String text, float x, float y) {
        this.drawString(text, (int)x, (int)y);
    }

    public void translate(int x, int y) {
        this.tx += x;
        this.ty += y;
    }

    public void translate(double tx, double ty) {
        if (tx == 0.0 && ty == 0.0) {
            return;
        }
        this.needAffineTransform();
    }

    public void rotate(double theta) {
        if (theta == 0.0) {
            return;
        }
        this.needAffineTransform();
    }

    public void rotate(double theta, double x, double y) {
        if (theta == 0.0) {
            return;
        }
        this.needAffineTransform();
    }

    public void scale(double scaleX, double scaleY) {
        if (scaleX == 1.0 && scaleY == 1.0) {
            return;
        }
        this.needAffineTransform();
    }

    public void shear(double shearX, double shearY) {
        if (shearX == 0.0 && shearY == 0.0) {
            return;
        }
        this.needAffineTransform();
    }

    private void needAffineTransform() {
        throw new UnsupportedOperationException("state with affine transform not implemented");
    }
}

