//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#ifndef PMSETTINGSDIALOG_H
#define PMSETTINGSDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

class QFrame;
class QCheckBox;
class QLineEdit;
class QListBox;
class QListView;
class QButtonGroup;
class QComboBox;
class KColorButton;
class KConfig;
class PMIntEdit;
class PMFloatEdit;
class PMPart;
class PMViewLayout;
class PMViewLayoutEntry;

/** Configuration dialog */
class PMSettingsDialog : public KDialogBase
{
   Q_OBJECT
public:
   /** Standard constructor */
   PMSettingsDialog( PMPart* part, QWidget* parent = 0, const char* name = 0 );

   static void saveConfig( KConfig* cfg );
   static void restoreConfig( KConfig* cfg );

protected:
   virtual void resizeEvent( QResizeEvent* ev );

protected slots:
   virtual void slotApply( );
   virtual void slotOk( );
   virtual void slotDefault( );
   virtual void slotCancel( );

   /** Called when the add button is clicked */
   void slotAddPath( );
   /** Called when the remove button is clicked */
   void slotRemovePath( );
   /** Called when the up button is clicked */
   void slotPathUp( );
   /** Called when the down button is clicked */
   void slotPathDown( );
   /** Called when the edit button is clicked */
   void slotEditPath( );
   /** Called when a path is selected in the list view */
   void slotPathSelected( int index );
   /** Called when the browse button for the povray command is clicked */
   void slotBrowsePovrayCommand( );
   /** Called when the browse button for the povray documentation is clicked */
   void slotBrowsePovrayDocumentation( );
   
   /** Called when the browse add layout button is clicked */
   void slotAddLayout( );
   /** Called when the remove layout button is clicked */
   void slotRemoveLayout( );
   /** Called when the selected layout changes */
   void slotLayoutSelected( int i );
   /** Called when the layout name changes */
   void slotLayoutNameChanged( const QString& text );
   /** Called when the selected view entry changes */
   void slotViewEntrySelected( QListViewItem* text );
   /** Called when the view type field changes value */
   void slotViewTypeChanged( int index );
   /** Called when the gl view type field changes value */
   void slotGLViewTypeChanged( int index );
   /** Called when the dock position field changes value */
   void slotDockPositionChanged( int index );
   /** Called when the view height field changes value */
   void slotViewHeightChanged( const QString& text );
   /** Called when the column width field changes value */
   void slotColumnWidthChanged( const QString& text );
   /** Called when the floating height changes value */
   void slotFloatingHeightChanged( const QString& text );
   /** Called when the floating width changes value */
   void slotFloatingWidthChanged( const QString& text );
   /** Called when the floating position x changes value */
   void slotFloatingPosXChanged( const QString& text );
   /** Called when the floating position y changes value */
   void slotFloatingPosYChanged( const QString& text );
   /** Called when the add view entry button is clicked */
   void slotAddViewEntryClicked( );
   /** Called when the remove view entry button is clicked */
   void slotRemoveViewEntryClicked( );
   /** Called when the move up view entry button is clicked */
   void slotMoveUpViewEntryClicked( );
   /** Called when the move down view entry button is clicked */
   void slotMoveDownViewEntryClicked( );

private:
   /** Displays the current settings */
   void displaySettings( );
   /** Validates the input fields */
   bool validateData( );
   /** Saves the settings */
   void saveSettings( );
   void displayLayoutList( );
   
   QFrame* m_pViewColors;
   int m_viewColorsIndex;
   KColorButton* m_pBackgroundColor;
   KColorButton* m_pGraphicalObjectsColor[2];
   KColorButton* m_pControlPointsColor[2];
   KColorButton* m_pAxesColor[3];
   KColorButton* m_pFieldOfViewColor;
   
   QFrame* m_pViewGrid;
   int m_viewGridIndex;
   PMIntEdit* m_pGridDistance;
   KColorButton* m_pGridColor;
   PMFloatEdit* m_pMoveGrid;
   PMFloatEdit* m_pScaleGrid;
   PMFloatEdit* m_pRotateGrid;

   QFrame* m_pViewDetails;
   int m_viewDetailsIndex;
   PMIntEdit* m_pSphereUSteps;
   PMIntEdit* m_pSphereVSteps;
   PMIntEdit* m_pCylinderSteps;
   PMIntEdit* m_pConeSteps;
   PMIntEdit* m_pTorusUSteps;
   PMIntEdit* m_pTorusVSteps;
   PMFloatEdit* m_pPlaneSize;
   PMIntEdit* m_pDiscSteps;
   PMIntEdit* m_pBlobSphereUSteps;
   PMIntEdit* m_pBlobSphereVSteps;
   PMIntEdit* m_pBlobCylinderUSteps;
   PMIntEdit* m_pBlobCylinderVSteps;
   PMIntEdit* m_pLatheUSteps;
   PMIntEdit* m_pLatheRSteps;
   PMIntEdit* m_pSorUSteps;
   PMIntEdit* m_pSorRSteps;
   PMIntEdit* m_pPrismSteps;
   PMIntEdit* m_pSqeUSteps;
   PMIntEdit* m_pSqeVSteps;
   QCheckBox* m_pHighDetailCameraViews;

   QFrame* m_pTexturePreview;
   int m_texturePreviewIndex;
   PMIntEdit* m_pPreviewSize;
   QCheckBox* m_pPreviewSphere;
   QCheckBox* m_pPreviewCylinder;
   QCheckBox* m_pPreviewBox;
   QCheckBox* m_pPreviewAA;
   PMIntEdit* m_pPreviewAALevel;
   PMFloatEdit* m_pPreviewAAThreshold;
   QCheckBox* m_pPreviewWall;
   QCheckBox* m_pPreviewFloor;
   KColorButton* m_pFloorColor1;
   KColorButton* m_pFloorColor2;
   KColorButton* m_pWallColor1;
   KColorButton* m_pWallColor2;
   PMFloatEdit* m_pPreviewGamma;

   QFrame* m_pPovrayOptions;
   int m_povrayIndex;
   QLineEdit* m_pPovrayCommand;
   QPushButton* m_pBrowsePovrayCommand;
   QLineEdit* m_pDocumentationPath;
   QPushButton* m_pBrowseDocumentationPath;
   QComboBox* m_pDocumentationVersion;
   QListBox* m_pLibraryPaths;
   QPushButton* m_pAddLibraryPath;
   QPushButton* m_pRemoveLibraryPath;
   QPushButton* m_pChangeLibraryPath;
   QPushButton* m_pLibraryPathUp;
   QPushButton* m_pLibraryPathDown;

   QFrame* m_pLayoutOptions;
   int m_layoutIndex;
   QComboBox* m_pDefaultLayout;
   QListBox* m_pViewLayouts;
   QPushButton* m_pAddLayout;
   QPushButton* m_pRemoveLayout;
   QLineEdit* m_pViewLayoutName;
   QListView* m_pViewEntries;
   QPushButton* m_pAddEntry;
   QPushButton* m_pRemoveEntry;
   QPushButton* m_pMoveUpEntry;
   QPushButton* m_pMoveDownEntry;
   QComboBox* m_pViewTypeEdit;
   QLabel* m_pGLViewTypeLabel;
   QComboBox* m_pGLViewTypeEdit;
   QComboBox* m_pDockPositionEdit;
   PMIntEdit* m_pColumnWidthEdit;
   QLabel* m_pColumnWidthLabel;
   PMIntEdit* m_pViewHeightEdit;
   QLabel* m_pViewHeightLabel;
   
   PMIntEdit* m_pFloatingHeight;
   PMIntEdit* m_pFloatingWidth;
   QLabel* m_pFloatingHeightLabel;
   QLabel* m_pFloatingWidthLabel;
   PMIntEdit* m_pFloatingPosX;
   PMIntEdit* m_pFloatingPosY;
   QLabel* m_pFloatingPosXLabel;
   QLabel* m_pFloatingPosYLabel;
   
   QValueList<PMViewLayout> m_viewLayouts;
   QValueListIterator<PMViewLayout> m_currentViewLayout;
   QValueListIterator<PMViewLayout> m_defaultViewLayout;
   QValueListIterator<PMViewLayoutEntry> m_currentViewEntry;

   int m_selectionIndex;
   PMPart* m_pPart;
   
   static QSize s_size;
};

#endif
