/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmpigment.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"
#include "pmpigmentedit.h"

#include <kdebug.h>
#include "pmglobals.h"
#include <klocale.h>

bool PMPigment::s_linkPossibilitiesCreated = false;
QValueList<PMDeclare::PMDeclareType> PMPigment::s_linkPossibilities;

PMPigment::PMPigment( )
      : Base( )
{
}

PMPigment::~PMPigment( )
{
}

bool PMPigment::isA( PMObjectType t ) const
{
   if( t == PMTPigment )
      return true;
   return Base::isA( t );
}

QString PMPigment::description( ) const
{
   return i18n( "pigment" );
}


void PMPigment::serialize( PMOutputDevice& dev ) const
{
   bool object = true;
   if( parent( ) )
      if( parent( )->type( ) == PMTPigmentMap )
         object = false;
   
   if( object )
      dev.objectBegin( "pigment" );
   Base::serialize( dev );
   if( object )
      dev.objectEnd( );
}


void PMPigment::countChild( PMObjectType t,
                            int& color, int& listpattern, int& pattern,
                            int& map, int& warp, int& blend,
                            int& summap, int& sum,
                            bool& afterPattern, bool& afterMap,
                            bool& afterWarp, bool& afterBlend,
                            bool& afterTransform, 
                            bool afterInsertPoint ) const
{
   switch( t )
   {
      case PMTSolidColor:
      case PMTImageMap:
         color++;
         break;
      case PMTColorList:
      case PMTPigmentList:
         listpattern++;
         break;
      case PMTPattern:
         if( !afterInsertPoint )
            afterPattern = true;
         pattern++;
         break;
      case PMTWarp:
         if( !afterInsertPoint )
            afterWarp = true;
         warp++;
         break;
      case PMTBlendMapModifiers:
         if( !afterInsertPoint )
            afterBlend = true;
         blend++;
         break;
      case PMTColorMap:
      case PMTPigmentMap:
         if( !afterInsertPoint )
            afterMap = true;
         map++;
         break;
      case PMTScale:
      case PMTRotate:
      case PMTTranslate:
      case PMTMatrix:
         if( !afterInsertPoint )
            afterTransform = true;
         break;
      default:
         break;
   }
   summap = pattern + map + warp;
   sum = summap + color + listpattern;
}

bool PMPigment::canInsert( PMObjectType t,
                           int color, int listpattern, int pattern,
                           int map, int /*warp*/, int blend,
                           int /*sumap*/, int sum,
                           bool afterPattern, bool afterMap,
                           bool afterWarp, bool afterBlend,
                           bool afterTransform ) const
{
   switch( t )
   {
      case PMTSolidColor:
      case PMTImageMap:
      case PMTColorList:
      case PMTPigmentList:
         if( sum == 0 )
            return true;
         break;
      case PMTPattern:
         if( ( ( color + pattern + listpattern ) == 0 )
             && !afterMap && !afterWarp && !afterBlend
             && !afterTransform )
            return true;
         break;
      case PMTWarp:
         if( pattern && afterPattern )
            return true;
         break;
      case PMTColorMap:
      case PMTPigmentMap:
         if( ( ( map + listpattern + color ) == 0 )
             && ( !pattern || afterPattern ) )
            return true;
         break;
      case PMTBlendMapModifiers:
         if( !blend && !color && ( !map || afterMap ) 
             && ( !pattern || afterPattern ) )
            return true;
         break;
      case PMTQuickColor:
      case PMTScale:
      case PMTRotate:
      case PMTTranslate:
      case PMTMatrix:
         if( !pattern || afterPattern )
            return true;
      case PMTComment:
      case PMTRaw:
         return true;
      default:
         break;
   }
   return false;
}

bool PMPigment::canInsert( PMObjectType t, const PMObject* after,
                           const PMObjectList* objectsBetween ) const
{
   int color = 0, listpattern = 0, pattern = 0, map = 0, warp = 0;
   int summap = 0, sum = 0, blend = 0;
   bool afterPattern = false, afterMap = false, afterWarp = false;
   bool afterBlend = false, afterTransform = false;
   bool afterInsertPoint = false;
   PMObject* o;
   
   // count child objects
   if( !after )
      afterInsertPoint = true;
   for( o = firstChild( ); o; o = o->nextSibling( ) )
   {
      countChild( o->type( ), color, listpattern, pattern, map,
                  warp, blend, summap, sum, afterPattern, afterMap,
                  afterWarp, afterBlend, afterTransform, afterInsertPoint );
      if( o == after )
         afterInsertPoint = true;
   }
   if( objectsBetween )
   {
      PMObjectListIterator it( *objectsBetween );
      for( ; it.current( ); ++it )
         countChild( it.current( )->type( ), color, listpattern,
                     pattern, map, warp, blend, summap, sum, afterPattern,
                     afterMap, afterWarp, afterBlend, afterTransform, false );
   }
   
   return canInsert( t, color, listpattern, pattern, map, warp, blend, 
                     summap, sum, afterPattern, afterMap,
                     afterWarp, afterBlend, afterTransform );
}

int PMPigment::canInsert( const QValueList<PMObjectType>& list,
                          const PMObject* after ) const
{
   int color = 0, listpattern = 0, pattern = 0, map = 0, warp = 0;
   int summap = 0, sum = 0, blend = 0;
   bool afterPattern = false, afterMap = false, afterWarp = false;
   bool afterBlend = false, afterTransform = false;
   bool afterInsertPoint = false;

   QValueList<PMObjectType>::ConstIterator it;
   PMObject* o = firstChild( );
   PMObjectType t;
   int numInserts = 0;

   // count child objects
   if( !after )
      afterInsertPoint = true;
   for( o = firstChild( ); o; o = o->nextSibling( ) )
   {
      countChild( o->type( ), color, listpattern, pattern, map,
                  warp, summap, sum, blend, afterPattern, afterMap,
                  afterWarp, afterBlend, afterTransform, afterInsertPoint );
      if( o == after )
         afterInsertPoint = true;
   }

   for( it = list.begin( ); it != list.end( ); ++it )
   {
      t = *it;
      if( canInsert( t, color, listpattern, pattern, map, warp, blend, 
                     summap, sum, afterPattern, afterMap, afterWarp, 
                     afterBlend, afterTransform ) )
         numInserts++;
      
      countChild( t, color, listpattern, pattern, map,
                  warp, blend, summap, sum, afterPattern, afterMap,
                  afterWarp, afterBlend, afterTransform, false );
   }
   
   return numInserts;
}

int PMPigment::canInsert( const PMObjectList& list,
                          const PMObject* after ) const
{
   int color = 0, listpattern = 0, pattern = 0, map = 0, warp = 0;
   int summap = 0, sum = 0, blend = 0;
   bool afterPattern = false, afterMap = false, afterWarp = false;
   bool afterBlend = false, afterTransform = false;
   bool afterInsertPoint = false;
   PMObjectListIterator it( list );
   PMObject* o;
   PMObjectType t;
   int numInserts = 0;
   
   // count child objects
   if( !after )
      afterInsertPoint = true;
   for( o = firstChild( ); o; o = o->nextSibling( ) )
   {
      countChild( o->type( ), color, listpattern, pattern, map,
                  warp, blend, summap, sum, afterPattern, afterMap,
                  afterWarp, afterBlend, afterTransform, afterInsertPoint );
      if( o == after )
         afterInsertPoint = true;
   }
   
   for( ; it.current( ); ++it )
   {
      t = it.current( )->type( );
      if( canInsert( t, color, listpattern, pattern, map, warp, blend,
                     summap, sum, afterPattern, afterMap, afterWarp, 
                     afterBlend, afterTransform ) )
         numInserts++;
      
      countChild( t, color, listpattern, pattern, map,
                  warp, blend, summap, sum, afterPattern, afterMap,
                  afterWarp, afterBlend, afterTransform, false );
   }
   
   return numInserts;
}


QValueList<PMDeclare::PMDeclareType> PMPigment::linkPossibilities( ) const
{
   if( !s_linkPossibilitiesCreated )
   {
      s_linkPossibilities.append( PMDeclare::PigmentDeclare );
      s_linkPossibilitiesCreated = true;
   }
   return s_linkPossibilities;
}

PMDialogEditBase* PMPigment::editWidget( QWidget* parent ) const
{
   return new PMPigmentEdit( parent );
}

