/***************************************************************************
                            QFileDialog.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QFILEDIALOG_H
#define QFILEDIALOG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QDialog.h>
#include <qtobjc/QDir.h>
#include <qtobjc/QFilePreview.h>
#include <qtobjc/QUrl.h>
#include <qtobjc/QUrlOperator.h>
#include <qtobjc/QFileIconProvider.h>
#include <qtobjc/QLabel.h>
#include <qtobjc/QButton.h>
#include <qtobjc/QPushButton.h>

@class QContextMenuEvent; 
@class QIMEvent; 
@class QTabletEvent; 

@interface QFileDialog : QDialog 
- initWithText: (NSString *)dirName filter: (NSString *)filter parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
- initWithText: (NSString *)dirName ;
- initWithWidget: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
- init;
- (void) dealloc;
- (NSString *) selectedFile;
- (NSString *) selectedFilter;
- setSelectedFilterFromString: (NSString *)arg1;
- setSelectedFilter: (int)arg1;
- setSelection: (NSString *)arg1;
- selectAll: (BOOL)b;
- (NSArray *) selectedFiles;
- (NSString *) dirPath;
- setDir: (QDir *)arg1;
- (QDir*) dir;
- setShowHiddenFiles: (BOOL)s;
- (BOOL) showHiddenFiles;
- rereadDir;
- resortDir;
- setMode: (int)arg1;
- (int) mode;
- setViewMode: (int)m;
- (int) viewMode;
- setPreviewMode: (int)m;
- (int) previewMode;
- (BOOL) eventFilter: (QObject *)arg1 event: (QEvent *)arg2;
- (BOOL) isInfoPreviewEnabled;
- (BOOL) isContentsPreviewEnabled;
- setInfoPreviewEnabled: (BOOL)arg1;
- setContentsPreviewEnabled: (BOOL)arg1;
- setInfoPreview: (QWidget *)w preview: (QFilePreview*)preview;
- setContentsPreview: (QWidget *)w preview: (QFilePreview*)preview;
- (QUrl*) url;
- addFilter: (NSString *)filter;
- done: (int)arg1;
- setDirWithName: (NSString *)arg1;
- setUrl: (QUrlOperator*)url;
- setFilterFromString: (NSString *)arg1;
- setFiltersFromString: (NSString *)arg1;
//- setFilters: (NSString *)arg1;
- setFiltersList: (NSArray *)arg1;
+ (NSString *) getOpenFileName: (NSString *)initially filter: (NSString *)filter parent: (QWidget *)parent name: (NSString *)name caption: (NSString *)caption selectedFilter: (NSString *)selectedFilter resolveSymlinks: (BOOL)resolveSymlinks;
+ (NSString *) getOpenFileName: (NSString *)initially filter: (NSString *)filter parent: (QWidget *)parent name: (NSString *)name;
+ (NSString *) getSaveFileName: (NSString *)initially filter: (NSString *)filter parent: (QWidget *)parent name: (NSString *)name caption: (NSString *)caption selectedFilter: (NSString *)selectedFilter resolveSymlinks: (BOOL)resolveSymlinks;
+ (NSString *) getSaveFileName: (NSString *)initially filter: (NSString *)filter parent: (QWidget *)parent name: (NSString *)name;
+ (NSString *) getExistingDirectory: (NSString *)dir parent: (QWidget *)parent name: (NSString *)name caption: (NSString *)caption dirOnly: (BOOL)dirOnly resolveSymlinks: (BOOL)resolveSymlinks;
+ (NSArray *) getOpenFileNames: (NSString *)filter dir: (NSString *)dir parent: (QWidget *)parent name: (NSString *)name caption: (NSString *)caption selectedFilter: (NSString *)selectedFilter resolveSymlinks: (BOOL)resolveSymlinks;
+ setIconProvider: (QFileIconProvider*)arg1;
+ (QFileIconProvider*) iconProvider;
- addWidgets: (QLabel *)arg1 widget: (QWidget *)arg2 pushbutton: (QPushButton*)arg3;
- addToolButton: (QButton *)b separator: (BOOL)separator;
- addToolButton: (QButton *)b ;
- addLeftWidget: (QWidget *)w;
- addRightWidget: (QWidget *)w;
+ (int) AnyFile;
+ (int) ExistingFile;
+ (int) Directory;
+ (int) ExistingFiles;
+ (int) DirectoryOnly;
+ (int) Detail;
+ (int) List;
+ (int) NoPreview;
+ (int) Contents;
+ (int) Info;
@end

/** Override these methods in subclasses of QFileDialog to customise event handling behaviour */
@protocol QFileDialogEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
