/***************************************************************************
* $Id: MenuExample.java,v 1.2 2002/03/10 16:08:02 rdale Exp $
**
* Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.kde.qt.*;

class MenuExample  extends QWidget
{

private    QMenuBar menu;
private    QLabel   label;
private    boolean isBold;
private    boolean isUnderline;
private    int boldID, underlineID;



/* XPM */
static String  p1_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFF0000",
"                ",
"                ",
"         ....   ",
"        .XXXX.  ",
" .............. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .............. ",
"                "};

/* XPM */
static String  p2_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"   ......       ",
"   .XXX.X.      ",
"   .XXX.XX.     ",
"   .XXX.XXX.    ",
"   .XXX.....    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .........    ",
"                ",
"                "};

/* XPM */
static String  p3_xpm[] = {
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"                ",
"   .........    ",
"  ...........   ",
"  ........ ..   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"   .........    ",
"                ",
"                "};


/*
  Auxiliary class to provide fancy menu items with different
  fonts. Used for the "bold" and "underline" menu items in the options
  menu.
 */
/**
class MyMenuItem  extends QCustomMenuItem
{
private    String string;
private    QFont font;

    public    MyMenuItem( String s, QFont f )
    {
	    font = f;
    	string = s;
	}

    public void paint( QPainter p, QColorGroup cg, boolean act, boolean enabled, int x, int y, int w, int h )
    {
	p.setFont ( font );
	p.drawText( x, y, w, h, AlignLeft | AlignVCenter | ShowPrefix | DontClip, string );
    }

    public QSize sizeHint()
    {
	return new QFontMetrics( font ).size( AlignLeft | AlignVCenter | ShowPrefix | DontClip,  string );
    }
}
*/

MenuExample( )
{
	this(null, null);
}

MenuExample( QWidget parent, String name )
{
    super( parent, name );
    QPixmap p1 = new QPixmap( p1_xpm );
    QPixmap p2 = new QPixmap( p2_xpm );
    QPixmap p3 = new QPixmap( p3_xpm );

    QPopupMenu print = new QPopupMenu( this );
    print.insertTearOffHandle();
    print.insertItem( "&Print to printer", this, SLOT("printer()") );
    print.insertItem( "Print to &file", this, SLOT("file()") );
    print.insertItem( "Print to fa&x", this, SLOT("fax()") );
    print.insertSeparator();
    print.insertItem( "Printer &Setup", this, SLOT("printerSetup()") );

    QPopupMenu file = new QPopupMenu( this );
    file.insertItem( new QIconSet(p1), "&Open",  this, SLOT("open()"), new QKeySequence(CTRL+Key_O) );
    file.insertItem( new QIconSet(p2), "&New", this, SLOT("news()"), new QKeySequence(CTRL+Key_N) );
    file.insertItem( new QIconSet(p3), "&Save", this, SLOT("save()"), new QKeySequence(CTRL+Key_S) );
    file.insertItem( "&Close", this, SLOT("closeDoc()"), new QKeySequence(CTRL+Key_W) );
    file.insertSeparator();
    file.insertItem( "&Print", print, CTRL+Key_P );
    file.insertSeparator();
    file.insertItem( "E&xit",  qApp(), SLOT("quit()"), new QKeySequence(CTRL+Key_Q) );

    QPopupMenu edit = new QPopupMenu( this );
    int undoID = edit.insertItem( "&Undo", this, SLOT("undo()") );
    int redoID = edit.insertItem( "&Redo", this, SLOT("redo()") );
    edit.setItemEnabled( undoID, false );
    edit.setItemEnabled( redoID, false );

    QPopupMenu options = new QPopupMenu( this );
    options.insertTearOffHandle();
    options.setCaption("Options");
    options.insertItem( "&Normal Font", this, SLOT("normal()") );
    options.insertSeparator();

    options.polish(); // adjust system settings
    QFont f = options.font();
    f.setBold( true );
//    boldID = options.insertItem( new MyMenuItem( "&Bold", f ) );
    options.setAccel( new QKeySequence(CTRL+Key_B), boldID );
    options.connectItem( boldID, this, SLOT("bold()") );
    f = font();
    f.setUnderline( true );
//    underlineID = options.insertItem( new MyMenuItem( "&Underline", f ) );
    options.setAccel( new QKeySequence(CTRL+Key_U), underlineID );
    options.connectItem( underlineID, this, SLOT("underline()") );

    isBold = false;
    isUnderline = false;
    options.setCheckable( true );


    QPopupMenu help = new QPopupMenu( this );
    help.insertItem( "&About", this, SLOT("about()"), new QKeySequence(CTRL+Key_H) );
    help.insertItem( "About &Qt", this, SLOT("aboutQt()") );

    menu = new QMenuBar( this );
    menu.insertItem( "&File", file );
    menu.insertItem( "&Edit", edit );
    menu.insertItem( "&Options", options );
    menu.insertSeparator();
    menu.insertItem( "&Help", help );
    menu.setSeparator( QMenuBar.InWindowsStyle );

    label = new QLabel( this );
    label.setGeometry( 20, rect().center().y()-20, width()-40, 40 );
    label.setFrameStyle( QFrame.Box | QFrame.Raised );
    label.setLineWidth( 1 );
    label.setAlignment( AlignCenter );

    connect( this,  SIGNAL("explain(String)"),
	     label, SLOT("setText(String)") );

    setMinimumSize( 100, 80 );
}


void open()
{
    emit("explain", "File/Open selected" );
}


void news()
{
    emit("explain", "File/New selected" );
}

void save()
{
    emit("explain", "File/Save selected" );
}


void closeDoc()
{
    emit("explain", "File/Close selected" );
}


void undo()
{
    emit("explain", "Edit/Undo selected" );
}


void redo()
{
    emit("explain", "Edit/Redo selected" );
}


void normal()
{
    isBold = false;
    isUnderline = false;
    menu.setItemChecked( boldID, isBold );
    menu.setItemChecked( underlineID, isUnderline );
    emit("explain", "Options/Normal selected" );
}


void bold()
{
    isBold = !isBold;
    menu.setItemChecked( boldID, isBold );
    emit("explain", "Options/Bold selected" );
}


void underline()
{
    isUnderline = !isUnderline;
    menu.setItemChecked( underlineID, isUnderline );
    emit("explain", "Options/Underline selected" );
}


void about()
{
    QMessageBox.about( this, "Qt Menu Example",
			"This example demonstrates simple use of Qt menus.\n"
			+ "You can cut and paste lines from it to your own\n"
			+ "programs." );
}


void aboutQt()
{
    QMessageBox.aboutQt( this, "Qt Menu Example" );
}


void printer()
{
    emit("explain", "File/Printer/Print selected" );
}

void file()
{
    emit("explain", "File/Printer/Print To File selected" );
}

void fax()
{
    emit("explain", "File/Printer/Print To Fax selected" );
}

void printerSetup()
{
    emit("explain", "File/Printer/Printer Setup selected" );
}


void resizeEvent( QResizeEvent e  )
{
    label.setGeometry( 20, rect().center().y()-20, width()-40, 40 );
}


public static void main(String[] args)
{
    QApplication a = new QApplication( args );
    MenuExample m = new MenuExample();
    m.setCaption("Qt Examples - Menus");
    a.setMainWidget( m );
    m.show();
    a.exec();
    return;
}

	static {
		qtjava.initialize();
	}

}
