/***************************************************************************
                            KProcIO.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROCIO_H
#define KPROCIO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KProcess.h>

@class QTextCodec; 

@interface KProcIO : KProcess 
- initWithTextCodec: (QTextCodec*)codec;
- init;

/** 
  Starts the process.

  The following problems could cause this function to
    return false:

*/
- (BOOL) start: (int)runmode includeStderr: (BOOL)includeStderr;
- (BOOL) start;

/** 
 The buffer is zero terminated.
 A deep copy is made of the buffer, so you don't
 need to bother with that.  A newline ( '\n' ) is appended 
 unless you specify FALSE as the second parameter.
 FALSE is returned on an error, or else TRUE is.

*/
- (BOOL) writeStdin: (NSString *)line AppendNewLine: (BOOL)AppendNewLine;
- (BOOL) writeStdin: (NSString *)line ;
- (BOOL) fputs: (NSString *)line AppendNewLine: (BOOL)AppendNewLine;
- (BOOL) fputs: (NSString *)line ;

/** 
 reads a line of text (up to and including '\n')

 Use -readln in response to a -readReady signal.
 You may use it multiple times if more than one line of data is
  available.
 Be sure to use -ackRead when you have finished processing the
  -readReady signal.  This informs KProcIO that you are ready for
  another -readReady signal.

 -readln never blocks.

 autoAck==TRUE makes these functions call -ackRead for you.

*/
- (int) readln: (NSString *)line autoAck: (BOOL)autoAck partial: (int*)partial;
- (int) readln: (NSString *)line ;
- (int) fgets: (NSString *)line autoAck: (BOOL)autoAck;
- (int) fgets: (NSString *)line ;

/** 
 Reset the class.  Doesn't kill the process.

*/
- resetAll;

/** 
 Call this after you have finished processing a -readReady
 signal.  This call need not be made in the slot that was signalled
 by -readReady.  You won't receive any more -readReady signals
 until you acknowledge with -ackRead.  This prevents your slot
 from being reentered while you are still processing the current
 data.  If this doesn't matter, then call -ackRead right away in
 your -readReady-processing slot.

*/
- ackRead;

/** 
  Turns -readReady signals on and off.
   You can turn this off at will and not worry about losing any data.
   (as long as you turn it back on at some point...)
   
*/
- enableReadSignals: (BOOL)enable;
- controlledEmission;
- received: (KProcess*)proc buffer: (NSString *)buffer buflen: (int)buflen;
- sent: (KProcess*)arg1;
@end

/** Override these methods in subclasses of KProcIO to customise event handling behaviour */
@protocol KProcIOEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
