/***************************************************************************
                            KIconDialog.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Dialog for interactive selection of icons. Use the function
 getIcon() let the user select an icon.

 See {@link KIconDialogSignals} for signals emitted by KIconDialog.

 

 @short An icon selection dialog.
 
*/
public class KIconDialog extends KDialogBase  {
	protected KIconDialog(Class dummy){super((Class) null);}

	private native void newKIconDialog( QWidget parent, String name);

/** 
 Constructs an icon selection dialog using the global iconloader.
     
*/
	public KIconDialog( QWidget parent, String name) {
		super((Class) null);
		newKIconDialog( parent, name);
	}
	private native void newKIconDialog();
	public KIconDialog() {
		super((Class) null);
		newKIconDialog();
	}
	private native void newKIconDialog( KIconLoader loader, QWidget parent, String name);

/** 
 Constructs an icon selection dialog using a specific iconloader.
     
*/
	public KIconDialog( KIconLoader loader, QWidget parent, String name) {
		super((Class) null);
		newKIconDialog( loader, parent, name);
	}
	private native void newKIconDialog( KIconLoader loader);
	public KIconDialog( KIconLoader loader) {
		super((Class) null);
		newKIconDialog( loader);
	}

/** 
 Destructs the dialog.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Sets a strict icon size policy for allowed icons. When true,
 only icons of the specified group's size in {@link #getIcon} are shown.
 When false, icons not available at the desired group's size will
 also be selectable.
     
*/
	public native void setStrictIconSize( boolean b);

/** 
 Returns true if a strict icon size policy is set.
     
*/
	public native boolean strictIconSize();

/** 
 sets a custom icon directory

*/
	public native void setCustomLocation( String location);

/** 
 Sets the size of the icons to be shown / selected.

*/
	public native void setIconSize( int size);

/** 
 Returns the iconsize set via {@link #setIconSize} or 0, if the default
 iconsize will be used.
     
*/
	public native int iconSize();

/** 

     
*/
	public native String selectIcon( int group, int context, boolean user);
	public native String selectIcon();

/** 
 Allows you to set the same parameters as in the class method
 {@link #getIcon}.
     
*/
	public native void setup( int group, int context, boolean strictIconSize, int iconSize, boolean user);
	public native void setup( int group);

/** 
 exec()utes this modal dialog and returns the name of the selected icon,
 or String.null if the dialog was aborted.

*/
	public native String openDialog();

/** 
 Pops up the dialog an lets the user select an icon.

*/
	public static native String getIcon( int group, int context, boolean strictIconSize, int iconSize, boolean user, QWidget parent, String caption);
	public static native String getIcon();
	protected native void virtual_hook( int identifier, int data);
}
