/*
Copyright (c) 2000 Simon Hausmann <hausmann@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
#ifndef __dcopc_util_h__
#define __dcopc_util_h__

#ifdef __cplusplus
extern "C" {
#endif

#include <X11/ICE/ICElib.h>
#include <gtk/gtk.h>

#define dcop_free( o ) \
    { \
    g_free( o ); \
    o = 0; \
    }

#define dcop_string_assign( s, val ) \
    { \
    dcop_free( s ); \
    if ( val != NULL ) \
      s = val; \
    }

#define dcop_string_copy( s, val ) \
    { \
    dcop_free( s ); \
    if( val != NULL ) \
      s = g_strdup( val ); \
    }

#define dcop_string_assing( s, val ) \
    { \
    dcop_free( s ); \
    if ( val != NULL ) \
      s = val; \
    }

#define dcop_list_free( lst ) \
    { \
    GList *it = g_list_first( lst ); \
    while ( it ) \
    { \
      g_free( it->data ); \
      it = g_list_next( it ); \
    } \
    g_list_free( lst ); \
    }

#ifdef __cplusplus
}
#endif

#endif
