/**
 * @file op_file.h
 * Useful file management helpers
 *
 * @remark Copyright 2002 OProfile authors
 * @remark Read the file COPYING
 *
 * @author John Levon
 * @author Philippe Elie
 */

#ifndef OP_FILE_H
#define OP_FILE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>

int op_file_readable(char const * file);
int op_get_fsize(char const * file, off_t * size);
time_t op_get_mtime(char const * file);
char * op_relative_to_absolute_path(
	char const * path, char const * base_dir);

/**
 * create_dir - create a directory
 * @param dir  the directory name to create
 *
 * return false if the directory dir does not exist
 * and cannot be created
 */
int create_dir(char const * dir);


/**
 * create_path - create a path
 * @param path  the path to create
 *
 * create directory for each dir components in path
 * return false if one of the path cannot be created.
 */
int create_path(char const * path);

#ifdef __cplusplus
}
#endif

#endif /* OP_FILE_H */
