/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2003 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_menu.c - menu creation
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif

#include "callbacks_menu.h"
#include "interface.h"
#include "support.h"
#include "types.h"
#include "utils.h"
#include "log.h"

#if WANT_HAMLIB
#	include <hamlib/rig.h>
#endif


GtkWidget *printdialog;
GtkWidget *preferencesdialog;

extern GtkWidget *b4dialog;
extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern statetype state;
extern GList *searchhistory;
extern GList *logwindowlist;

#if WANT_HAMLIB
extern GList *riglist;
#endif

void
on_menu_print_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *printallradiobutton, *printrangeradiobutton, *printlowentry,
    *printhighentry, *printrangelabel, *sizecomboentry, *pointcomboentry,
    *conteststyleradiobutton, *normalstyleradiobutton,
    *filedestinationradiobutton, *printerdestinationradiobutton;
  gchar *temp;
  logtype *logwindow;

  printdialog = create_printdialog ();
  printallradiobutton = lookup_widget (printdialog, "printallradiobutton");
  printrangeradiobutton =
    lookup_widget (printdialog, "printrangeradiobutton");
  printlowentry = lookup_widget (printdialog, "printlowentry");
  printhighentry = lookup_widget (printdialog, "printhighentry");
  printrangelabel = lookup_widget (printdialog, "printrangelabel");
  sizecomboentry = lookup_widget (printdialog, "sizecomboentry");
  pointcomboentry = lookup_widget (printdialog, "pointcomboentry");
  filedestinationradiobutton =
    lookup_widget (printdialog, "filedestinationradiobutton");
  printerdestinationradiobutton =
    lookup_widget (printdialog, "printerdestinationradiobutton");
  normalstyleradiobutton =
    lookup_widget (printdialog, "normalstyleradiobutton");
  conteststyleradiobutton =
    lookup_widget (printdialog, "conteststyleradiobutton");

  if (preferences.printall == 0)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printallradiobutton),
				    TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printrangeradiobutton),
				    FALSE);
      gtk_widget_set_sensitive (printlowentry, 0);
      gtk_widget_set_sensitive (printhighentry, 0);
      gtk_widget_set_sensitive (printrangelabel, 0);
    }
  else
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printallradiobutton),
				    FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printrangeradiobutton),
				    TRUE);
      gtk_widget_set_sensitive (printlowentry, 1);
      gtk_widget_set_sensitive (printhighentry, 1);
      gtk_widget_set_sensitive (printrangelabel, 1);
    }

  if (preferences.printstyle == 0)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (normalstyleradiobutton), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (conteststyleradiobutton), FALSE);
    }
  else
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (normalstyleradiobutton), FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (conteststyleradiobutton), TRUE);
    }

  if (preferences.printdestination == 0)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (printerdestinationradiobutton), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (filedestinationradiobutton), FALSE);
    }
  else
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (printerdestinationradiobutton), FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
				    (filedestinationradiobutton), TRUE);
    }

  logwindow = g_list_nth_data (logwindowlist,
			       gtk_notebook_get_current_page (GTK_NOTEBOOK
							      (mainnotebook)));

  temp = g_strdup_printf ("1");
  gtk_entry_set_text (GTK_ENTRY (printlowentry), temp);
  temp = g_strdup_printf ("%d", logwindow->qsos);
  gtk_entry_set_text (GTK_ENTRY (printhighentry), temp);
  g_free (temp);

  if (preferences.printsize == 0)
    gtk_entry_set_text (GTK_ENTRY (sizecomboentry), "a4");
  else
    gtk_entry_set_text (GTK_ENTRY (sizecomboentry), "letter");

  if (preferences.printpoint == 0)
    gtk_entry_set_text (GTK_ENTRY (pointcomboentry), "10");
  else if (preferences.printpoint == 1)
    gtk_entry_set_text (GTK_ENTRY (pointcomboentry), "11");
  else if (preferences.printpoint == 2)
    gtk_entry_set_text (GTK_ENTRY (pointcomboentry), "12");

  gtk_widget_set_sensitive (mainwindow, 0);
  gtk_widget_show (printdialog);
}

void
on_menu_exit_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *savedialog;
  gint i;
  logtype *logwindow;
  gboolean logchanged = FALSE;

  for (i = 0; i < g_list_length (logwindowlist); i++)
    {
      logwindow = g_list_nth_data (logwindowlist, i);
      if (logwindow->logchanged)
	logchanged = TRUE;
    }

  if (logchanged)
    {
      savedialog = create_savedialog ();
      gtk_widget_set_sensitive (mainwindow, 0);
      gtk_widget_show (savedialog);
    }
  else
    {
      save_windowsize_and_cleanup ();
      gtk_exit (0);
    }
}

void
on_menu_save_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  gchar *temp;
  logtype *logwindow;
  gchar *xlogfile;

  logwindow = g_list_nth_data (logwindowlist,
			       gtk_notebook_get_current_page (GTK_NOTEBOOK
							      (mainnotebook)));
  xlogfile =
    g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, logwindow->logname,
		 ".xlog", NULL);
  savelog (logwindow, xlogfile, TYPE_FLOG);
  temp = g_strdup_printf (_("Log saved to %s"), xlogfile);
  update_statusbar (temp);
  g_free (temp);
  g_free (xlogfile);
  logwindow->logchanged = FALSE;
  gtk_label_set_text (GTK_LABEL (logwindow->label), logwindow->logname);
}


void
on_menu_preferences_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *latentry, *longentry, *NScomboentry,
    *EWcomboentry, *unitscomboentry, *modesentry, *bandsentry,
    *modesradiobutton1, *modesradiobutton2, *bandsradiobutton1,
    *bandsradiobutton2, *modeslabel, *bandslabel, *clockcheckbutton,
    *exampleframe, *examplelabel, *autosavecomboentry, *notebook,
    *themecheckbutton, *pathentry, *logsentry, *qthlocatorentry,
    *callsignentry, *fontentry, *savecheckbutton, *autosavecheckbutton,
    *autosaveframe, *typeaheadfindcheckbutton, *remoteradiobutton1,
    *remoteradiobutton2;
  gchar *temp;
#if WANT_HAMLIB
  GtkWidget *hamlibcheckbutton, *radiocombo, *hamlibframe, *radiocomboentry,
    *devicecomboentry, *frequencycheckbutton, *digitscomboentry,
    *smetercheckbutton;
  GList *combolist = NULL;
  gint i, numrigs;
  struct rig_caps *rcaps;
#endif

  preferencesdialog = create_preferencesdialog ();

  /* remote logging */
  remoteradiobutton1 = lookup_widget (preferencesdialog, "remoteradiobutton1");
  remoteradiobutton2 = lookup_widget (preferencesdialog, "remoteradiobutton2");
  if (preferences.remoteadding == 1)
  {
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remoteradiobutton1), TRUE);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remoteradiobutton2), FALSE);
  }
  else
  {
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remoteradiobutton1), FALSE);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (remoteradiobutton2), TRUE);
  }

  /* type ahead find */
  typeaheadfindcheckbutton = lookup_widget 
    (preferencesdialog, "typeaheadfindcheckbutton");
  if (preferences.typeaheadfind == 1)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON 
      (typeaheadfindcheckbutton), TRUE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON 
      (typeaheadfindcheckbutton), FALSE);

  /* path for the logs */
  pathentry = lookup_widget (preferencesdialog, "pathentry");
  temp = g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, NULL);
  gtk_entry_set_text (GTK_ENTRY (pathentry), temp);

  /* logs to load at startup */
  logsentry = lookup_widget (preferencesdialog, "logsentry");
  gtk_entry_set_text (GTK_ENTRY (logsentry), preferences.logstoload);

  /* callsign */
  callsignentry = lookup_widget (preferencesdialog, "callsignentry");
  gtk_entry_set_text (GTK_ENTRY (callsignentry), preferences.callsign);

  /* saving */
  temp = g_strdup_printf ("%d", preferences.autosave);
  autosavecomboentry =
    lookup_widget (preferencesdialog, "autosavecomboentry");
  gtk_entry_set_text (GTK_ENTRY (autosavecomboentry), temp);
  autosavecheckbutton = lookup_widget (preferencesdialog, "autosavecheckbutton");
  autosaveframe = lookup_widget (preferencesdialog, "autosaveframe");
  savecheckbutton = lookup_widget (preferencesdialog, "savecheckbutton");
  if (preferences.saving == 1)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(autosavecheckbutton), TRUE);
  }
  else if (preferences.saving == 2)
  {
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(savecheckbutton), TRUE);
    gtk_widget_set_sensitive(autosaveframe, FALSE);
  }

  /* theme */
  fontentry = lookup_widget (preferencesdialog, "fontentry");
  gtk_entry_set_text (GTK_ENTRY (fontentry), preferences.themefont);
  exampleframe = lookup_widget (preferencesdialog, "exampleframe");
  setframestyle (exampleframe, preferences.themecolor, preferences.themefont);
  examplelabel = lookup_widget (preferencesdialog, "examplelabel");
  setlabelstyle (examplelabel, preferences.themecolor, preferences.themefont);
  themecheckbutton = lookup_widget (preferencesdialog, "themecheckbutton");
  if (preferences.logcolor == 0)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (themecheckbutton),
				  FALSE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (themecheckbutton), TRUE);

  /* clock */
  clockcheckbutton = lookup_widget (preferencesdialog, "clockcheckbutton");
  if (preferences.clock == 0)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (clockcheckbutton),
				  FALSE);
  else
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (clockcheckbutton), TRUE);

#if WANT_HAMLIB
  hamlibcheckbutton = lookup_widget (preferencesdialog, "hamlibcheckbutton");
  hamlibframe = lookup_widget (preferencesdialog, "hamlibframe");
  frequencycheckbutton =
    lookup_widget (preferencesdialog, "frequencycheckbutton");
  smetercheckbutton = lookup_widget (preferencesdialog, "smetercheckbutton");
  if (preferences.hamlib == 0)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hamlibcheckbutton),
				    FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (frequencycheckbutton),
				    FALSE);
      gtk_widget_set_sensitive (hamlibframe, 0);
    }
  else
    {
      /* hide logging page if hamlib is enabled */
      notebook = lookup_widget (preferencesdialog, "preferencesnotebook");
      gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), 1);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (hamlibcheckbutton),
				    TRUE);
      if (preferences.hamlib == 2)
	{
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(frequencycheckbutton), TRUE);
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (smetercheckbutton),
					FALSE);
	}
      else if (preferences.hamlib == 3)
	{
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(frequencycheckbutton), FALSE);
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (smetercheckbutton),
					TRUE);
	}
      else if (preferences.hamlib == 4)
	{
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(frequencycheckbutton), TRUE);
	  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (smetercheckbutton),
					TRUE);
	}
      gtk_widget_set_sensitive (hamlibframe, 1);
    }
  numrigs = g_list_length (riglist);
  if (numrigs > 0)
    {
      for (i = 0; i < numrigs; i++)
	{
	  rcaps = (struct rig_caps *) g_list_nth_data (riglist, i);
	  combolist = g_list_append (combolist, (gchar *) rcaps->model_name);
	}
    }
  else
    combolist = g_list_append (combolist, "");

  radiocombo = lookup_widget (preferencesdialog, "radiocombo");
  gtk_combo_set_popdown_strings (GTK_COMBO (radiocombo), combolist);
  g_list_free (combolist);

  devicecomboentry = lookup_widget (preferencesdialog, "devicecomboentry");
  gtk_entry_set_text (GTK_ENTRY (devicecomboentry), preferences.device);
  radiocomboentry = lookup_widget (preferencesdialog, "radiocomboentry");
  gtk_entry_set_text (GTK_ENTRY (radiocomboentry), preferences.radio);
  temp = g_strdup_printf ("%d", preferences.round);
  digitscomboentry = lookup_widget (preferencesdialog, "digitscomboentry");
  gtk_entry_set_text (GTK_ENTRY (digitscomboentry), temp);

#else /* hide hamlib page in notebook if no hamlib support */
  notebook = lookup_widget (preferencesdialog, "preferencesnotebook");
  gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), 3);
#endif

  /* location */
  temp = g_strdup_printf ("%3.2f", preferences.latitude);
  latentry = lookup_widget (preferencesdialog, "latentry");
  gtk_entry_set_text (GTK_ENTRY (latentry), temp);
  NScomboentry = lookup_widget (preferencesdialog, "NScomboentry");
  if (preferences.NS == 1)
    gtk_entry_set_text (GTK_ENTRY (NScomboentry), _("N"));
  else
    gtk_entry_set_text (GTK_ENTRY (NScomboentry), _("S"));
  temp = g_strdup_printf ("%3.2f", preferences.longitude);
  longentry = lookup_widget (preferencesdialog, "longentry");
  gtk_entry_set_text (GTK_ENTRY (longentry), temp);
  EWcomboentry = lookup_widget (preferencesdialog, "EWcomboentry");
  if (preferences.EW == 1)
    gtk_entry_set_text (GTK_ENTRY (EWcomboentry), _("E"));
  else
    gtk_entry_set_text (GTK_ENTRY (EWcomboentry), _("W"));
  unitscomboentry = lookup_widget (preferencesdialog, "unitscomboentry");
  if (preferences.units == 1)
    gtk_entry_set_text (GTK_ENTRY (unitscomboentry), _("Kilometers"));
  else
    gtk_entry_set_text (GTK_ENTRY (unitscomboentry), _("Miles"));
  g_free (temp);

  /* locator */
  qthlocatorentry = lookup_widget (preferencesdialog, "qthlocatorentry");
  gtk_entry_set_text (GTK_ENTRY (qthlocatorentry), preferences.locator);

  /* modes and bands */
  modesentry = lookup_widget (preferencesdialog, "modesentry");
  gtk_entry_set_text (GTK_ENTRY (modesentry), preferences.modes);
  bandsentry = lookup_widget (preferencesdialog, "bandsentry");
  gtk_entry_set_text (GTK_ENTRY (bandsentry), preferences.bands);
  /* set state of radio buttons and sensitivity of associated widgets */
  modesradiobutton1 = lookup_widget (preferencesdialog, "modesradiobutton1");
  modesradiobutton2 = lookup_widget (preferencesdialog, "modesradiobutton2");
  modeslabel = lookup_widget (preferencesdialog, "modeslabel");
  if (preferences.modeseditbox == 0)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modesradiobutton1),
				    FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modesradiobutton2),
				    TRUE);
      gtk_widget_set_sensitive (modeslabel, 1);
      gtk_widget_set_sensitive (modesentry, 1);
    }
  else
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modesradiobutton1),
				    TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (modesradiobutton2),
				    FALSE);
      gtk_widget_set_sensitive (modeslabel, 0);
      gtk_widget_set_sensitive (modesentry, 0);
    }
  bandsradiobutton1 = lookup_widget (preferencesdialog, "bandsradiobutton1");
  bandsradiobutton2 = lookup_widget (preferencesdialog, "bandsradiobutton2");
  bandslabel = lookup_widget (preferencesdialog, "bandslabel");
  if (preferences.bandseditbox == 0)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bandsradiobutton1),
				    FALSE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bandsradiobutton2),
				    TRUE);
      gtk_widget_set_sensitive (bandslabel, 1);
      gtk_widget_set_sensitive (bandsentry, 1);
    }
  else
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bandsradiobutton1),
				    TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (bandsradiobutton2),
				    FALSE);
      gtk_widget_set_sensitive (bandslabel, 0);
      gtk_widget_set_sensitive (bandsentry, 0);
    }

  gtk_widget_set_sensitive (mainwindow, 0);
  gtk_widget_show (preferencesdialog);
}


void
on_menu_about_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *aboutdialog, *aboutlabel;
  gchar *labeltext;

  labeltext = g_strdup_printf (_("%s version %s\n\n"), PACKAGE, VERSION);
  labeltext =
    g_strconcat (labeltext, _("Logging Program for Hamradio Operators\n"),
		 "Copyright (C) 2001-2003\n",
		 " Joop Stakenborg PA4TU <pa4tu@amsat.org>\n",
		 "Stephane Fillod F8CFE <f8cfe@free.fr>\n\n",
		 "Homepage: http://people.debian.org\n/~pa3aba/xlog.html\n\n"
		 "Mailing list: http://mail.nongnu.org\n/mailman/listinfo/xlog-discussion",
		 NULL);
  aboutdialog = create_aboutdialog ();
  aboutlabel = lookup_widget (aboutdialog, "aboutlabel");
  gtk_label_set_text (GTK_LABEL (aboutlabel), labeltext);
  g_free (labeltext);
  setlabelstyle (aboutlabel, preferences.themecolor, preferences.themefont);
  gtk_widget_show (aboutdialog);
}


void
on_menu_search_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *searchdialog, *searchcombo;

  searchdialog = create_searchdialog ();
  searchcombo = lookup_widget (searchdialog, "searchcombo");
  if (searchhistory)
    gtk_combo_set_popdown_strings (GTK_COMBO (searchcombo), searchhistory);
  gtk_widget_set_sensitive (mainwindow, 0);
  gtk_widget_show (searchdialog);
}

void
on_menu_new_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *newlogdialog;

  newlogdialog = create_newlogdialog ();
  gtk_widget_set_sensitive (mainwindow, 0);
  gtk_widget_show (newlogdialog);
}

void
on_menu_close_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *closedialog;
  logtype *logwindow;
  gint page;

  page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook));
  if (page >= 0)
    {
      logwindow = g_list_nth_data (logwindowlist, page);
      if (logwindow->logchanged)
	{
	  closedialog = create_closedialog ();
	  gtk_widget_set_sensitive (mainwindow, 0);
	  gtk_widget_show (closedialog);
	}
      else
	{
	  logwindowlist = g_list_remove (logwindowlist, logwindow);
	  g_free (logwindow->logname);
	  g_free (logwindow);
	  gtk_notebook_remove_page (GTK_NOTEBOOK (mainnotebook), page);
	  state.logwindows--;
	}
    }
}


void
on_menu_open_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *fileselection, *filemenu, *hbox, *label, *menu, *item;
  gchar *selection;

  fileselection = create_fileselection ();

  /* optionmenu for the file types to be opened */
  hbox = gtk_hbox_new (FALSE, 50);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER
		     (GTK_FILE_SELECTION (fileselection)->main_vbox), hbox);
  label = gtk_label_new (_("Type of log:"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  filemenu = gtk_option_menu_new ();
  gtk_widget_ref (filemenu);
  gtk_object_set_data_full (GTK_OBJECT (fileselection), "filemenu", filemenu,
			    (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filemenu);
  gtk_box_pack_start (GTK_BOX (hbox), filemenu, FALSE, FALSE, 0);
  menu = gtk_menu_new ();
  item = gtk_menu_item_new_with_label ("xlog");
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
  item = gtk_menu_item_new_with_label ("twlog");
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
  item = gtk_menu_item_new_with_label ("adif");
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
  item = gtk_menu_item_new_with_label ("cabrillo");
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
  item = gtk_menu_item_new_with_label ("editest");
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (filemenu), menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (filemenu), 0);

  selection = g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, NULL);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (fileselection),
				   selection);

  gtk_widget_set_sensitive (mainwindow, 0);
  gtk_widget_show (fileselection);
}

void
on_menu_saveas_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *saveasdialog, *filemenu, *hbox, *label, *menu, *item;
  gchar *selection;

  saveasdialog = create_saveasdialog ();

  /* optionmenu for the file types */
  hbox = gtk_hbox_new (FALSE, 50);
  gtk_widget_show (hbox);
  gtk_container_add (GTK_CONTAINER
		     (GTK_FILE_SELECTION (saveasdialog)->main_vbox), hbox);
  label = gtk_label_new (_("Type of log:"));
  gtk_widget_show (label);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  filemenu = gtk_option_menu_new ();
  gtk_widget_ref (filemenu);
  gtk_object_set_data_full (GTK_OBJECT (saveasdialog), "saveasmenu", filemenu,
			    (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (filemenu);
  gtk_box_pack_start (GTK_BOX (hbox), filemenu, FALSE, FALSE, 0);
  menu = gtk_menu_new ();
  item = gtk_menu_item_new_with_label ("xlog");
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
  item = gtk_menu_item_new_with_label ("adif");
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
  item = gtk_menu_item_new_with_label ("cabrillo");
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (filemenu), menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU (filemenu), 0);

  selection = g_strconcat (preferences.savedir, G_DIR_SEPARATOR_S, NULL);
  gtk_file_selection_set_filename (GTK_FILE_SELECTION (saveasdialog),
				   selection);
  g_free (selection);

  gtk_widget_set_sensitive (mainwindow, 0);
  gtk_widget_show (saveasdialog);
}

void
on_menu_logeditor_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *logeditor, *powerhbox, *lecomboentry11, *endhbox, *lecomboentry3,
    *qslhbox, *lecomboentry9_10, *namehbox, *lecomboentry12, *qthhbox,
    *lecomboentry13, *locatorhbox, *lecomboentry14, *unknown1hbox,
    *lecomboentry15, *unknown2hbox, *lecomboentry16, *leentry15, *leentry16,
    *remarksvbox, *lecomboentry17;
  logtype *logwindow;
  gint page;

  page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook));

  if (page >= 0)
    {
      logwindow = g_list_nth_data (logwindowlist, page);
      logeditor = create_logeditor ();

      endhbox = lookup_widget (mainwindow, "endhbox");
      lecomboentry3 = lookup_widget (logeditor, "lecomboentry3");
      if (GTK_WIDGET_VISIBLE (endhbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry3), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry3), _("Hide"));

      qslhbox = lookup_widget (mainwindow, "qslhbox");
      lecomboentry9_10 = lookup_widget (logeditor, "lecomboentry9_10");
      if (GTK_WIDGET_VISIBLE (qslhbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry9_10), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry9_10), _("Hide"));

      powerhbox = lookup_widget (mainwindow, "powerhbox");
      lecomboentry11 = lookup_widget (logeditor, "lecomboentry11");
      if (GTK_WIDGET_VISIBLE (powerhbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry11), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry11), _("Hide"));

      namehbox = lookup_widget (mainwindow, "namehbox");
      lecomboentry12 = lookup_widget (logeditor, "lecomboentry12");
      if (GTK_WIDGET_VISIBLE (namehbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry12), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry12), _("Hide"));

      qthhbox = lookup_widget (mainwindow, "qthhbox");
      lecomboentry13 = lookup_widget (logeditor, "lecomboentry13");
      if (GTK_WIDGET_VISIBLE (qthhbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry13), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry13), _("Hide"));

      locatorhbox = lookup_widget (mainwindow, "locatorhbox");
      lecomboentry14 = lookup_widget (logeditor, "lecomboentry14");
      if (GTK_WIDGET_VISIBLE (locatorhbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry14), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry14), _("Hide"));

      unknown1hbox = lookup_widget (mainwindow, "unknown1hbox");
      lecomboentry15 = lookup_widget (logeditor, "lecomboentry15");
      if (GTK_WIDGET_VISIBLE (unknown1hbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry15), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry15), _("Hide"));

      unknown2hbox = lookup_widget (mainwindow, "unknown2hbox");
      lecomboentry16 = lookup_widget (logeditor, "lecomboentry16");
      if (GTK_WIDGET_VISIBLE (unknown2hbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry16), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry16), _("Hide"));

      leentry15 = lookup_widget (logeditor, "leentry15");
      leentry16 = lookup_widget (logeditor, "leentry16");
      gtk_entry_set_text (GTK_ENTRY (leentry15), preferences.freefield1);
      gtk_entry_set_text (GTK_ENTRY (leentry16), preferences.freefield2);

      remarksvbox = lookup_widget (mainwindow, "remarksvbox");
      lecomboentry17 = lookup_widget (logeditor, "lecomboentry17");
      if (GTK_WIDGET_VISIBLE (remarksvbox))
	gtk_entry_set_text (GTK_ENTRY (lecomboentry17), _("Show"));
      else
	gtk_entry_set_text (GTK_ENTRY (lecomboentry17), _("Hide"));

      gtk_widget_show (logeditor);
    }
}


void
on_menu_dupecheck_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dupecheckdialog, *dupecheckthisradiobutton,
    *dupecheckallradiobutton, *dupecheckbuttonmode, *dupecheckbuttonband;

  dupecheckdialog = create_dupecheckdialog ();
  dupecheckthisradiobutton = lookup_widget (dupecheckdialog,
					    "dupecheckthisradiobutton");
  dupecheckallradiobutton = lookup_widget (dupecheckdialog,
					   "dupecheckallradiobutton");
  dupecheckbuttonmode =
    lookup_widget (dupecheckdialog, "dupecheckbuttonmode");
  dupecheckbuttonband =
    lookup_widget (dupecheckdialog, "dupecheckbuttonband");

  if (state.dupecheck == 0)
    {
      gtk_toggle_button_set_active
	(GTK_TOGGLE_BUTTON (dupecheckthisradiobutton), TRUE);
      gtk_toggle_button_set_active
	(GTK_TOGGLE_BUTTON (dupecheckallradiobutton), FALSE);
    }
  else
    {
      gtk_toggle_button_set_active
	(GTK_TOGGLE_BUTTON (dupecheckthisradiobutton), FALSE);
      gtk_toggle_button_set_active
	(GTK_TOGGLE_BUTTON (dupecheckallradiobutton), TRUE);
    }

  gtk_toggle_button_set_active
    (GTK_TOGGLE_BUTTON (dupecheckbuttonmode), state.notdupecheckmode);
  gtk_toggle_button_set_active
    (GTK_TOGGLE_BUTTON (dupecheckbuttonband), state.notdupecheckband);

  gtk_widget_set_sensitive (mainwindow, 0);
  gtk_widget_show (dupecheckdialog);
}

void
on_menu_defaults_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *defaultsmhzentry, *defaultsmodeentry, *defaultstxrstentry,
    *defaultsrxrstentry, *defaultspowerentry, *defaultsdialog,
    *defaultsfreefield1entry, *defaultsfreefield2entry, *defaultsremarksentry;

  defaultsdialog = create_defaultsdialog ();
  defaultsmhzentry = lookup_widget (defaultsdialog, "defaultsmhzentry");
  defaultsmodeentry = lookup_widget (defaultsdialog, "defaultsmodeentry");
  defaultstxrstentry = lookup_widget (defaultsdialog, "defaultstxrstentry");
  defaultsrxrstentry = lookup_widget (defaultsdialog, "defaultsrxrstentry");
  defaultspowerentry = lookup_widget (defaultsdialog, "defaultspowerentry");
  defaultsfreefield1entry =
    lookup_widget (defaultsdialog, "defaultsfreefield1entry");
  defaultsfreefield2entry =
    lookup_widget (defaultsdialog, "defaultsfreefield2entry");
  defaultsremarksentry =
    lookup_widget (defaultsdialog, "defaultsremarksentry");

  if (g_strcasecmp (preferences.defaultmhz, "?"))
    gtk_entry_set_text (GTK_ENTRY (defaultsmhzentry), preferences.defaultmhz);
  if (g_strcasecmp (preferences.defaultmode, "?"))
    gtk_entry_set_text (GTK_ENTRY (defaultsmodeentry),
			preferences.defaultmode);
  if (g_strcasecmp (preferences.defaulttxrst, "?"))
    gtk_entry_set_text (GTK_ENTRY (defaultstxrstentry),
			preferences.defaulttxrst);
  if (g_strcasecmp (preferences.defaultrxrst, "?"))
    gtk_entry_set_text (GTK_ENTRY (defaultsrxrstentry),
			preferences.defaultrxrst);
  if (g_strcasecmp (preferences.defaultpower, "?"))
    gtk_entry_set_text (GTK_ENTRY (defaultspowerentry),
			preferences.defaultpower);
  if (g_strcasecmp (preferences.defaultfreefield1, "?"))
    gtk_entry_set_text (GTK_ENTRY (defaultsfreefield1entry),
			preferences.defaultfreefield1);
  if (g_strcasecmp (preferences.defaultfreefield2, "?"))
    gtk_entry_set_text (GTK_ENTRY (defaultsfreefield2entry),
			preferences.defaultfreefield2);
  if (g_strcasecmp (preferences.defaultremarks, "?"))
    gtk_entry_set_text (GTK_ENTRY (defaultsremarksentry),
			preferences.defaultremarks);

  gtk_widget_set_sensitive (mainwindow, 0);
  gtk_widget_show (defaultsdialog);
}

void
on_menu_worked_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *b4clist;
  gchar **b4split;
  gint i;

  gtk_widget_show (b4dialog);
  b4clist = lookup_widget(b4dialog, "b4clist");
  
  b4split = g_strsplit(preferences.b4columns, ",", 0);
  for (i = 0; i < 19; i++)
  {
    gtk_clist_set_column_visibility (GTK_CLIST (b4clist), i,
      atoi(b4split[i]) ? TRUE : FALSE);
  }
  g_strfreev(b4split);

}


void
on_menu_dialogs_activate(GtkMenuItem * menuitem, gpointer user_data)
{
  GtkWidget *dialogsdialog, *checkbutton;
  gchar **split, *widgetname;
  gint i;

  dialogsdialog = create_dialogsdialog ();
  split = g_strsplit(preferences.b4columns, ",", 0);
  for (i = 0; i < 19; i++)
  { /* look up name of the  button and set it */
    widgetname = g_strdup_printf("b4%d", i);
    checkbutton = lookup_widget(dialogsdialog, widgetname);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (checkbutton), 
      atoi(split[i]) ? TRUE : FALSE);
    g_free(widgetname);
  }
  g_strfreev(split);
  gtk_widget_set_sensitive (mainwindow, 0);
  if (GTK_WIDGET_VISIBLE (b4dialog)) 
    gtk_widget_set_sensitive (b4dialog, 0);
  gtk_widget_show (dialogsdialog);
}

