/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef FILTER_CURRENT_MEDIATOR__H
#define FILTER_CURRENT_MEDIATOR__H

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <pan/base/pan-callback.h>

typedef struct
{
	GtkWidget * _match_new_ckm;
	GtkWidget * _match_unread_ckm;
	GtkWidget * _match_read_ckm;
	GtkWidget * _match_only_new_tb;

	GtkWidget * _match_complete_ckm;
	GtkWidget * _match_incomplete_ckm;
	GtkWidget * _match_nonbinaries_ckm;
	GtkWidget * _match_only_complete_tb;

	GtkWidget * _match_watched_ckm;
	GtkWidget * _match_ignored_ckm;
	GtkWidget * _match_normal_ckm;

	GtkWidget * _match_mine_ckm;
	GtkWidget * _match_others_ckm;

	GtkWidget * _match_cached_ckm;
	GtkWidget * _match_noncached_ckm;
	GtkWidget * _match_only_cached_tb;

	GtkWidget * _show_articles_rmi;
	GtkWidget * _show_articles_and_replies_rmi;
	GtkWidget * _show_articles_and_refs_rmi;
	GtkWidget * _show_threads_rmi;

	GtkWidget * _show_only_my_threads_tb;
	GtkWidget * _show_only_watched_threads_tb;
}
FilterCurrentMediatorCtor;

void          filter_mediator_init                  (FilterCurrentMediatorCtor*);

void          filter_mediator_get_bits              (gulong      * setme_bits,
                                                     FilterShow  * setme_show);

void          filter_mediator_set_bits              (gulong        bits,
                                                     FilterShow    setme_show);

Filter*       filter_mediator_get_filter            (gulong        bits,
                                                     gboolean      negate);

PanCallback*  filter_mediator_get_change_callback   (void);

#endif
