/** 
 * Copyright (C) 2000-2002 the KGhostView authors. See file AUTHORS.
 * 	
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _INTERPRETER_DIALOG_H_
#define _INTERPRETER_DIALOG_H_

#include <qstring.h>
#include <kdialogbase.h>

class QButtonGroup;
class QCheckBox;
class QPushButton;
class QRadioButton;
class KLineEdit;
class KURLRequester;

class KGVConfigDialog : public KDialogBase 
{
    Q_OBJECT

public:
    enum {COLOR_PALETTE, GRAY_PALETTE, MONO_PALETTE};

    KGVConfigDialog( QWidget* parent = 0, const char* name = 0, 
		     bool modal = true );
    ~KGVConfigDialog();
    
    void setup();

    void readSettings();
    void writeSettings();

    bool    antiAlias()		const { return mAntialias; }
    bool    showMessages()	const { return mShowMessages; }
    bool    platformFonts()	const { return mPlatformFonts; }
    int	    paletteType()	const { return mPaletteType; }
    
    QString interpreterPath()	const { return mInterpreterPath; }
    QString nonAntialiasArgs()	const { return mNonAntiAliasArgs; }
    QString antialiasArgs()	const { return mAntiAliasArgs; }

protected slots:
    virtual void slotOk();
    virtual void slotDefault();
    
    bool slotConfigureGhostscript();
    void slotAaToggled( bool );
    void slotMonoOrGrayToggled( bool );

private:
    QCheckBox* mAntiAliasCheck;
    QCheckBox* mPlatformFontCheck;
    QCheckBox* mMessagesCheck;
    QRadioButton* mMonoRadio;
    QRadioButton* mGrayscaleRadio;
    QRadioButton* mColorRadio;
    QButtonGroup* mPaletteGroup;

    QPushButton* mConfigureButton;
    KURLRequester* mInterpreterReq;
    KLineEdit* mNonAntiAliasArgsEdit;
    KLineEdit* mAntiAliasArgsEdit;

    bool    mAntialias;
    bool    mShowMessages;
    bool    mPlatformFonts;
    int	    mPaletteType;
    
    QString mInterpreterPath;
    QString mNonAntiAliasArgs;
    QString mAntiAliasArgs;
};

#endif 

