/***************************************************************************
                            QProcess.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QPROCESS_H
#define QPROCESS_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

@class QDir; 

@interface QProcess : QObject 
- initWithObject: (QObject *)parent name: (NSString *)name;
- init;
- initWithText: (NSString *)arg0 parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)arg0 ;
- initWithArray: (NSArray *)args parent: (QObject *)parent name: (NSString *)name;
- initWithArray: (NSArray *)args ;
- (void) dealloc;
- (NSArray *) arguments;
- clearArguments;
- setArguments: (NSArray *)args;
- addArgument: (NSString *)arg;
- (QDir*) workingDirectory;
- setWorkingDirectory: (QDir *)dir;
- setCommunication: (int)c;
- (int) communication;
- (BOOL) start: (NSArray *)env;
- (BOOL) start;
- (BOOL) launch: (NSString *)buf env: (NSArray *)env;
- (BOOL) launch: (NSString *)buf ;
//- (BOOL) launch: (QByteArray*)buf env: (NSArray *)env;
//- (BOOL) launch: (QByteArray*)buf ;
- (BOOL) isRunning;
- (BOOL) normalExit;
- (int) exitStatus;
- (QByteArray*) readStdout;
- (QByteArray*) readStderr;
- (BOOL) canReadLineStdout;
- (BOOL) canReadLineStderr;
- (NSString *) readLineStdout;
- (NSString *) readLineStderr;
- (long) processIdentifier;
- flushStdin;
- tryTerminate;
- kill;
//- writeToStdin: (QByteArray*)buf;
- writeToStdin: (NSString *)buf;
- closeStdin;
- connectNotify: (NSString *)signal;
- disconnectNotify: (NSString *)signal;
+ (int) Stdin;
+ (int) Stdout;
+ (int) Stderr;
+ (int) DupStderr;
@end

/** Override these methods in subclasses of QProcess to customise event handling behaviour */
@protocol QProcessEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
