/***************************************************************************
                            KAboutTranslator.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KABOUTTRANSLATOR_H
#define KABOUTTRANSLATOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This structure is used to store information about a translator.
 It can store the translator's name and an email address.
 This class is intended for use in the @ref KAboutData class, 
 but it can be used elsewhere as well.
 Normally you should at least define the translator's name.

 It's not possible to use @ref KAboutPerson for this, because
 @ref KAboutPerson stores internally only const char* pointers, but the
 translator information is generated dynamically from the translation
 of a dummy string.

 @short 
 This structure is used to store information about a translator.
*/
@interface  KAboutTranslator : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Convenience constructor

*/
- initWithText: (NSString *)name emailAddress: (NSString *)emailAddress;
- init;

/**  
 The translator's name
     
*/
- (NSString *) name;

/** 
 The translator's email
     
*/
- (NSString *) emailAddress;
@end

#endif
