/***************************************************************************
                            KCompletionBase.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 An abstract base class for adding a completion feature
 into widgets.

 This is a convenience class that provides the basic functions
 needed to add text completion support into widgets.  All that
 is required is an implementation for the pure virtual function
 {@link setCompletedText}.  Refer to {@link KLineEdit} or {@link KComboBox}
 to see how easily such support can be added using this as a base
 class.

 @author Dawit Alemayehu <adawit@kde.org>
 
 @short An abstract class for adding text completion support to widgets.

*/
public class  KCompletionBase implements QtSupport, KCompletionBaseInterface {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KCompletionBase(Class dummy){}


/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Returns a pointer to the current completion object.

 If the object does not exist, it is automatically
 created.  Note that the completion object created
 here is used by default to handle the signals
 internally.  It is also deleted when this object's
 destructor is invoked.  If you do not want these
 default settings, use {@link setAutoDeleteCompletionObject}
 and {@link setHandleSignals} to change the behavior.
 Alternatively, you can set the boolean parameter to
 false to disable the automatic handling of the signals
 by this object.  Note that the boolean argument will be
 ignored if there already exists a completion object since
 no new object needs to be created. You need to use either
 {@link setHandleSignals} or {@link setCompletionObject} for
 such cases depending on your requirement.

*/
	public native KCompletion completionObject( boolean hsig);
	public native KCompletion completionObject();

/** 
 Sets up the completion object to be used.

 This method assigns the completion object and sets it
 up to automatically handle the completion and rotation
 signals internally.  You should use this function if
 you want to share one completion object among you widgets
 or need to use a customized completion object.

 The object assigned through this method is not deleted
 when this object's destructor is invoked unless you
 explicitly call {@link setAutoDeleteCompletionObject} after
 calling this method.  Also if you do not want the signals
 to be handled by an internal implementation, be sure to
 set the boolean argument to false.

 This method is also called when a completion-object is created
 automatically, when completionObject() is called the first time.

*/
	public native void setCompletionObject( KCompletion arg1, boolean hsig);
	public native void setCompletionObject( KCompletion arg1);

/** 
 Enables this object to handle completion and rotation
 events internally.

 This function simply assigns a boolean value that
 indicates whether it should handle rotation and
 completion events or not.  Note that this does not
 stop the object from emitting signals when these
 events occur.

*/
	public native void setHandleSignals( boolean arg1);

/** 
 Returns true if the completion object is deleted
 upon this widget's destruction.

 See {@link #setCompletionObject} and {@link #enableCompletion}
 for details.

*/
	public native boolean isCompletionObjectAutoDeleted();

/** 
 Sets the completion object when this widget's destructor
 is called.

 If the argument is set to true, the completion object
 is deleted when this widget's destructor is called.

*/
	public native void setAutoDeleteCompletionObject( boolean autoDelete);

/** 
 Sets the widget's ability to emit text completion and
 rotation signals.

 Invoking this function with <code>enable</code> set to <code>false</code> will
 cause the completion & rotation signals not to be emitted.
 However, unlike setting the completion object to <code>NULL</code>
 using {@link setCompletionObject}, disabling the emition of
 the signals through this method does not affect the current
 completion object.

 There is no need to invoke this function by default.  When a
 completion object is created through {@link completionObject} or
 {@link setCompletionObject}, these signals are set to emit
 automatically.  Also note that disabling this signals will not
 necessarily interfere with the objects ability to handle these
 events internally.  See {@link setHandleSignals}.

*/
	public native void setEnableSignals( boolean enable);

/** 
 Returns true if the object handles the signals.

*/
	public native boolean handleSignals();

/** 
 Returns true if the object emits the signals.

*/
	public native boolean emitSignals();

/** 
 Sets the type of completion to be used.

 The completion modes supported are those defined in
 {@link #KGlobalSettings}.  See below.

*/
	public native void setCompletionMode( int mode);

/** 
 Returns the current completion mode.

 The return values are of type {@link KGlobalSettings#Completion}.
 See {@link #setCompletionMode} for details.

*/
	public native int completionMode();

/** 
 Sets the key-binding to be used for manual text
 completion, text rotation in a history list as
 well as a completion list.

 When the keys set by this function are pressed, a
 signal defined by the inheriting widget will be activated.
 If the default value or 0 is specified by the second
 parameter, then the key-binding as defined in the global
 setting should be used.  This method returns false value
 for <code>key</code> is negative or the supplied key-binding conflicts
 with the ones set for one of the other features.

 NOTE: To use a modifier key (Shift, Ctrl, Alt) as part of
 the key-binding simply simply <code>sum</code> up the values of the
 modifier and the actual key.  For example, to use CTRL+E as
 a key binding for one of the items, you would simply supply
 <code></code>"Qt.CtrlButton + Qt.Key_E" as the second argument to this
 function.

*/
	public native boolean setKeyBinding( int arg1, KShortcut cut);

/** 
 Returns the key-binding used for the specified item.

 This methods returns the key-binding used to activate
 the feature feature given by <code>item.</code>  If the binding
 contains modifier key(s), the SUM of the modifier key
 and the actual key code are returned.

*/
	public native KShortcut getKeyBinding( int item);

/** 
 Sets this object to use global values for key-bindings.

 This method changes the values of the key bindings for
 rotation and completion features to the default values
 provided in KGlobalSettings.

 NOTE: By default inheriting widgets should uses the
 global key-bindings so that there will be no need to
 call this method.
     
*/
	public native void useGlobalKeyBindings();

/** 
 A pure virtual function that must be implemented by
 all inheriting classes.

 This function is intended to allow external completion
 implementations to set completed text appropriately.  It
 is mostly relevant when the completion mode is set to
 CompletionAuto and CompletionManual modes. See
 {@link KCompletionBase#setCompletedText}.
 Does nothing in CompletionPopup mode, as all available
 matches will be shown in the popup.

*/
	public native void setCompletedText( String text);

/** 
 A pure virtual function that must be implemented by
 all inheriting classes.

*/
	public native void setCompletedItems( String[] items);

/** 
 Returns a pointer to the completion object.

 This method is only different from {@link #completionObject}
 in that it does not create a new KCompletion object even if
 the internal pointer is <code>NULL.</code> Use this method to get the
 pointer to a completion object when inheriting so that you
 won't inadvertently create it!!

*/
	public native KCompletion compObj();
	public static final int /***Textcompletion(bydefaultCtrl-E).*/TextCompletion = 0;
	public static final int /***Switchtopreviouscompletion(bydefaultCtrl-Up).*/PrevCompletionMatch = 1;
	public static final int /***Switchtonextcompletion(bydefaultCtrl-Down).*/NextCompletionMatch = 2;
	public static final int /***Substringcompletion(bydefaultCtrl-T).*/SubstringCompletion = 3;
}
