/***************************************************************************
                            kde_KHTMLView.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KHTMLVIEW
#define KDE_KHTMLVIEW

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Renders and displays HTML in a @ref QScrollView.

 Suitable for use as an application's main view.

 @short *
 Renders and displays HTML in a @ref QScrollView.
*/

/** *
 Constructs a KHTMLView.
     
*/
kde_KHTMLView * kde_new_KHTMLView(kde_KHTMLPart* part, qt_QWidget * parent, char* name);
void kde_del_KHTMLView( kde_KHTMLView* p );

/** *
 Returns a pointer to the KHTMLPart that is
 rendering the page.

*/
kde_KHTMLPart* kde_KHTMLView_part(kde_KHTMLView* instPointer);
int kde_KHTMLView_frameWidth(kde_KHTMLView* instPointer);

/** *
 Sets a margin in x direction.
     
*/
void kde_KHTMLView_setMarginWidth(kde_KHTMLView* instPointer,int x);

/** *
 Returns the margin width.

 A return value of -1 means the default value will be used.
     
*/
int kde_KHTMLView_marginWidth(kde_KHTMLView* instPointer);
void kde_KHTMLView_setMarginHeight(kde_KHTMLView* instPointer,int y);

/** *
 Returns the margin height.

 A return value of -1 means the default value will be used.
     
*/
int kde_KHTMLView_marginHeight(kde_KHTMLView* instPointer);

/** *
 Sets verticals scrollbar mode. Reimplemented for internal reasons.
     
*/
void kde_KHTMLView_setVScrollBarMode(kde_KHTMLView* instPointer,int mode);

/** *
 Sets horizontal scrollbar mode. Reimplemented for internal reasons.
     
*/
void kde_KHTMLView_setHScrollBarMode(kde_KHTMLView* instPointer,int mode);

/** *
 Prints the HTML document.
     
*/
void kde_KHTMLView_print(kde_KHTMLView* instPointer);

/** *
 ensure the display is up to date
     
*/
void kde_KHTMLView_layout(kde_KHTMLView* instPointer);

/** *
 Close all child dialogs

*/
//void kde_KHTMLView_closeChildDialogs(kde_KHTMLView* instPointer);

/** *
 Between closeChildDialogs() and clear() no child dialogs may be created

*/
//int kde_KHTMLView_dialogsAllowed(kde_KHTMLView* instPointer);
void kde_KHTMLView_clear(kde_KHTMLView* instPointer);
int kde_KHTMLView_focusNextPrevChild(kde_KHTMLView* instPointer,int next);
void kde_KHTMLView_drawContents(kde_KHTMLView* instPointer,qt_QPainter * p, int clipx, int clipy, int clipw, int cliph);
void kde_KHTMLView_drawContents1(kde_KHTMLView* instPointer,qt_QPainter * arg1);
void kde_KHTMLView_doAutoScroll(kde_KHTMLView* instPointer);
void kde_KHTMLView_slotPaletteChanged(kde_KHTMLView* instPointer);
void kde_KHTMLView_slotScrollBarMoved(kde_KHTMLView* instPointer);

#endif
