/***************************************************************************
                            kde_Job.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_JOB
#define KDE_JOB

#include <qtc/qtc_types.h>
#include <kdec/kde_types.h>

/**
*
 The base class for all jobs.
 For all jobs created in an application, the code looks like

 <pre>
   KIO::Job * job = KIO::someoperation( some parameters );
   connect( job, SIGNAL( result( KIO::Job * ) ),
            this, SLOT( slotResult( KIO::Job * ) ) );
 </pre>
   (other connects, specific to the job)

 And slotResult is usually at least:

 <pre>
  if ( job->error() )
      job->showErrorDialog( this or 0L  );
 </pre>

     
 @short *
 The base class for all jobs.
*/
void kde_del_Job( kde_Job* p );

/** *
 Abort this job.
 This kills all subjobs and deletes the job.

*/
void kde_Job_kill(kde_Job* instPointer,int quietly);

/** *

*/
int kde_Job_error(kde_Job* instPointer);

/** *

*/
int kde_Job_progressId(kde_Job* instPointer);

/** *

*/
qt_QString * kde_Job_errorText(kde_Job* instPointer);

/** *
 Converts an error code and a non-i18n error message into an
 error message in the current language. The low level (non-i18n)
 error message (usually a url) is put into the translated error
 message using %1.

 Example for errid == ERR_CANNOT_OPEN_FOR_READING:
   i18n( "Could not read\n%1" ).arg( errortext );
 Use this to display the error yourself, but for a dialog box
 use @ref Job::showErrorDialog.
         
*/
qt_QString * kde_Job_errorString(kde_Job* instPointer);

/** *
 Converts an error code and a non-i18n error message into i18n
 strings suitable for presentation in a detailed error message box.

 @p reqUrl the request URL that generated this error message
 @p method the method that generated this error message
 (unimplemented)

 Returns strings: caption, error + description, causes+solutions
         
*/
qt_QStringList* kde_Job_detailedErrorStrings(kde_Job* instPointer,kde_KURL* reqUrl, int method);

/** *
 Display a dialog box to inform the user of the error given by
 this job.
 Only call if @ref #error is not 0, and only in the slot connected
 to @ref #result.

*/
void kde_Job_showErrorDialog(kde_Job* instPointer,qt_QWidget * parent);

/** *
 Enable or disable the automatic error handling. When automatic
 error handling is enabled and an error occurs, then showErrorDialog
 is called with the specified parentWidget (if supplied) , right before
 the emission of the result signal.

 The default is false.

 See also @ref #isAutoErrorHandlingEnabled , @ref #showErrorDialog

*/
void kde_Job_setAutoErrorHandlingEnabled(kde_Job* instPointer,int enable, qt_QWidget * parentWidget);

/** *
 Returns whether automatic error handling is enabled or disabled.
 See also @ref #setAutoErrorHandlingEnabled .
         
*/
int kde_Job_isAutoErrorHandlingEnabled(kde_Job* instPointer);

/** *
 Associate this job with a window given by @p window.
         
*/
void kde_Job_setWindow(kde_Job* instPointer,qt_QWidget * window);

/** *
 Returns the window this job is associated with.
         
*/
qt_QWidget * kde_Job_window(kde_Job* instPointer);

/** *
 Set the parent Job.
 One example use of this is when FileCopyJob calls open_RenameDlg,
 it must pass the correct progress ID of the parent CopyJob
 (to hide the progress dialog).

*/
void kde_Job_setParentJob(kde_Job* instPointer,void* parentJob);

/** *

*/
void* kde_Job_parentJob(kde_Job* instPointer);

/** *
 Set meta data to be sent to the slave.
         
*/
void kde_Job_setMetaData(kde_Job* instPointer,kde_MetaData* arg1);

/** *
 Add key/value pair to the meta data that is sent to the slave.
         
*/
void kde_Job_addMetaData(kde_Job* instPointer,qt_QString * key, qt_QString * value);

/** *

         
*/
kde_MetaData* kde_Job_outgoingMetaData(kde_Job* instPointer);

/** *
 Get meta data received from the slave.
 (Valid when first data is received and/or slave is finished)
         
*/
kde_MetaData* kde_Job_metaData(kde_Job* instPointer);

/** *
 Query meta data received from the slave.
 (Valid when first data is received and/or slave is finished)
         
*/
qt_QString * kde_Job_queryMetaData(kde_Job* instPointer,qt_QString * key);
kde_Job * kde_new_Job(int showProgressInfo);

/** *
 Add a job that has to be finished before a result
 is emitted. This has obviously to be called before
 the finish signal is emitted by the slave.

 If @p inheritMetaData is true, the subjob will
 inherit the meta data from this job.
         
*/
void kde_Job_addSubjob(kde_Job* instPointer,void* job, int inheritMetaData);

/** *
 Mark a sub job as being done. If it's the last to
 wait on the job will emit a result - jobs with
 two steps might want to override slotResult
 in order to avoid calling this method.
         
*/
void kde_Job_removeSubjob(kde_Job* instPointer,void* job);

/** *
 Utility function for inherited jobs.
 Emits the percent signal if bigger than m_percent,
 after calculating it from the parameters.
         
*/
void kde_Job_emitPercent(kde_Job* instPointer,unsigned long processedSize, unsigned long totalSize);

/** *
 Utility function for inherited jobs.
 Emits the speed signal and starts the timer for removing that info
         
*/
void kde_Job_emitSpeed(kde_Job* instPointer,unsigned long bytes_per_second);

/** *
 Utility function to emit the result signal, and suicide this job.
 It first tells the observer to hide the progress dialog for this job.
         
*/
void kde_Job_emitResult(kde_Job* instPointer);
void kde_Job_virtual_hook(kde_Job* instPointer,int identifier, void* data);

/** *
 Called whenever a subjob finishes.
 Default implementation checks for errors and propagates
 to parent job, then calls @ref #removeSubjob.
 Override if you don't want subjobs errors to be propagated.
         
*/
void kde_Job_slotResult(kde_Job* instPointer,kde_Job* job);

/** *
 Forward signal from subjob.
         
*/
void kde_Job_slotSpeed(kde_Job* instPointer,kde_Job* arg1, unsigned long bytes_per_second);

/** *
 Forward signal from subjob.
         
*/
void kde_Job_slotInfoMessage(kde_Job* instPointer,kde_Job* arg1, qt_QString * arg2);

/** *
 Remove speed information.
         
*/
void kde_Job_slotSpeedTimeout(kde_Job* instPointer);

#endif
