#include "kbusymanager.h"

#include <qvaluestack.h>
#include <qapplication.h>

#include <kcursor.h>
#include <kapplication.h>

class KBusyManager::Private
{
public:
  Private()
    : Size (-1)
  {
  }
  
  ~Private()
  {
  }

  QValueStack<bool> Stack;
  int Size;
};

KBusyManager* KBusyManager::self ()
{
  static KBusyManager kb;

  return &kb;
}

bool KBusyManager::isBusy () const
{
  return d->Stack.top();
}

void KBusyManager::setBusy (bool val)
{
  d->Stack.push (val);
  d->Size++;

  if (val)
    QApplication::setOverrideCursor (KCursor::waitCursor());

  kapp->mainWidget()->setEnabled (!val);
}

void KBusyManager::restore ()
{
  if (d->Size < 1)
    return;

  bool oldBusy = d->Stack.pop();
  
  if (oldBusy)
    QApplication::restoreOverrideCursor();

  kapp->mainWidget()->setEnabled (!d->Stack.top());
}

KBusyManager::KBusyManager ()
  : d (new Private())
{
  setBusy (false);
}

KBusyManager::~KBusyManager ()
{
  delete d;
}
