 /***************************************************************************
    pseudo_dtd.cpp
    $Id: pseudo_dtd.h,v 1.1 2002/06/12 00:44:56 alund Exp $
    copyright            : (C) 2001-2002 by Daniel Naber
    email                : daniel.naber@t-online.de
 ***************************************************************************/
 
/***************************************************************************
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 ***************************************************************************/

#ifndef _PLUGIN_KANT_XMLTOOLS_DTD_H
#define _PLUGIN_KANT_XMLTOOLS_DTD_H

#include <qdom.h>
#include <qprogressdialog.h>

class PseudoDTD
{

public:
	PseudoDTD();
	~PseudoDTD();

	void analyzeDTD(QString &meta_dtd_url, QString &meta_dtd);

	QStringList getAllowedElementsFast(QString parent_element);
	QStringList getAllowedAttributesFast(QString parent_element);
	QStringList getAllowedAttributeValuesFast(QString element, QString attribute);
	QStringList getEntitiesFast(QString start);

protected:

	bool getAllowedElements(QDomDocument *doc, QProgressDialog *progress);
	bool getAllowedAttributes(QDomDocument *doc, QProgressDialog *progress);
	bool getAllowedAttributeValues(QDomDocument *doc, QProgressDialog *progress);
	bool getEntities(QDomDocument *doc, QProgressDialog *progress);

	bool m_sgml_support;

	// Entities, e.g. <"nbsp", "160">
	QMap<QString,QString> m_entity_list;
	// Elements, e.g. <"a", ("b", "i", "em", "strong")>
	QMap<QString,QStringList> m_elements_list;
	// Attributes e.g. <"a", ("href", "lang", "title")>
	QMap<QString,QStringList> m_attributes_list;
	// Attribute values e.g. <"td", <"align", ("left", "right", "justify")>>
	QMap< QString,QMap<QString,QStringList> > m_attributevalues_list;

};

#endif // _PLUGIN_KANT_XMLTOOLS_DTD_H
