/***************************************************************************

    $Id: LangPropPage.h,v 1.4 2001/11/09 10:39:45 arnold Exp $

                   language properties dialog page

    -----------------------------------------------------------------------

    begin                : Wed Oct 13 18:37:13 1999
                                           
    copyright            : (C) 1999-2001 Ewald Arnold
                           (C) 2001 The KDE-EDU team
                         
    email                : kvoctrain@ewald-arnold.de                                    

    -----------------------------------------------------------------------

    $Log: LangPropPage.h,v $
    Revision 1.4  2001/11/09 10:39:45  arnold
    removed ability to display a different font for each column

    Revision 1.3  2001/10/21 15:22:00  arnold
    replaced qtarch dialog files by qtdesigner

    Revision 1.2  2001/10/17 21:41:15  waba
    Cleanup & port to Qt3, QTableView -> QTable
    TODO:
    * Fix actions that work on selections
    * Fix sorting
    * Fix language-menu

    Revision 1.1  2001/10/05 15:38:38  arnold
    import of version 0.7.0pre8 to kde-edu


 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef LangPropPage_included
#define LangPropPage_included

#include <qglobal.h>

#include "LangPropPageForm.h"

#include <GrammerManager.h>

class kvoctrainDoc;

class LangPropPage : public LangPropPageForm
{
    Q_OBJECT

public:

    LangPropPage
    (
        kvoctrainDoc      *doc,
        QString            curr_lang,
        const Conjugation &conjugations,
        const Article     &article,
        QWidget           *parent = NULL,
        const char        *name = NULL
    );

    Conjugation getConjugation();
    Article getArticle() const { return articles; }

protected:
    void keyPressEvent( QKeyEvent * );

public slots:
    void initFocus() const;

protected slots:

    void secondPluralChanged(const QString& );
    void secondSingularChanged(const QString& );
    void thirdNSingularChanged(const QString& );
    void thirdFPluralChanged(const QString& );
    void thirdMSingularChanged(const QString& );
    void thirdFSingularChanged(const QString& );
    void thirdMPluralChanged(const QString& );
    void thirdNPluralChanged(const QString& );
    void firstPluralChanged(const QString& );
    void firstSingularChanged(const QString& );
    void slotThirdSCommonToggled(bool);
    void slotThirdPCommonToggled(bool);

    void defNaturalChanged(const QString& );
    void indefMaleChanged(const QString& );
    void indefNaturalChanged(const QString& );
    void defFemaleChanged(const QString& );
    void indefFemaleChanged(const QString& );
    void defMaleChanged(const QString& );

 protected:

   kvoctrainDoc  *doc;
   Conjugation    conjugations;
   Article        articles;
};

#endif // LangPropPage_included
