/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * gimpitemlistview.h
 * Copyright (C) 2001 Michael Natterer <mitch@gimp.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIMP_ITEM_LIST_VIEW_H__
#define __GIMP_ITEM_LIST_VIEW_H__


#include "gimpcontainerlistview.h"


typedef GimpContainer * (* GimpGetContainerFunc) (const GimpImage *gimage);
typedef GimpItem      * (* GimpGetItemFunc)      (const GimpImage *gimage);
typedef void            (* GimpSetItemFunc)      (GimpImage       *gimage,
                                                  GimpItem        *item);
typedef void            (* GimpReorderItemFunc)  (GimpImage       *gimage,
                                                  GimpItem        *item,
                                                  gint             new_index,
                                                  gboolean         push_undo,
                                                  const gchar     *undo_desc);
typedef void            (* GimpAddItemFunc)      (GimpImage       *gimage,
                                                  GimpItem        *item,
                                                  gint             index);
typedef void            (* GimpRemoveItemFunc)   (GimpImage       *gimage,
                                                  GimpItem        *item);
typedef GimpItem      * (* GimpConvertItemFunc)  (GimpItem        *item,
                                                  GimpImage       *dest_gimage);

typedef void            (* GimpNewItemFunc)      (GimpImage       *gimage,
                                                  GimpItem        *template,
                                                  gboolean         interactive);
typedef void            (* GimpEditItemFunc)     (GimpItem        *item);
typedef void            (* GimpActivateItemFunc) (GimpItem        *item);


#define GIMP_TYPE_ITEM_LIST_VIEW            (gimp_item_list_view_get_type ())
#define GIMP_ITEM_LIST_VIEW(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIMP_TYPE_ITEM_LIST_VIEW, GimpItemListView))
#define GIMP_ITEM_LIST_VIEW_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GIMP_TYPE_ITEM_LIST_VIEW, GimpItemListViewClass))
#define GIMP_IS_ITEM_LIST_VIEW(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIMP_TYPE_ITEM_LIST_VIEW))
#define GIMP_IS_ITEM_LIST_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GIMP_TYPE_ITEM_LIST_VIEW))
#define GIMP_ITEM_LIST_VIEW_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GIMP_TYPE_ITEM_LIST_VIEW, GimpItemListViewClass))


typedef struct _GimpItemListViewClass  GimpItemListViewClass;

struct _GimpItemListView
{
  GimpContainerListView  parent_instance;

  GimpImage             *gimage;

  GType                  item_type;
  gchar                 *signal_name;

  GimpNewItemFunc        new_item_func;
  GimpEditItemFunc       edit_item_func;
  GimpActivateItemFunc   activate_item_func;

  GimpItemFactory       *item_factory;

  GtkWidget             *new_button;
  GtkWidget             *raise_button;
  GtkWidget             *lower_button;
  GtkWidget             *duplicate_button;
  GtkWidget             *edit_button;
  GtkWidget             *delete_button;
};

struct _GimpItemListViewClass
{
  GimpContainerListViewClass  parent_class;

  /*  virtual functions  */
  void (* set_image) (GimpItemListView *view,
                      GimpImage        *gimage);

  /*  virtual functions for manipulating the image's item list  */
  GimpGetContainerFunc  get_container;
  GimpGetItemFunc       get_active_item;
  GimpSetItemFunc       set_active_item;
  GimpReorderItemFunc   reorder_item;
  GimpAddItemFunc       add_item;
  GimpRemoveItemFunc    remove_item;
  GimpConvertItemFunc   convert_item;

  /*  various descriptive strings for tooltips and undo steps  */
  const gchar          *new_desc;
  const gchar          *duplicate_desc;
  const gchar          *edit_desc;
  const gchar          *delete_desc;
  const gchar          *raise_desc;
  const gchar          *raise_to_top_desc;
  const gchar          *lower_desc;
  const gchar          *lower_to_bottom_desc;
};


GType       gimp_item_list_view_get_type (void) G_GNUC_CONST;

GtkWidget * gimp_item_list_view_new      (gint                  preview_size,
                                          GimpImage            *gimage,
                                          GType                 item_type,
                                          const gchar          *signal_name,
                                          GimpNewItemFunc       new_item_func,
                                          GimpEditItemFunc      edit_item_func,
                                          GimpActivateItemFunc  activate_item_func,
                                          GimpMenuFactory      *menu_facotry,
                                          const gchar          *menu_identifier);

void       gimp_item_list_view_set_image (GimpItemListView     *view,
                                          GimpImage            *gimage);


#endif  /*  __GIMP_ITEM_LIST_VIEW_H__  */
