/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.runtime;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.rmi.server.LogStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import sun.security.action.GetPropertyAction;

public abstract class Log {
    public static final Level BRIEF = Level.FINE;
    public static final Level VERBOSE = Level.FINER;
    private static final LogFactory logFactory;

    public abstract boolean isLoggable(Level var1);

    public abstract void log(Level var1, String var2);

    public abstract void log(Level var1, String var2, Throwable var3);

    public abstract void setOutputStream(OutputStream var1);

    public abstract PrintStream getPrintStream();

    public static Log getLog(String string, String string2, int n2) {
        Level level = n2 < 0 ? null : (n2 == 0 ? Level.OFF : (n2 > 0 && n2 <= 10 ? BRIEF : (n2 > 10 && n2 <= 20 ? VERBOSE : Level.FINEST)));
        return logFactory.createLog(string, string2, level);
    }

    public static Log getLog(String string, String string2, boolean bl2) {
        Level level = bl2 ? VERBOSE : null;
        return logFactory.createLog(string, string2, level);
    }

    private static String[] getSource() {
        StackTraceElement[] stackTraceElementArray = new Exception().getStackTrace();
        return new String[]{stackTraceElementArray[3].getClassName(), stackTraceElementArray[3].getMethodName()};
    }

    static {
        boolean bl2 = Boolean.valueOf((String)AccessController.doPrivileged(new GetPropertyAction("sun.rmi.log.useOld")));
        logFactory = bl2 ? new LogStreamLogFactory() : new LoggerLogFactory();
    }

    private static class LogStreamLog
    extends Log {
        private final LogStream stream;
        private int levelValue = Level.OFF.intValue();

        private LogStreamLog(LogStream logStream, Level level) {
            if (logStream != null && level != null) {
                this.levelValue = level.intValue();
            }
            this.stream = logStream;
        }

        public synchronized boolean isLoggable(Level level) {
            return level.intValue() >= this.levelValue;
        }

        public void log(Level level, String string) {
            if (this.isLoggable(level)) {
                String[] stringArray = Log.getSource();
                this.stream.println(LogStreamLog.unqualifiedName(stringArray[0]) + "." + stringArray[1] + ": " + string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(Level level, String string, Throwable throwable) {
            if (this.isLoggable(level)) {
                LogStream logStream = this.stream;
                synchronized (logStream) {
                    String[] stringArray = Log.getSource();
                    this.stream.println(LogStreamLog.unqualifiedName(stringArray[0]) + "." + stringArray[1] + ": " + string);
                    throwable.printStackTrace(this.stream);
                }
            }
        }

        public PrintStream getPrintStream() {
            return this.stream;
        }

        public synchronized void setOutputStream(OutputStream outputStream) {
            if (outputStream != null) {
                if (VERBOSE.intValue() < this.levelValue) {
                    this.levelValue = VERBOSE.intValue();
                }
                this.stream.setOutputStream(outputStream);
            } else {
                this.levelValue = Level.OFF.intValue();
            }
        }

        private static String unqualifiedName(String string) {
            int n2 = string.lastIndexOf(".");
            if (n2 >= 0) {
                string = string.substring(n2 + 1);
            }
            string = string.replace('$', '.');
            return string;
        }
    }

    private static class LogStreamLogFactory
    implements LogFactory {
        LogStreamLogFactory() {
        }

        public Log createLog(String string, String string2, Level level) {
            LogStream logStream = null;
            if (string2 != null) {
                logStream = LogStream.log(string2);
            }
            return new LogStreamLog(logStream, level);
        }
    }

    private class LoggerPrintStream
    extends PrintStream {
        private final Logger logger;
        private int last;
        private final ByteArrayOutputStream bufOut;

        private LoggerPrintStream(Logger logger) {
            super(new ByteArrayOutputStream());
            this.last = -1;
            this.bufOut = (ByteArrayOutputStream)this.out;
            this.logger = logger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n2) {
            if (this.last == 13 && n2 == 10) {
                this.last = -1;
                return;
            }
            if (n2 == 10 || n2 == 13) {
                try {
                    String string = Thread.currentThread().getName() + ": " + this.bufOut.toString();
                    this.logger.logp(Level.INFO, "LogStream", "print", string);
                    Object var4_3 = null;
                    this.bufOut.reset();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.bufOut.reset();
                    throw throwable;
                }
            } else {
                super.write(n2);
            }
            this.last = n2;
        }

        public void write(byte[] byArray, int n2, int n3) {
            if (n3 < 0) {
                throw new ArrayIndexOutOfBoundsException(n3);
            }
            int n4 = 0;
            while (n4 < n3) {
                this.write(byArray[n2 + n4]);
                ++n4;
            }
        }

        public String toString() {
            return "RMI";
        }
    }

    private static class InternalStreamHandler
    extends StreamHandler {
        InternalStreamHandler(OutputStream outputStream) {
            super(outputStream, new SimpleFormatter());
        }

        public void publish(LogRecord logRecord) {
            super.publish(logRecord);
            this.flush();
        }

        public void close() {
            this.flush();
        }
    }

    private static class LoggerLog
    extends Log {
        private static final Handler alternateConsole = (Handler)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InternalStreamHandler internalStreamHandler = new InternalStreamHandler(System.err);
                internalStreamHandler.setLevel(Level.ALL);
                return internalStreamHandler;
            }
        });
        private InternalStreamHandler copyHandler = null;
        private final Logger logger;
        private LoggerPrintStream loggerSandwich;

        private LoggerLog(Logger logger, Level level) {
            this.logger = logger;
            if (level != null) {
                AccessController.doPrivileged(new PrivilegedAction(this, logger, level){
                    private final /* synthetic */ Logger val$logger;
                    private final /* synthetic */ Level val$level;
                    private final /* synthetic */ LoggerLog this$0;
                    {
                        this.this$0 = loggerLog;
                        this.val$logger = logger;
                        this.val$level = level;
                    }

                    public Object run() {
                        if (!this.val$logger.isLoggable(this.val$level)) {
                            this.val$logger.setLevel(this.val$level);
                        }
                        this.val$logger.addHandler(LoggerLog.access$100());
                        return null;
                    }
                });
            }
        }

        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }

        public void log(Level level, String string) {
            if (this.isLoggable(level)) {
                String[] stringArray = Log.getSource();
                this.logger.logp(level, stringArray[0], stringArray[1], Thread.currentThread().getName() + ": " + string);
            }
        }

        public void log(Level level, String string, Throwable throwable) {
            if (this.isLoggable(level)) {
                String[] stringArray = Log.getSource();
                this.logger.logp(level, stringArray[0], stringArray[1], Thread.currentThread().getName() + ": " + string, throwable);
            }
        }

        public synchronized void setOutputStream(OutputStream outputStream) {
            if (outputStream != null) {
                if (!this.logger.isLoggable(VERBOSE)) {
                    this.logger.setLevel(VERBOSE);
                }
                this.copyHandler = new InternalStreamHandler(outputStream);
                this.copyHandler.setLevel(VERBOSE);
                this.logger.addHandler(this.copyHandler);
            } else {
                if (this.copyHandler != null) {
                    this.logger.removeHandler(this.copyHandler);
                }
                this.copyHandler = null;
            }
        }

        public synchronized PrintStream getPrintStream() {
            if (this.loggerSandwich == null) {
                this.loggerSandwich = new LoggerPrintStream(this.logger);
            }
            return this.loggerSandwich;
        }

        static /* synthetic */ Handler access$100() {
            return alternateConsole;
        }
    }

    private static class LoggerLogFactory
    implements LogFactory {
        LoggerLogFactory() {
        }

        public Log createLog(String string, String string2, Level level) {
            Logger logger = Logger.getLogger(string);
            return new LoggerLog(logger, level);
        }
    }

    private static interface LogFactory {
        public Log createLog(String var1, String var2, Level var3);
    }
}

