/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.net.ProgressData;
import sun.net.ProgressEntry;

public class MeteredStream
extends FilterInputStream {
    protected boolean closed = false;
    protected int expected;
    protected int count = 0;
    protected ProgressEntry te;

    public MeteredStream(InputStream inputStream, ProgressEntry progressEntry) {
        super(inputStream);
        this.te = progressEntry;
        this.expected = progressEntry.need;
        ProgressData.pdata.update(progressEntry);
    }

    private final void justRead(int n2) throws IOException {
        if (n2 == -1) {
            this.close();
            return;
        }
        this.count += n2;
        this.te.update(this.count, this.expected);
        ProgressData.pdata.update(this.te);
        if (this.count >= this.expected) {
            this.close();
        }
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int n2 = this.in.read();
        if (n2 != -1) {
            this.justRead(1);
        } else {
            this.close();
        }
        return n2;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n4 = this.in.read(byArray, n2, n3);
        this.justRead(n4);
        return n4;
    }

    public synchronized long skip(long l2) throws IOException {
        if (this.closed) {
            return 0L;
        }
        int n2 = l2 > (long)(this.expected - this.count) ? this.expected - this.count : (int)l2;
        l2 = this.in.skip(n2);
        this.justRead((int)l2);
        return l2;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        ProgressData.pdata.unregister(this.te);
        this.closed = true;
        this.in.close();
    }

    public synchronized int available() throws IOException {
        return this.closed ? 0 : this.in.available();
    }

    public synchronized void mark(int n2) {
        if (this.closed) {
            return;
        }
        super.mark(n2);
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            return;
        }
        super.reset();
    }

    public boolean markSupported() {
        if (this.closed) {
            return false;
        }
        return super.markSupported();
    }

    protected void finalize() {
        this.te.what = 3;
    }
}

