/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.serialize.Encodings;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.FastStringBuffer;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.WrappedRuntimeException;

public class OutputProperties
extends ElemTemplateElement
implements Cloneable {
    static final String S_XSLT_PREFIX = "xslt.output.";
    static final int S_XSLT_PREFIX_LEN = "xslt.output.".length();
    static final String S_XALAN_PREFIX = "org.apache.xslt.";
    static final int S_XALAN_PREFIX_LEN = "org.apache.xslt.".length();
    static final String S_BUILTIN_EXTENSIONS_UNIVERSAL = "{http://xml.apache.org/xslt}";
    private transient Hashtable m_propertiesLevels;
    private Properties m_properties = null;
    public static String S_KEY_INDENT_AMOUNT = "{http://xml.apache.org/xslt}indent-amount";
    public static String S_KEY_CONTENT_HANDLER = "{http://xml.apache.org/xslt}content-handler";
    public static String S_KEY_ENTITIES = "{http://xml.apache.org/xslt}entities";
    public static String S_USE_URL_ESCAPING = "{http://xml.apache.org/xslt}use-url-escaping";
    public static String S_OMIT_META_TAG = "{http://xml.apache.org/xslt}omit-meta-tag";
    private static Properties m_xml_properties = null;
    private static Properties m_html_properties = null;
    private static Properties m_text_properties = null;
    private static Integer m_synch_object = new Integer(1);
    private static final Class[] NO_CLASSES = new Class[0];
    private static final Object[] NO_OBJS = new Object[0];
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$xalan$templates$OutputProperties;

    public OutputProperties() {
        this("xml");
    }

    public OutputProperties(Properties properties) {
        this.m_properties = new Properties(properties);
    }

    public OutputProperties(String string) {
        this.m_properties = new Properties(OutputProperties.getDefaultMethodProperties(string));
    }

    private static String fixupPropertyString(String string, boolean bl2) {
        int n2;
        if (bl2 && string.startsWith(S_XSLT_PREFIX)) {
            string = string.substring(S_XSLT_PREFIX_LEN);
        }
        if (string.startsWith(S_XALAN_PREFIX)) {
            string = S_BUILTIN_EXTENSIONS_UNIVERSAL + string.substring(S_XALAN_PREFIX_LEN);
        }
        if ((n2 = string.indexOf("\\u003a")) > 0) {
            String string2 = string.substring(n2 + 6);
            string = string.substring(0, n2) + ":" + string2;
        }
        return string;
    }

    private static Properties loadPropertiesFile(String string, Properties properties) throws IOException {
        Object object;
        Object object2;
        Properties properties2 = new Properties(properties);
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                object2 = (class$java$lang$Thread == null ? (class$java$lang$Thread = OutputProperties.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", NO_CLASSES);
                if (object2 != null) {
                    object = (ClassLoader)((Method)object2).invoke(Thread.currentThread(), NO_OBJS);
                    inputStream = ((ClassLoader)object).getResourceAsStream("org/apache/xalan/templates/" + string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (inputStream == null) {
                inputStream = (class$org$apache$xalan$templates$OutputProperties == null ? (class$org$apache$xalan$templates$OutputProperties = OutputProperties.class$("org.apache.xalan.templates.OutputProperties")) : class$org$apache$xalan$templates$OutputProperties).getResourceAsStream(string);
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
            properties2.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            if (properties == null) {
                throw iOException;
            }
            throw new WrappedRuntimeException(XSLMessages.createMessage(143, new Object[]{string}), iOException);
        }
        catch (SecurityException securityException) {
            if (properties == null) {
                throw securityException;
            }
            throw new WrappedRuntimeException(XSLMessages.createMessage(143, new Object[]{string}), securityException);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        object2 = ((Properties)properties2.clone()).keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            String string2 = null;
            try {
                string2 = System.getProperty((String)object);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string2 == null) {
                string2 = (String)properties2.get(object);
            }
            String string3 = OutputProperties.fixupPropertyString((String)object, true);
            String string4 = null;
            try {
                string4 = System.getProperty(string3);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            string4 = string4 == null ? OutputProperties.fixupPropertyString(string2, false) : OutputProperties.fixupPropertyString(string4, false);
            if (object == string3 && string2 == string4) continue;
            properties2.remove(object);
            properties2.put(string3, string4);
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getDefaultMethodProperties(String string) {
        String string2 = null;
        Properties properties = null;
        try {
            Integer n2 = m_synch_object;
            synchronized (n2) {
                if (null == m_xml_properties) {
                    string2 = "output_xml.properties";
                    m_xml_properties = OutputProperties.loadPropertiesFile(string2, null);
                }
            }
            if (string.equals("xml")) {
                properties = m_xml_properties;
            } else if (string.equals("html")) {
                if (null == m_html_properties) {
                    string2 = "output_html.properties";
                    m_html_properties = OutputProperties.loadPropertiesFile(string2, m_xml_properties);
                }
                properties = m_html_properties;
            } else if (string.equals("text")) {
                if (null == m_text_properties && null == (m_text_properties = OutputProperties.loadPropertiesFile(string2 = "output_text.properties", m_xml_properties)).getProperty("encoding")) {
                    String string3 = Encodings.getMimeEncoding(null);
                    m_text_properties.put("encoding", string3);
                }
                properties = m_text_properties;
            } else {
                properties = m_xml_properties;
            }
        }
        catch (IOException iOException) {
            throw new WrappedRuntimeException("Output method is " + string + " could not load " + string2 + " (check CLASSPATH)", iOException);
        }
        return properties;
    }

    public Object clone() {
        try {
            OutputProperties outputProperties = (OutputProperties)super.clone();
            outputProperties.m_properties = (Properties)outputProperties.m_properties.clone();
            return outputProperties;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setProperty(QName qName, String string) {
        this.setProperty(qName.toNamespacedString(), string);
    }

    public void setProperty(String string, String string2) {
        if (string.equals("method")) {
            this.setMethodDefaults(string2);
        }
        this.m_properties.put(string, string2);
    }

    public String getProperty(QName qName) {
        return this.m_properties.getProperty(qName.toNamespacedString());
    }

    public String getProperty(String string) {
        return this.m_properties.getProperty(string);
    }

    public void setBooleanProperty(QName qName, boolean bl2) {
        this.m_properties.put(qName.toNamespacedString(), bl2 ? "yes" : "no");
    }

    public void setBooleanProperty(String string, boolean bl2) {
        this.m_properties.put(string, bl2 ? "yes" : "no");
    }

    public boolean getBooleanProperty(QName qName) {
        return this.getBooleanProperty(qName.toNamespacedString());
    }

    public boolean getBooleanProperty(String string) {
        return OutputProperties.getBooleanProperty(string, this.m_properties);
    }

    public static boolean getBooleanProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        return null != string2 && string2.equals("yes");
    }

    public void setIntProperty(QName qName, int n2) {
        this.setIntProperty(qName.toNamespacedString(), n2);
    }

    public void setIntProperty(String string, int n2) {
        this.m_properties.put(string, Integer.toString(n2));
    }

    public int getIntProperty(QName qName) {
        return this.getIntProperty(qName.toNamespacedString());
    }

    public int getIntProperty(String string) {
        return OutputProperties.getIntProperty(string, this.m_properties);
    }

    public static int getIntProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (null == string2) {
            return 0;
        }
        return Integer.parseInt(string2);
    }

    public void setQNameProperty(QName qName, QName qName2) {
        this.setQNameProperty(qName.toNamespacedString(), qName2);
    }

    public void setMethodDefaults(String string) {
        String string2 = this.m_properties.getProperty("method");
        if (null == string2 || !string2.equals(string)) {
            Properties properties = this.m_properties;
            Properties properties2 = OutputProperties.getDefaultMethodProperties(string);
            this.m_properties = new Properties(properties2);
            this.copyFrom(properties, false);
        }
    }

    public void setQNameProperty(String string, QName qName) {
        this.setProperty(string, qName.toNamespacedString());
    }

    public QName getQNameProperty(QName qName) {
        return this.getQNameProperty(qName.toNamespacedString());
    }

    public QName getQNameProperty(String string) {
        return OutputProperties.getQNameProperty(string, this.m_properties);
    }

    public static QName getQNameProperty(String string, Properties properties) {
        String string2 = properties.getProperty(string);
        if (null != string2) {
            return QName.getQNameFromString(string2);
        }
        return null;
    }

    public void setQNameProperties(QName qName, Vector vector) {
        this.setQNameProperties(qName.toNamespacedString(), vector);
    }

    public void setQNameProperties(String string, Vector vector) {
        int n2 = vector.size();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(9, 9);
        int n3 = 0;
        while (n3 < n2) {
            QName qName = (QName)vector.elementAt(n3);
            fastStringBuffer.append(qName.toNamespacedString());
            if (n3 < n2 - 1) {
                fastStringBuffer.append(' ');
            }
            ++n3;
        }
        this.m_properties.put(string, fastStringBuffer.toString());
    }

    public Vector getQNameProperties(QName qName) {
        return this.getQNameProperties(qName.toNamespacedString());
    }

    public Vector getQNameProperties(String string) {
        return OutputProperties.getQNameProperties(string, this.m_properties);
    }

    public static Vector getQNameProperties(String string, Properties properties) {
        block6: {
            String string2 = properties.getProperty(string);
            if (null == string2) break block6;
            Vector vector = new Vector();
            int n2 = string2.length();
            boolean bl2 = false;
            FastStringBuffer fastStringBuffer = new FastStringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                block9: {
                    char c2;
                    block8: {
                        block7: {
                            c2 = string2.charAt(n3);
                            if (!Character.isWhitespace(c2)) break block7;
                            if (bl2) break block8;
                            if (fastStringBuffer.length() > 0) {
                                QName qName = QName.getQNameFromString(fastStringBuffer.toString());
                                vector.addElement(qName);
                                fastStringBuffer.reset();
                            }
                            break block9;
                        }
                        if ('{' == c2) {
                            bl2 = true;
                        } else if ('}' == c2) {
                            bl2 = false;
                        }
                    }
                    fastStringBuffer.append(c2);
                }
                ++n3;
            }
            if (fastStringBuffer.length() > 0) {
                QName qName = QName.getQNameFromString(fastStringBuffer.toString());
                vector.addElement(qName);
                fastStringBuffer.reset();
            }
            return vector;
        }
        return null;
    }

    public void recompose(StylesheetRoot stylesheetRoot) throws TransformerException {
        stylesheetRoot.recomposeOutput(this);
    }

    public void compose(StylesheetRoot stylesheetRoot) throws TransformerException {
        super.compose(stylesheetRoot);
        this.m_propertiesLevels = null;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    public void copyFrom(Properties properties) {
        this.copyFrom(properties, true);
    }

    public void copyFrom(Properties properties, boolean bl2) {
        Enumeration enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = this.m_properties.get(string);
            if (null == object) {
                String string2 = (String)properties.get(string);
                if (bl2 && string.equals("method")) {
                    this.setMethodDefaults(string2);
                }
                this.m_properties.put(string, string2);
                continue;
            }
            if (!string.equals("cdata-section-elements")) continue;
            this.m_properties.put(string, (String)object + " " + (String)properties.get(string));
        }
    }

    public void copyFrom(OutputProperties outputProperties) throws TransformerException {
        this.checkDuplicates(outputProperties);
        this.copyFrom(outputProperties.getProperties());
    }

    private void checkDuplicates(OutputProperties outputProperties) throws TransformerException {
        if (null == this.m_propertiesLevels) {
            this.m_propertiesLevels = new Hashtable();
        }
        int n2 = outputProperties.getStylesheetComposed().getImportCountComposed();
        Properties properties = outputProperties.getProperties();
        Enumeration enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("cdata-section-elements")) continue;
            Integer n3 = (Integer)this.m_propertiesLevels.get(string);
            if (null == n3) {
                this.m_propertiesLevels.put(string, new Integer(n2));
                continue;
            }
            if (n2 < n3) continue;
            String string2 = (String)this.m_properties.get(string);
            String string3 = (String)outputProperties.m_properties.get(string);
            if ((string2 != null || string3 == null) && string2.equals(string3)) continue;
            String string4 = string + " can not be multiply defined at the same " + "import level! Old value = " + string2 + "; New value = " + string3;
            throw new TransformerException(string4, outputProperties);
        }
    }

    public boolean isLegalPropertyKey(String string) {
        return string.equals("cdata-section-elements") || string.equals("doctype-public") || string.equals("doctype-system") || string.equals("encoding") || string.equals("indent") || string.equals("media-type") || string.equals("method") || string.equals("omit-xml-declaration") || string.equals("standalone") || string.equals("version") || string.length() > 0 && string.charAt(0) == '{';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

