/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedList() {
        this.header.next = this.header.previous = this.header;
    }

    public LinkedList(Collection collection) {
        this();
        this.addAll(collection);
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public Object removeFirst() {
        Object object = this.header.next.element;
        this.remove(this.header.next);
        return object;
    }

    public Object removeLast() {
        Object object = this.header.previous.element;
        this.remove(this.header.previous);
        return object;
    }

    public void addFirst(Object object) {
        this.addBefore(object, this.header.next);
    }

    public void addLast(Object object) {
        this.addBefore(object, this.header);
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object object) {
        this.addBefore(object, this.header);
        return true;
    }

    public boolean remove(Object object) {
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    public boolean addAll(int n2, Collection collection) {
        int n3 = collection.size();
        if (n3 == 0) {
            return false;
        }
        ++this.modCount;
        Entry entry = n2 == this.size ? this.header : this.entry(n2);
        Entry entry2 = entry.previous;
        Iterator iterator = collection.iterator();
        int n4 = 0;
        while (n4 < n3) {
            Entry entry3;
            entry2.next = entry3 = new Entry(iterator.next(), entry, entry2);
            entry2 = entry3;
            ++n4;
        }
        entry.previous = entry2;
        this.size += n3;
        return true;
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    public Object get(int n2) {
        return this.entry((int)n2).element;
    }

    public Object set(int n2, Object object) {
        Entry entry = this.entry(n2);
        Object object2 = entry.element;
        entry.element = object;
        return object2;
    }

    public void add(int n2, Object object) {
        this.addBefore(object, n2 == this.size ? this.header : this.entry(n2));
    }

    public Object remove(int n2) {
        Entry entry = this.entry(n2);
        this.remove(entry);
        return entry.element;
    }

    private Entry entry(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        Entry entry = this.header;
        if (n2 < this.size >> 1) {
            int n3 = 0;
            while (n3 <= n2) {
                entry = entry.next;
                ++n3;
            }
        } else {
            int n4 = this.size;
            while (n4 > n2) {
                entry = entry.previous;
                --n4;
            }
        }
        return entry;
    }

    public int indexOf(Object object) {
        int n2 = 0;
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    return n2;
                }
                ++n2;
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    return n2;
                }
                ++n2;
                entry = entry.next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n2 = this.size;
        if (object == null) {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n2;
                if (entry.element == null) {
                    return n2;
                }
                entry = entry.previous;
            }
        } else {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n2;
                if (object.equals(entry.element)) {
                    return n2;
                }
                entry = entry.previous;
            }
        }
        return -1;
    }

    public ListIterator listIterator(int n2) {
        return new ListItr(n2);
    }

    private Entry addBefore(Object object, Entry entry) {
        Entry entry2;
        entry2.previous.next = entry2 = new Entry(object, entry, entry.previous);
        entry2.next.previous = entry2;
        ++this.size;
        ++this.modCount;
        return entry2;
    }

    private void remove(Entry entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        --this.size;
        ++this.modCount;
    }

    public Object clone() {
        LinkedList linkedList = null;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        linkedList.header.next = linkedList.header.previous = (linkedList.header = new Entry(null, null, null));
        linkedList.size = 0;
        linkedList.modCount = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            linkedList.add(entry.element);
            entry = entry.next;
        }
        return linkedList;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n2 = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n2++] = entry.element;
            entry = entry.next;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n2 = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n2++] = entry.element;
            entry = entry.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectOutputStream.writeObject(entry.element);
            entry = entry.next;
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.header.next = this.header.previous = (this.header = new Entry(null, null, null));
        int n3 = 0;
        while (n3 < n2) {
            this.add(objectInputStream.readObject());
            ++n3;
        }
    }

    private static class Entry {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object object, Entry entry, Entry entry2) {
            this.element = object;
            this.next = entry;
            this.previous = entry2;
        }
    }

    private class ListItr
    implements ListIterator {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int n2) {
            this.lastReturned = LinkedList.this.header;
            this.expectedModCount = LinkedList.this.modCount;
            if (n2 < 0 || n2 > LinkedList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + LinkedList.this.size);
            }
            if (n2 < LinkedList.this.size >> 1) {
                this.next = ((LinkedList)LinkedList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < n2) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = LinkedList.this.header;
                this.nextIndex = LinkedList.this.size;
                while (this.nextIndex > n2) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        public boolean hasNext() {
            return this.nextIndex != LinkedList.this.size;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == LinkedList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            this.checkForComodification();
            try {
                LinkedList.this.remove(this.lastReturned);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalStateException();
            }
            if (this.next == this.lastReturned) {
                this.next = this.lastReturned.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = LinkedList.this.header;
            ++this.expectedModCount;
        }

        public void set(Object object) {
            if (this.lastReturned == LinkedList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.element = object;
        }

        public void add(Object object) {
            this.checkForComodification();
            this.lastReturned = LinkedList.this.header;
            LinkedList.this.addBefore(object, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

