/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DropTargetContextPeer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class DropTargetContext
implements Serializable {
    private static final long serialVersionUID = -634158968993743371L;
    private DropTarget dropTarget;
    private transient DropTargetContextPeer dropTargetContextPeer;
    private transient Transferable transferable;

    DropTargetContext(DropTarget dropTarget) {
        this.dropTarget = dropTarget;
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public Component getComponent() {
        return this.dropTarget.getComponent();
    }

    public void addNotify(DropTargetContextPeer dropTargetContextPeer) {
        this.dropTargetContextPeer = dropTargetContextPeer;
    }

    public void removeNotify() {
        this.dropTargetContextPeer = null;
        this.transferable = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTargetActions(int n2) {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            DropTargetContextPeer dropTargetContextPeer2 = dropTargetContextPeer;
            synchronized (dropTargetContextPeer2) {
                dropTargetContextPeer.setTargetActions(n2);
                this.getDropTarget().doSetDefaultActions(n2);
            }
        } else {
            this.getDropTarget().doSetDefaultActions(n2);
        }
    }

    protected int getTargetActions() {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        return dropTargetContextPeer != null ? dropTargetContextPeer.getTargetActions() : this.dropTarget.getDefaultActions();
    }

    public void dropComplete(boolean bl2) throws InvalidDnDOperationException {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.dropComplete(bl2);
        }
    }

    protected void acceptDrag(int n2) {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.acceptDrag(n2);
        }
    }

    protected void rejectDrag() {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.rejectDrag();
        }
    }

    protected void acceptDrop(int n2) {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.acceptDrop(n2);
        }
    }

    protected void rejectDrop() {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer != null) {
            dropTargetContextPeer.rejectDrop();
        }
    }

    protected DataFlavor[] getCurrentDataFlavors() {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        return dropTargetContextPeer != null ? dropTargetContextPeer.getTransferDataFlavors() : new DataFlavor[]{};
    }

    protected List getCurrentDataFlavorsAsList() {
        return Arrays.asList(this.getCurrentDataFlavors());
    }

    protected boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.getCurrentDataFlavorsAsList().contains(dataFlavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Transferable getTransferable() throws InvalidDnDOperationException {
        DropTargetContextPeer dropTargetContextPeer = this.getDropTargetContextPeer();
        if (dropTargetContextPeer == null) {
            throw new InvalidDnDOperationException();
        }
        if (this.transferable == null) {
            Transferable transferable = dropTargetContextPeer.getTransferable();
            boolean bl2 = dropTargetContextPeer.isTransferableJVMLocal();
            DropTargetContext dropTargetContext = this;
            synchronized (dropTargetContext) {
                if (this.transferable == null) {
                    this.transferable = this.createTransferableProxy(transferable, bl2);
                }
            }
        }
        return this.transferable;
    }

    DropTargetContextPeer getDropTargetContextPeer() {
        return this.dropTargetContextPeer;
    }

    protected Transferable createTransferableProxy(Transferable transferable, boolean bl2) {
        return new TransferableProxy(transferable, bl2);
    }

    protected class TransferableProxy
    implements Transferable {
        protected Transferable transferable;
        protected boolean isLocal;
        private sun.awt.datatransfer.TransferableProxy proxy;

        TransferableProxy(Transferable transferable, boolean bl2) {
            this.proxy = new sun.awt.datatransfer.TransferableProxy(transferable, bl2);
            this.transferable = transferable;
            this.isLocal = bl2;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.proxy.getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return this.proxy.isDataFlavorSupported(dataFlavor);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            return this.proxy.getTransferData(dataFlavor);
        }
    }
}

