/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.basic.BasicRootPaneUI;

public class WindowsRootPaneUI
extends BasicRootPaneUI {
    private static final WindowsRootPaneUI windowsRootPaneUI = new WindowsRootPaneUI();
    private static final AltAction altAction = new AltAction();

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsRootPaneUI;
    }

    protected void installKeyboardActions(JRootPane jRootPane) {
        super.installKeyboardActions(jRootPane);
        InputMap inputMap = SwingUtilities.getUIInputMap(jRootPane, 2);
        if (inputMap == null) {
            inputMap = new InputMapUIResource();
            SwingUtilities.replaceUIInputMap(jRootPane, 2, inputMap);
        }
        inputMap.put(KeyStroke.getKeyStroke(18, 8, false), "repaint");
        ActionMap actionMap = SwingUtilities.getUIActionMap(jRootPane);
        if (actionMap == null) {
            actionMap = new ActionMapUIResource();
            SwingUtilities.replaceUIActionMap(jRootPane, actionMap);
        }
        actionMap.put("repaint", altAction);
    }

    protected void uninstallKeyboardActions(JRootPane jRootPane) {
        super.uninstallKeyboardActions(jRootPane);
        SwingUtilities.replaceUIInputMap(jRootPane, 2, null);
        SwingUtilities.replaceUIActionMap(jRootPane, null);
    }

    static class AltAction
    extends AbstractAction {
        AltAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowsLookAndFeel.setMnemonicHidden(false);
            Object object = actionEvent.getSource();
            if (object instanceof Component) {
                WindowsLookAndFeel.repaintRootPane((Component)object);
            }
        }
    }
}

