/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kcursor.h>
#include <klocale.h>
#include <kuniqueapplication.h>
#include <kwin.h>

#include <qtimer.h>

#include "kbabeldict.h"
#include "kbabelsplash.h"
#include "version.h"

class KBabelDictApplication : public KUniqueApplication
{
public:
    KBabelDictApplication();

    virtual int newInstance();

private:
    KBabelDict *topLevel;
};

KBabelDictApplication::KBabelDictApplication()
    : KUniqueApplication()
    , topLevel(0)
{
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    
    QTimer timer;
    QWidget *splash=0;
    bool showSplash=args->isSet("splash");
    if(showSplash)
    {
        timer.start(2000,true);
        KApplication::setOverrideCursor(KCursor::waitCursor());
        splash = KBabelSplash::splash();
    }
	
    topLevel = new KBabelDict();

    while(timer.isActive()) // let the user admire the splash screen ;-)
        processEvents();

	setTopWidget(topLevel);
    topLevel->show();

    if(splash)
    {
        delete splash;
    }
    if(showSplash)
    {
        KApplication::restoreOverrideCursor();
    }

    QObject::connect( topLevel, SIGNAL( destroyed() ),
	     this, SLOT( quit() ) );
}

int KBabelDictApplication::newInstance()
{
    KWin::setOnDesktop(topLevel->winId(),KWin::currentDesktop());
    KWin::setActiveWindow(topLevel->winId());
    return 0;
}



static KCmdLineOptions options[] =
{
   {"nosplash",I18N_NOOP("disable splashscreen at startup"),0},
   {0,0,0}
};


int main(int argc, char **argv)
{
    KLocale::setMainCatalogue("kbabel");
    
    KAboutData about("kbabeldict",I18N_NOOP("KBabel - Dictionary"),VERSION,
       I18N_NOOP("A dictionary for translators"),KAboutData::License_GPL,
       I18N_NOOP("(c) 2000,2001,2002 The KBabeldict developers"),0,"http://i18n.kde.org/tools/kbabel");

    about.addAuthor("Matthias Kiefer",I18N_NOOP("Original author"),"kiefer@kde.org");
    about.addAuthor("Stanislav Visnovsky",I18N_NOOP("Current maintainer"),"visnovsky@kde.org");
    
    about.setTranslator( I18N_NOOP("_: NAME OF TRANSLATORS\nYour names")
	, I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

    // Initialize command line args
    KCmdLineArgs::init(argc, argv, &about);

    // Tell which options are supported
    KCmdLineArgs::addCmdLineOptions( options );

    // Add options from other components
    KUniqueApplication::addCmdLineOptions();
    
    if(!KUniqueApplication::start())
    {
       return 0;
    }
    
    KBabelDictApplication app;

    return app.exec();
}
